<?php

namespace helloworld\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Say ServiceType
 * @subpackage Services
 */
class Say extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named sayHello
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param sayHello $sayHello
     * @return sayHelloResponse|bool
     */
    public function sayHello($sayHello)
    {
        try {
            $this->setResult($this->getSoapClient()->sayHello($sayHello));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return sayHelloResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
