<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfKategori ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfKategori
 * @subpackage Arrays
 */
class ArrayOfKategori extends AbstractStructArrayBase
{
    /**
     * The Kategori
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Kategori[]
     */
    public $Kategori;
    /**
     * Constructor method for ArrayOfKategori
     * @uses ArrayOfKategori::setKategori()
     * @param \StructType\Kategori[] $kategori
     */
    public function __construct(array $kategori = array())
    {
        $this
            ->setKategori($kategori);
    }
    /**
     * Get Kategori value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Kategori[]|null
     */
    public function getKategori()
    {
        return isset($this->Kategori) ? $this->Kategori : null;
    }
    /**
     * This method is responsible for validating the values passed to the setKategori method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKategori method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKategoriForArrayConstraintsFromSetKategori(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfKategoriKategoriItem) {
            // validation for constraint: itemType
            if (!$arrayOfKategoriKategoriItem instanceof \StructType\Kategori) {
                $invalidValues[] = is_object($arrayOfKategoriKategoriItem) ? get_class($arrayOfKategoriKategoriItem) : sprintf('%s(%s)', gettype($arrayOfKategoriKategoriItem), var_export($arrayOfKategoriKategoriItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Kategori property can only contain items of type \StructType\Kategori, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Kategori value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Kategori[] $kategori
     * @return \ArrayType\ArrayOfKategori
     */
    public function setKategori(array $kategori = array())
    {
        // validation for constraint: array
        if ('' !== ($kategoriArrayErrorMessage = self::validateKategoriForArrayConstraintsFromSetKategori($kategori))) {
            throw new \InvalidArgumentException($kategoriArrayErrorMessage, __LINE__);
        }
        if (is_null($kategori) || (is_array($kategori) && empty($kategori))) {
            unset($this->Kategori);
        } else {
            $this->Kategori = $kategori;
        }
        return $this;
    }
    /**
     * Add item to Kategori value
     * @throws \InvalidArgumentException
     * @param \StructType\Kategori $item
     * @return \ArrayType\ArrayOfKategori
     */
    public function addToKategori(\StructType\Kategori $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Kategori) {
            throw new \InvalidArgumentException(sprintf('The Kategori property can only contain items of type \StructType\Kategori, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Kategori[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Kategori|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Kategori|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Kategori|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Kategori|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Kategori|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Kategori
     */
    public function getAttributeName()
    {
        return 'Kategori';
    }
}
