<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VaryasyonOzellik StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:VaryasyonOzellik
 * @subpackage Structs
 */
class VaryasyonOzellik extends AbstractStructBase
{
    /**
     * The Deger
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Deger;
    /**
     * The EkSecenekId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EkSecenekId;
    /**
     * The EkSecenekTipiId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EkSecenekTipiId;
    /**
     * The RenkKodu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RenkKodu;
    /**
     * The Tanim
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Tanim;
    /**
     * The Tur
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Tur;
    /**
     * The XmlKod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $XmlKod;
    /**
     * Constructor method for VaryasyonOzellik
     * @uses VaryasyonOzellik::setDeger()
     * @uses VaryasyonOzellik::setEkSecenekId()
     * @uses VaryasyonOzellik::setEkSecenekTipiId()
     * @uses VaryasyonOzellik::setRenkKodu()
     * @uses VaryasyonOzellik::setTanim()
     * @uses VaryasyonOzellik::setTur()
     * @uses VaryasyonOzellik::setXmlKod()
     * @param string $deger
     * @param int $ekSecenekId
     * @param int $ekSecenekTipiId
     * @param string $renkKodu
     * @param string $tanim
     * @param string $tur
     * @param string $xmlKod
     */
    public function __construct($deger = null, $ekSecenekId = null, $ekSecenekTipiId = null, $renkKodu = null, $tanim = null, $tur = null, $xmlKod = null)
    {
        $this
            ->setDeger($deger)
            ->setEkSecenekId($ekSecenekId)
            ->setEkSecenekTipiId($ekSecenekTipiId)
            ->setRenkKodu($renkKodu)
            ->setTanim($tanim)
            ->setTur($tur)
            ->setXmlKod($xmlKod);
    }
    /**
     * Get Deger value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeger()
    {
        return isset($this->Deger) ? $this->Deger : null;
    }
    /**
     * Set Deger value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deger
     * @return \StructType\VaryasyonOzellik
     */
    public function setDeger($deger = null)
    {
        // validation for constraint: string
        if (!is_null($deger) && !is_string($deger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deger, true), gettype($deger)), __LINE__);
        }
        if (is_null($deger) || (is_array($deger) && empty($deger))) {
            unset($this->Deger);
        } else {
            $this->Deger = $deger;
        }
        return $this;
    }
    /**
     * Get EkSecenekId value
     * @return int|null
     */
    public function getEkSecenekId()
    {
        return $this->EkSecenekId;
    }
    /**
     * Set EkSecenekId value
     * @param int $ekSecenekId
     * @return \StructType\VaryasyonOzellik
     */
    public function setEkSecenekId($ekSecenekId = null)
    {
        // validation for constraint: int
        if (!is_null($ekSecenekId) && !(is_int($ekSecenekId) || ctype_digit($ekSecenekId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ekSecenekId, true), gettype($ekSecenekId)), __LINE__);
        }
        $this->EkSecenekId = $ekSecenekId;
        return $this;
    }
    /**
     * Get EkSecenekTipiId value
     * @return int|null
     */
    public function getEkSecenekTipiId()
    {
        return $this->EkSecenekTipiId;
    }
    /**
     * Set EkSecenekTipiId value
     * @param int $ekSecenekTipiId
     * @return \StructType\VaryasyonOzellik
     */
    public function setEkSecenekTipiId($ekSecenekTipiId = null)
    {
        // validation for constraint: int
        if (!is_null($ekSecenekTipiId) && !(is_int($ekSecenekTipiId) || ctype_digit($ekSecenekTipiId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ekSecenekTipiId, true), gettype($ekSecenekTipiId)), __LINE__);
        }
        $this->EkSecenekTipiId = $ekSecenekTipiId;
        return $this;
    }
    /**
     * Get RenkKodu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenkKodu()
    {
        return isset($this->RenkKodu) ? $this->RenkKodu : null;
    }
    /**
     * Set RenkKodu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $renkKodu
     * @return \StructType\VaryasyonOzellik
     */
    public function setRenkKodu($renkKodu = null)
    {
        // validation for constraint: string
        if (!is_null($renkKodu) && !is_string($renkKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renkKodu, true), gettype($renkKodu)), __LINE__);
        }
        if (is_null($renkKodu) || (is_array($renkKodu) && empty($renkKodu))) {
            unset($this->RenkKodu);
        } else {
            $this->RenkKodu = $renkKodu;
        }
        return $this;
    }
    /**
     * Get Tanim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTanim()
    {
        return isset($this->Tanim) ? $this->Tanim : null;
    }
    /**
     * Set Tanim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tanim
     * @return \StructType\VaryasyonOzellik
     */
    public function setTanim($tanim = null)
    {
        // validation for constraint: string
        if (!is_null($tanim) && !is_string($tanim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tanim, true), gettype($tanim)), __LINE__);
        }
        if (is_null($tanim) || (is_array($tanim) && empty($tanim))) {
            unset($this->Tanim);
        } else {
            $this->Tanim = $tanim;
        }
        return $this;
    }
    /**
     * Get Tur value
     * @return string|null
     */
    public function getTur()
    {
        return $this->Tur;
    }
    /**
     * Set Tur value
     * @uses \EnumType\BLEnums_VaryasyonTuru::valueIsValid()
     * @uses \EnumType\BLEnums_VaryasyonTuru::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tur
     * @return \StructType\VaryasyonOzellik
     */
    public function setTur($tur = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BLEnums_VaryasyonTuru::valueIsValid($tur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BLEnums_VaryasyonTuru', is_array($tur) ? implode(', ', $tur) : var_export($tur, true), implode(', ', \EnumType\BLEnums_VaryasyonTuru::getValidValues())), __LINE__);
        }
        $this->Tur = $tur;
        return $this;
    }
    /**
     * Get XmlKod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getXmlKod()
    {
        return isset($this->XmlKod) ? $this->XmlKod : null;
    }
    /**
     * Set XmlKod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $xmlKod
     * @return \StructType\VaryasyonOzellik
     */
    public function setXmlKod($xmlKod = null)
    {
        // validation for constraint: string
        if (!is_null($xmlKod) && !is_string($xmlKod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xmlKod, true), gettype($xmlKod)), __LINE__);
        }
        if (is_null($xmlKod) || (is_array($xmlKod) && empty($xmlKod))) {
            unset($this->XmlKod);
        } else {
            $this->XmlKod = $xmlKod;
        }
        return $this;
    }
}
