<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UrunFiyatFiltre StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UrunFiyatFiltre
 * @subpackage Structs
 */
class UrunFiyatFiltre extends AbstractStructBase
{
    /**
     * The FiyatBaslangic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $FiyatBaslangic;
    /**
     * The FiyatBitis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $FiyatBitis;
    /**
     * The FiyatTipi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FiyatTipi;
    /**
     * Constructor method for UrunFiyatFiltre
     * @uses UrunFiyatFiltre::setFiyatBaslangic()
     * @uses UrunFiyatFiltre::setFiyatBitis()
     * @uses UrunFiyatFiltre::setFiyatTipi()
     * @param float $fiyatBaslangic
     * @param float $fiyatBitis
     * @param string $fiyatTipi
     */
    public function __construct($fiyatBaslangic = null, $fiyatBitis = null, $fiyatTipi = null)
    {
        $this
            ->setFiyatBaslangic($fiyatBaslangic)
            ->setFiyatBitis($fiyatBitis)
            ->setFiyatTipi($fiyatTipi);
    }
    /**
     * Get FiyatBaslangic value
     * @return float|null
     */
    public function getFiyatBaslangic()
    {
        return $this->FiyatBaslangic;
    }
    /**
     * Set FiyatBaslangic value
     * @param float $fiyatBaslangic
     * @return \StructType\UrunFiyatFiltre
     */
    public function setFiyatBaslangic($fiyatBaslangic = null)
    {
        // validation for constraint: float
        if (!is_null($fiyatBaslangic) && !(is_float($fiyatBaslangic) || is_numeric($fiyatBaslangic))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fiyatBaslangic, true), gettype($fiyatBaslangic)), __LINE__);
        }
        $this->FiyatBaslangic = $fiyatBaslangic;
        return $this;
    }
    /**
     * Get FiyatBitis value
     * @return float|null
     */
    public function getFiyatBitis()
    {
        return $this->FiyatBitis;
    }
    /**
     * Set FiyatBitis value
     * @param float $fiyatBitis
     * @return \StructType\UrunFiyatFiltre
     */
    public function setFiyatBitis($fiyatBitis = null)
    {
        // validation for constraint: float
        if (!is_null($fiyatBitis) && !(is_float($fiyatBitis) || is_numeric($fiyatBitis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fiyatBitis, true), gettype($fiyatBitis)), __LINE__);
        }
        $this->FiyatBitis = $fiyatBitis;
        return $this;
    }
    /**
     * Get FiyatTipi value
     * @return string|null
     */
    public function getFiyatTipi()
    {
        return $this->FiyatTipi;
    }
    /**
     * Set FiyatTipi value
     * @uses \EnumType\UrunFiyatTipi::valueIsValid()
     * @uses \EnumType\UrunFiyatTipi::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fiyatTipi
     * @return \StructType\UrunFiyatFiltre
     */
    public function setFiyatTipi($fiyatTipi = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UrunFiyatTipi::valueIsValid($fiyatTipi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\UrunFiyatTipi', is_array($fiyatTipi) ? implode(', ', $fiyatTipi) : var_export($fiyatTipi, true), implode(', ', \EnumType\UrunFiyatTipi::getValidValues())), __LINE__);
        }
        $this->FiyatTipi = $fiyatTipi;
        return $this;
    }
}
