<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MarketPlaceGrupAyar StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MarketPlaceGrupAyar
 * @subpackage Structs
 */
class MarketPlaceGrupAyar extends AbstractStructBase
{
    /**
     * The Aktif
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktif;
    /**
     * The EksiStokAdedi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $EksiStokAdedi;
    /**
     * The GrupAdi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GrupAdi;
    /**
     * The KomisyonDeger
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $KomisyonDeger;
    /**
     * The KomisyonTip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $KomisyonTip;
    /**
     * Constructor method for MarketPlaceGrupAyar
     * @uses MarketPlaceGrupAyar::setAktif()
     * @uses MarketPlaceGrupAyar::setEksiStokAdedi()
     * @uses MarketPlaceGrupAyar::setGrupAdi()
     * @uses MarketPlaceGrupAyar::setKomisyonDeger()
     * @uses MarketPlaceGrupAyar::setKomisyonTip()
     * @param bool $aktif
     * @param float $eksiStokAdedi
     * @param string $grupAdi
     * @param float $komisyonDeger
     * @param int $komisyonTip
     */
    public function __construct($aktif = null, $eksiStokAdedi = null, $grupAdi = null, $komisyonDeger = null, $komisyonTip = null)
    {
        $this
            ->setAktif($aktif)
            ->setEksiStokAdedi($eksiStokAdedi)
            ->setGrupAdi($grupAdi)
            ->setKomisyonDeger($komisyonDeger)
            ->setKomisyonTip($komisyonTip);
    }
    /**
     * Get Aktif value
     * @return bool|null
     */
    public function getAktif()
    {
        return $this->Aktif;
    }
    /**
     * Set Aktif value
     * @param bool $aktif
     * @return \StructType\MarketPlaceGrupAyar
     */
    public function setAktif($aktif = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktif) && !is_bool($aktif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aktif, true), gettype($aktif)), __LINE__);
        }
        $this->Aktif = $aktif;
        return $this;
    }
    /**
     * Get EksiStokAdedi value
     * @return float|null
     */
    public function getEksiStokAdedi()
    {
        return $this->EksiStokAdedi;
    }
    /**
     * Set EksiStokAdedi value
     * @param float $eksiStokAdedi
     * @return \StructType\MarketPlaceGrupAyar
     */
    public function setEksiStokAdedi($eksiStokAdedi = null)
    {
        // validation for constraint: float
        if (!is_null($eksiStokAdedi) && !(is_float($eksiStokAdedi) || is_numeric($eksiStokAdedi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($eksiStokAdedi, true), gettype($eksiStokAdedi)), __LINE__);
        }
        $this->EksiStokAdedi = $eksiStokAdedi;
        return $this;
    }
    /**
     * Get GrupAdi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGrupAdi()
    {
        return isset($this->GrupAdi) ? $this->GrupAdi : null;
    }
    /**
     * Set GrupAdi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $grupAdi
     * @return \StructType\MarketPlaceGrupAyar
     */
    public function setGrupAdi($grupAdi = null)
    {
        // validation for constraint: string
        if (!is_null($grupAdi) && !is_string($grupAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($grupAdi, true), gettype($grupAdi)), __LINE__);
        }
        if (is_null($grupAdi) || (is_array($grupAdi) && empty($grupAdi))) {
            unset($this->GrupAdi);
        } else {
            $this->GrupAdi = $grupAdi;
        }
        return $this;
    }
    /**
     * Get KomisyonDeger value
     * @return float|null
     */
    public function getKomisyonDeger()
    {
        return $this->KomisyonDeger;
    }
    /**
     * Set KomisyonDeger value
     * @param float $komisyonDeger
     * @return \StructType\MarketPlaceGrupAyar
     */
    public function setKomisyonDeger($komisyonDeger = null)
    {
        // validation for constraint: float
        if (!is_null($komisyonDeger) && !(is_float($komisyonDeger) || is_numeric($komisyonDeger))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($komisyonDeger, true), gettype($komisyonDeger)), __LINE__);
        }
        $this->KomisyonDeger = $komisyonDeger;
        return $this;
    }
    /**
     * Get KomisyonTip value
     * @return int|null
     */
    public function getKomisyonTip()
    {
        return $this->KomisyonTip;
    }
    /**
     * Set KomisyonTip value
     * @param int $komisyonTip
     * @return \StructType\MarketPlaceGrupAyar
     */
    public function setKomisyonTip($komisyonTip = null)
    {
        // validation for constraint: int
        if (!is_null($komisyonTip) && !(is_int($komisyonTip) || ctype_digit($komisyonTip))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($komisyonTip, true), gettype($komisyonTip)), __LINE__);
        }
        $this->KomisyonTip = $komisyonTip;
        return $this;
    }
}
