<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaveUrunKartiVideoRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SaveUrunKartiVideoRequest
 * @subpackage Structs
 */
class SaveUrunKartiVideoRequest extends AbstractStructBase
{
    /**
     * The UrunKartiId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UrunKartiId;
    /**
     * The VideoAyar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\UrunKartiVideo
     */
    public $VideoAyar;
    /**
     * Constructor method for SaveUrunKartiVideoRequest
     * @uses SaveUrunKartiVideoRequest::setUrunKartiId()
     * @uses SaveUrunKartiVideoRequest::setVideoAyar()
     * @param int $urunKartiId
     * @param \StructType\UrunKartiVideo $videoAyar
     */
    public function __construct($urunKartiId = null, \StructType\UrunKartiVideo $videoAyar = null)
    {
        $this
            ->setUrunKartiId($urunKartiId)
            ->setVideoAyar($videoAyar);
    }
    /**
     * Get UrunKartiId value
     * @return int|null
     */
    public function getUrunKartiId()
    {
        return $this->UrunKartiId;
    }
    /**
     * Set UrunKartiId value
     * @param int $urunKartiId
     * @return \StructType\SaveUrunKartiVideoRequest
     */
    public function setUrunKartiId($urunKartiId = null)
    {
        // validation for constraint: int
        if (!is_null($urunKartiId) && !(is_int($urunKartiId) || ctype_digit($urunKartiId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($urunKartiId, true), gettype($urunKartiId)), __LINE__);
        }
        $this->UrunKartiId = $urunKartiId;
        return $this;
    }
    /**
     * Get VideoAyar value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\UrunKartiVideo|null
     */
    public function getVideoAyar()
    {
        return isset($this->VideoAyar) ? $this->VideoAyar : null;
    }
    /**
     * Set VideoAyar value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\UrunKartiVideo $videoAyar
     * @return \StructType\SaveUrunKartiVideoRequest
     */
    public function setVideoAyar(\StructType\UrunKartiVideo $videoAyar = null)
    {
        if (is_null($videoAyar) || (is_array($videoAyar) && empty($videoAyar))) {
            unset($this->VideoAyar);
        } else {
            $this->VideoAyar = $videoAyar;
        }
        return $this;
    }
}
