<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfResim ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfResim
 * @subpackage Arrays
 */
class ArrayOfResim extends AbstractStructArrayBase
{
    /**
     * The Resim
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Resim[]
     */
    public $Resim;
    /**
     * Constructor method for ArrayOfResim
     * @uses ArrayOfResim::setResim()
     * @param \StructType\Resim[] $resim
     */
    public function __construct(array $resim = array())
    {
        $this
            ->setResim($resim);
    }
    /**
     * Get Resim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Resim[]|null
     */
    public function getResim()
    {
        return isset($this->Resim) ? $this->Resim : null;
    }
    /**
     * This method is responsible for validating the values passed to the setResim method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResim method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResimForArrayConstraintsFromSetResim(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfResimResimItem) {
            // validation for constraint: itemType
            if (!$arrayOfResimResimItem instanceof \StructType\Resim) {
                $invalidValues[] = is_object($arrayOfResimResimItem) ? get_class($arrayOfResimResimItem) : sprintf('%s(%s)', gettype($arrayOfResimResimItem), var_export($arrayOfResimResimItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Resim property can only contain items of type \StructType\Resim, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Resim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Resim[] $resim
     * @return \ArrayType\ArrayOfResim
     */
    public function setResim(array $resim = array())
    {
        // validation for constraint: array
        if ('' !== ($resimArrayErrorMessage = self::validateResimForArrayConstraintsFromSetResim($resim))) {
            throw new \InvalidArgumentException($resimArrayErrorMessage, __LINE__);
        }
        if (is_null($resim) || (is_array($resim) && empty($resim))) {
            unset($this->Resim);
        } else {
            $this->Resim = $resim;
        }
        return $this;
    }
    /**
     * Add item to Resim value
     * @throws \InvalidArgumentException
     * @param \StructType\Resim $item
     * @return \ArrayType\ArrayOfResim
     */
    public function addToResim(\StructType\Resim $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resim) {
            throw new \InvalidArgumentException(sprintf('The Resim property can only contain items of type \StructType\Resim, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Resim[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Resim|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Resim|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Resim|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Resim|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Resim|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Resim
     */
    public function getAttributeName()
    {
        return 'Resim';
    }
}
