<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMarka ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfMarka
 * @subpackage Arrays
 */
class ArrayOfMarka extends AbstractStructArrayBase
{
    /**
     * The Marka
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Marka[]
     */
    public $Marka;
    /**
     * Constructor method for ArrayOfMarka
     * @uses ArrayOfMarka::setMarka()
     * @param \StructType\Marka[] $marka
     */
    public function __construct(array $marka = array())
    {
        $this
            ->setMarka($marka);
    }
    /**
     * Get Marka value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Marka[]|null
     */
    public function getMarka()
    {
        return isset($this->Marka) ? $this->Marka : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMarka method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMarka method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMarkaForArrayConstraintsFromSetMarka(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMarkaMarkaItem) {
            // validation for constraint: itemType
            if (!$arrayOfMarkaMarkaItem instanceof \StructType\Marka) {
                $invalidValues[] = is_object($arrayOfMarkaMarkaItem) ? get_class($arrayOfMarkaMarkaItem) : sprintf('%s(%s)', gettype($arrayOfMarkaMarkaItem), var_export($arrayOfMarkaMarkaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Marka property can only contain items of type \StructType\Marka, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Marka value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Marka[] $marka
     * @return \ArrayType\ArrayOfMarka
     */
    public function setMarka(array $marka = array())
    {
        // validation for constraint: array
        if ('' !== ($markaArrayErrorMessage = self::validateMarkaForArrayConstraintsFromSetMarka($marka))) {
            throw new \InvalidArgumentException($markaArrayErrorMessage, __LINE__);
        }
        if (is_null($marka) || (is_array($marka) && empty($marka))) {
            unset($this->Marka);
        } else {
            $this->Marka = $marka;
        }
        return $this;
    }
    /**
     * Add item to Marka value
     * @throws \InvalidArgumentException
     * @param \StructType\Marka $item
     * @return \ArrayType\ArrayOfMarka
     */
    public function addToMarka(\StructType\Marka $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Marka) {
            throw new \InvalidArgumentException(sprintf('The Marka property can only contain items of type \StructType\Marka, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Marka[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Marka|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Marka|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Marka|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Marka|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Marka|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Marka
     */
    public function getAttributeName()
    {
        return 'Marka';
    }
}
