<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Etiket StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Etiket
 * @subpackage Structs
 */
class Etiket extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The Resim
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Resim;
    /**
     * The SeoAnahtarKelime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeoAnahtarKelime;
    /**
     * The SeoSayfaAciklama
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeoSayfaAciklama;
    /**
     * The SeoSayfaBaslik
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeoSayfaBaslik;
    /**
     * The Tanim
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Tanim;
    /**
     * The Url
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Url;
    /**
     * Constructor method for Etiket
     * @uses Etiket::setID()
     * @uses Etiket::setResim()
     * @uses Etiket::setSeoAnahtarKelime()
     * @uses Etiket::setSeoSayfaAciklama()
     * @uses Etiket::setSeoSayfaBaslik()
     * @uses Etiket::setTanim()
     * @uses Etiket::setUrl()
     * @param int $iD
     * @param string $resim
     * @param string $seoAnahtarKelime
     * @param string $seoSayfaAciklama
     * @param string $seoSayfaBaslik
     * @param string $tanim
     * @param string $url
     */
    public function __construct($iD = null, $resim = null, $seoAnahtarKelime = null, $seoSayfaAciklama = null, $seoSayfaBaslik = null, $tanim = null, $url = null)
    {
        $this
            ->setID($iD)
            ->setResim($resim)
            ->setSeoAnahtarKelime($seoAnahtarKelime)
            ->setSeoSayfaAciklama($seoSayfaAciklama)
            ->setSeoSayfaBaslik($seoSayfaBaslik)
            ->setTanim($tanim)
            ->setUrl($url);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\Etiket
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Resim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResim()
    {
        return isset($this->Resim) ? $this->Resim : null;
    }
    /**
     * Set Resim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resim
     * @return \StructType\Etiket
     */
    public function setResim($resim = null)
    {
        // validation for constraint: string
        if (!is_null($resim) && !is_string($resim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resim, true), gettype($resim)), __LINE__);
        }
        if (is_null($resim) || (is_array($resim) && empty($resim))) {
            unset($this->Resim);
        } else {
            $this->Resim = $resim;
        }
        return $this;
    }
    /**
     * Get SeoAnahtarKelime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeoAnahtarKelime()
    {
        return isset($this->SeoAnahtarKelime) ? $this->SeoAnahtarKelime : null;
    }
    /**
     * Set SeoAnahtarKelime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seoAnahtarKelime
     * @return \StructType\Etiket
     */
    public function setSeoAnahtarKelime($seoAnahtarKelime = null)
    {
        // validation for constraint: string
        if (!is_null($seoAnahtarKelime) && !is_string($seoAnahtarKelime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seoAnahtarKelime, true), gettype($seoAnahtarKelime)), __LINE__);
        }
        if (is_null($seoAnahtarKelime) || (is_array($seoAnahtarKelime) && empty($seoAnahtarKelime))) {
            unset($this->SeoAnahtarKelime);
        } else {
            $this->SeoAnahtarKelime = $seoAnahtarKelime;
        }
        return $this;
    }
    /**
     * Get SeoSayfaAciklama value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeoSayfaAciklama()
    {
        return isset($this->SeoSayfaAciklama) ? $this->SeoSayfaAciklama : null;
    }
    /**
     * Set SeoSayfaAciklama value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seoSayfaAciklama
     * @return \StructType\Etiket
     */
    public function setSeoSayfaAciklama($seoSayfaAciklama = null)
    {
        // validation for constraint: string
        if (!is_null($seoSayfaAciklama) && !is_string($seoSayfaAciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seoSayfaAciklama, true), gettype($seoSayfaAciklama)), __LINE__);
        }
        if (is_null($seoSayfaAciklama) || (is_array($seoSayfaAciklama) && empty($seoSayfaAciklama))) {
            unset($this->SeoSayfaAciklama);
        } else {
            $this->SeoSayfaAciklama = $seoSayfaAciklama;
        }
        return $this;
    }
    /**
     * Get SeoSayfaBaslik value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeoSayfaBaslik()
    {
        return isset($this->SeoSayfaBaslik) ? $this->SeoSayfaBaslik : null;
    }
    /**
     * Set SeoSayfaBaslik value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seoSayfaBaslik
     * @return \StructType\Etiket
     */
    public function setSeoSayfaBaslik($seoSayfaBaslik = null)
    {
        // validation for constraint: string
        if (!is_null($seoSayfaBaslik) && !is_string($seoSayfaBaslik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seoSayfaBaslik, true), gettype($seoSayfaBaslik)), __LINE__);
        }
        if (is_null($seoSayfaBaslik) || (is_array($seoSayfaBaslik) && empty($seoSayfaBaslik))) {
            unset($this->SeoSayfaBaslik);
        } else {
            $this->SeoSayfaBaslik = $seoSayfaBaslik;
        }
        return $this;
    }
    /**
     * Get Tanim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTanim()
    {
        return isset($this->Tanim) ? $this->Tanim : null;
    }
    /**
     * Set Tanim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tanim
     * @return \StructType\Etiket
     */
    public function setTanim($tanim = null)
    {
        // validation for constraint: string
        if (!is_null($tanim) && !is_string($tanim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tanim, true), gettype($tanim)), __LINE__);
        }
        if (is_null($tanim) || (is_array($tanim) && empty($tanim))) {
            unset($this->Tanim);
        } else {
            $this->Tanim = $tanim;
        }
        return $this;
    }
    /**
     * Get Url value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrl()
    {
        return isset($this->Url) ? $this->Url : null;
    }
    /**
     * Set Url value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $url
     * @return \StructType\Etiket
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        if (is_null($url) || (is_array($url) && empty($url))) {
            unset($this->Url);
        } else {
            $this->Url = $url;
        }
        return $this;
    }
}
