<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SelectTedarikci StructType
 * @subpackage Structs
 */
class SelectTedarikci extends AbstractStructBase
{
    /**
     * The UyeKodu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UyeKodu;
    /**
     * The tedarikciID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $tedarikciID;
    /**
     * The kategoriID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $kategoriID;
    /**
     * Constructor method for SelectTedarikci
     * @uses SelectTedarikci::setUyeKodu()
     * @uses SelectTedarikci::setTedarikciID()
     * @uses SelectTedarikci::setKategoriID()
     * @param string $uyeKodu
     * @param int $tedarikciID
     * @param int $kategoriID
     */
    public function __construct($uyeKodu = null, $tedarikciID = null, $kategoriID = null)
    {
        $this
            ->setUyeKodu($uyeKodu)
            ->setTedarikciID($tedarikciID)
            ->setKategoriID($kategoriID);
    }
    /**
     * Get UyeKodu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUyeKodu()
    {
        return isset($this->UyeKodu) ? $this->UyeKodu : null;
    }
    /**
     * Set UyeKodu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uyeKodu
     * @return \StructType\SelectTedarikci
     */
    public function setUyeKodu($uyeKodu = null)
    {
        // validation for constraint: string
        if (!is_null($uyeKodu) && !is_string($uyeKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uyeKodu, true), gettype($uyeKodu)), __LINE__);
        }
        if (is_null($uyeKodu) || (is_array($uyeKodu) && empty($uyeKodu))) {
            unset($this->UyeKodu);
        } else {
            $this->UyeKodu = $uyeKodu;
        }
        return $this;
    }
    /**
     * Get tedarikciID value
     * @return int|null
     */
    public function getTedarikciID()
    {
        return $this->tedarikciID;
    }
    /**
     * Set tedarikciID value
     * @param int $tedarikciID
     * @return \StructType\SelectTedarikci
     */
    public function setTedarikciID($tedarikciID = null)
    {
        // validation for constraint: int
        if (!is_null($tedarikciID) && !(is_int($tedarikciID) || ctype_digit($tedarikciID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tedarikciID, true), gettype($tedarikciID)), __LINE__);
        }
        $this->tedarikciID = $tedarikciID;
        return $this;
    }
    /**
     * Get kategoriID value
     * @return int|null
     */
    public function getKategoriID()
    {
        return $this->kategoriID;
    }
    /**
     * Set kategoriID value
     * @param int $kategoriID
     * @return \StructType\SelectTedarikci
     */
    public function setKategoriID($kategoriID = null)
    {
        // validation for constraint: int
        if (!is_null($kategoriID) && !(is_int($kategoriID) || ctype_digit($kategoriID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kategoriID, true), gettype($kategoriID)), __LINE__);
        }
        $this->kategoriID = $kategoriID;
        return $this;
    }
}
