<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UrunYorum StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UrunYorum
 * @subpackage Structs
 */
class UrunYorum extends AbstractStructBase
{
    /**
     * The EklemeTarihi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EklemeTarihi;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The Isim
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Isim;
    /**
     * The Mail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Mail;
    /**
     * The Mesaj
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Mesaj;
    /**
     * The UrunAdi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UrunAdi;
    /**
     * The UrunKartiID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UrunKartiID;
    /**
     * The UyeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UyeID;
    /**
     * Constructor method for UrunYorum
     * @uses UrunYorum::setEklemeTarihi()
     * @uses UrunYorum::setID()
     * @uses UrunYorum::setIsim()
     * @uses UrunYorum::setMail()
     * @uses UrunYorum::setMesaj()
     * @uses UrunYorum::setUrunAdi()
     * @uses UrunYorum::setUrunKartiID()
     * @uses UrunYorum::setUyeID()
     * @param string $eklemeTarihi
     * @param int $iD
     * @param string $isim
     * @param string $mail
     * @param string $mesaj
     * @param string $urunAdi
     * @param int $urunKartiID
     * @param int $uyeID
     */
    public function __construct($eklemeTarihi = null, $iD = null, $isim = null, $mail = null, $mesaj = null, $urunAdi = null, $urunKartiID = null, $uyeID = null)
    {
        $this
            ->setEklemeTarihi($eklemeTarihi)
            ->setID($iD)
            ->setIsim($isim)
            ->setMail($mail)
            ->setMesaj($mesaj)
            ->setUrunAdi($urunAdi)
            ->setUrunKartiID($urunKartiID)
            ->setUyeID($uyeID);
    }
    /**
     * Get EklemeTarihi value
     * @return string|null
     */
    public function getEklemeTarihi()
    {
        return $this->EklemeTarihi;
    }
    /**
     * Set EklemeTarihi value
     * @param string $eklemeTarihi
     * @return \StructType\UrunYorum
     */
    public function setEklemeTarihi($eklemeTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($eklemeTarihi) && !is_string($eklemeTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eklemeTarihi, true), gettype($eklemeTarihi)), __LINE__);
        }
        $this->EklemeTarihi = $eklemeTarihi;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\UrunYorum
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Isim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIsim()
    {
        return isset($this->Isim) ? $this->Isim : null;
    }
    /**
     * Set Isim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $isim
     * @return \StructType\UrunYorum
     */
    public function setIsim($isim = null)
    {
        // validation for constraint: string
        if (!is_null($isim) && !is_string($isim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isim, true), gettype($isim)), __LINE__);
        }
        if (is_null($isim) || (is_array($isim) && empty($isim))) {
            unset($this->Isim);
        } else {
            $this->Isim = $isim;
        }
        return $this;
    }
    /**
     * Get Mail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMail()
    {
        return isset($this->Mail) ? $this->Mail : null;
    }
    /**
     * Set Mail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mail
     * @return \StructType\UrunYorum
     */
    public function setMail($mail = null)
    {
        // validation for constraint: string
        if (!is_null($mail) && !is_string($mail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mail, true), gettype($mail)), __LINE__);
        }
        if (is_null($mail) || (is_array($mail) && empty($mail))) {
            unset($this->Mail);
        } else {
            $this->Mail = $mail;
        }
        return $this;
    }
    /**
     * Get Mesaj value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMesaj()
    {
        return isset($this->Mesaj) ? $this->Mesaj : null;
    }
    /**
     * Set Mesaj value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mesaj
     * @return \StructType\UrunYorum
     */
    public function setMesaj($mesaj = null)
    {
        // validation for constraint: string
        if (!is_null($mesaj) && !is_string($mesaj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mesaj, true), gettype($mesaj)), __LINE__);
        }
        if (is_null($mesaj) || (is_array($mesaj) && empty($mesaj))) {
            unset($this->Mesaj);
        } else {
            $this->Mesaj = $mesaj;
        }
        return $this;
    }
    /**
     * Get UrunAdi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrunAdi()
    {
        return isset($this->UrunAdi) ? $this->UrunAdi : null;
    }
    /**
     * Set UrunAdi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $urunAdi
     * @return \StructType\UrunYorum
     */
    public function setUrunAdi($urunAdi = null)
    {
        // validation for constraint: string
        if (!is_null($urunAdi) && !is_string($urunAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urunAdi, true), gettype($urunAdi)), __LINE__);
        }
        if (is_null($urunAdi) || (is_array($urunAdi) && empty($urunAdi))) {
            unset($this->UrunAdi);
        } else {
            $this->UrunAdi = $urunAdi;
        }
        return $this;
    }
    /**
     * Get UrunKartiID value
     * @return int|null
     */
    public function getUrunKartiID()
    {
        return $this->UrunKartiID;
    }
    /**
     * Set UrunKartiID value
     * @param int $urunKartiID
     * @return \StructType\UrunYorum
     */
    public function setUrunKartiID($urunKartiID = null)
    {
        // validation for constraint: int
        if (!is_null($urunKartiID) && !(is_int($urunKartiID) || ctype_digit($urunKartiID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($urunKartiID, true), gettype($urunKartiID)), __LINE__);
        }
        $this->UrunKartiID = $urunKartiID;
        return $this;
    }
    /**
     * Get UyeID value
     * @return int|null
     */
    public function getUyeID()
    {
        return $this->UyeID;
    }
    /**
     * Set UyeID value
     * @param int $uyeID
     * @return \StructType\UrunYorum
     */
    public function setUyeID($uyeID = null)
    {
        // validation for constraint: int
        if (!is_null($uyeID) && !(is_int($uyeID) || ctype_digit($uyeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uyeID, true), gettype($uyeID)), __LINE__);
        }
        $this->UyeID = $uyeID;
        return $this;
    }
}
