<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTaksitSecenekleri StructType
 * @subpackage Structs
 */
class GetTaksitSecenekleri extends AbstractStructBase
{
    /**
     * The UyeKodu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UyeKodu;
    /**
     * The Tutar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Tutar;
    /**
     * The MaximumTaksitSayisi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MaximumTaksitSayisi;
    /**
     * The DovizKodu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DovizKodu;
    /**
     * Constructor method for GetTaksitSecenekleri
     * @uses GetTaksitSecenekleri::setUyeKodu()
     * @uses GetTaksitSecenekleri::setTutar()
     * @uses GetTaksitSecenekleri::setMaximumTaksitSayisi()
     * @uses GetTaksitSecenekleri::setDovizKodu()
     * @param string $uyeKodu
     * @param float $tutar
     * @param int $maximumTaksitSayisi
     * @param string $dovizKodu
     */
    public function __construct($uyeKodu = null, $tutar = null, $maximumTaksitSayisi = null, $dovizKodu = null)
    {
        $this
            ->setUyeKodu($uyeKodu)
            ->setTutar($tutar)
            ->setMaximumTaksitSayisi($maximumTaksitSayisi)
            ->setDovizKodu($dovizKodu);
    }
    /**
     * Get UyeKodu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUyeKodu()
    {
        return isset($this->UyeKodu) ? $this->UyeKodu : null;
    }
    /**
     * Set UyeKodu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uyeKodu
     * @return \StructType\GetTaksitSecenekleri
     */
    public function setUyeKodu($uyeKodu = null)
    {
        // validation for constraint: string
        if (!is_null($uyeKodu) && !is_string($uyeKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uyeKodu, true), gettype($uyeKodu)), __LINE__);
        }
        if (is_null($uyeKodu) || (is_array($uyeKodu) && empty($uyeKodu))) {
            unset($this->UyeKodu);
        } else {
            $this->UyeKodu = $uyeKodu;
        }
        return $this;
    }
    /**
     * Get Tutar value
     * @return float|null
     */
    public function getTutar()
    {
        return $this->Tutar;
    }
    /**
     * Set Tutar value
     * @param float $tutar
     * @return \StructType\GetTaksitSecenekleri
     */
    public function setTutar($tutar = null)
    {
        // validation for constraint: float
        if (!is_null($tutar) && !(is_float($tutar) || is_numeric($tutar))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tutar, true), gettype($tutar)), __LINE__);
        }
        $this->Tutar = $tutar;
        return $this;
    }
    /**
     * Get MaximumTaksitSayisi value
     * @return int|null
     */
    public function getMaximumTaksitSayisi()
    {
        return $this->MaximumTaksitSayisi;
    }
    /**
     * Set MaximumTaksitSayisi value
     * @param int $maximumTaksitSayisi
     * @return \StructType\GetTaksitSecenekleri
     */
    public function setMaximumTaksitSayisi($maximumTaksitSayisi = null)
    {
        // validation for constraint: int
        if (!is_null($maximumTaksitSayisi) && !(is_int($maximumTaksitSayisi) || ctype_digit($maximumTaksitSayisi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumTaksitSayisi, true), gettype($maximumTaksitSayisi)), __LINE__);
        }
        $this->MaximumTaksitSayisi = $maximumTaksitSayisi;
        return $this;
    }
    /**
     * Get DovizKodu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDovizKodu()
    {
        return isset($this->DovizKodu) ? $this->DovizKodu : null;
    }
    /**
     * Set DovizKodu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dovizKodu
     * @return \StructType\GetTaksitSecenekleri
     */
    public function setDovizKodu($dovizKodu = null)
    {
        // validation for constraint: string
        if (!is_null($dovizKodu) && !is_string($dovizKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dovizKodu, true), gettype($dovizKodu)), __LINE__);
        }
        if (is_null($dovizKodu) || (is_array($dovizKodu) && empty($dovizKodu))) {
            unset($this->DovizKodu);
        } else {
            $this->DovizKodu = $dovizKodu;
        }
        return $this;
    }
}
