<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StandardFaultMessage StructType
 * @subpackage Structs
 */
class StandardFaultMessage extends AbstractStructBase
{
    /**
     * The standard
     * @var \StructType\ExchangeFaultData
     */
    public $standard;
    /**
     * The addition
     * @var \StructType\StandardFaultMessageExtension
     */
    public $addition;
    /**
     * Constructor method for StandardFaultMessage
     * @uses StandardFaultMessage::setStandard()
     * @uses StandardFaultMessage::setAddition()
     * @param \StructType\ExchangeFaultData $standard
     * @param \StructType\StandardFaultMessageExtension $addition
     */
    public function __construct(\StructType\ExchangeFaultData $standard = null, \StructType\StandardFaultMessageExtension $addition = null)
    {
        $this
            ->setStandard($standard)
            ->setAddition($addition);
    }
    /**
     * Get standard value
     * @return \StructType\ExchangeFaultData|null
     */
    public function getStandard()
    {
        return $this->standard;
    }
    /**
     * Set standard value
     * @param \StructType\ExchangeFaultData $standard
     * @return \StructType\StandardFaultMessage
     */
    public function setStandard(\StructType\ExchangeFaultData $standard = null)
    {
        $this->standard = $standard;
        return $this;
    }
    /**
     * Get addition value
     * @return \StructType\StandardFaultMessageExtension|null
     */
    public function getAddition()
    {
        return $this->addition;
    }
    /**
     * Set addition value
     * @param \StructType\StandardFaultMessageExtension $addition
     * @return \StructType\StandardFaultMessage
     */
    public function setAddition(\StructType\StandardFaultMessageExtension $addition = null)
    {
        $this->addition = $addition;
        return $this;
    }
}
