<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SelectionByName StructType
 * @subpackage Structs
 */
class SelectionByName extends AbstractStructBase
{
    /**
     * The InclusionExclusionCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $InclusionExclusionCode;
    /**
     * The IntervalBoundaryTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * @var string
     */
    public $IntervalBoundaryTypeCode;
    /**
     * The LowerBoundaryName
     * Meta information extracted from the WSDL
     * - documentation: Text
     * - base: xsd:string
     * - minOccurs: 0
     * @var string
     */
    public $LowerBoundaryName;
    /**
     * The UpperBoundaryName
     * Meta information extracted from the WSDL
     * - documentation: Text
     * - base: xsd:string
     * - minOccurs: 0
     * @var string
     */
    public $UpperBoundaryName;
    /**
     * Constructor method for SelectionByName
     * @uses SelectionByName::setInclusionExclusionCode()
     * @uses SelectionByName::setIntervalBoundaryTypeCode()
     * @uses SelectionByName::setLowerBoundaryName()
     * @uses SelectionByName::setUpperBoundaryName()
     * @param string $inclusionExclusionCode
     * @param string $intervalBoundaryTypeCode
     * @param string $lowerBoundaryName
     * @param string $upperBoundaryName
     */
    public function __construct($inclusionExclusionCode = null, $intervalBoundaryTypeCode = null, $lowerBoundaryName = null, $upperBoundaryName = null)
    {
        $this
            ->setInclusionExclusionCode($inclusionExclusionCode)
            ->setIntervalBoundaryTypeCode($intervalBoundaryTypeCode)
            ->setLowerBoundaryName($lowerBoundaryName)
            ->setUpperBoundaryName($upperBoundaryName);
    }
    /**
     * Get InclusionExclusionCode value
     * @return string|null
     */
    public function getInclusionExclusionCode()
    {
        return $this->InclusionExclusionCode;
    }
    /**
     * Set InclusionExclusionCode value
     * @param string $inclusionExclusionCode
     * @return \StructType\SelectionByName
     */
    public function setInclusionExclusionCode($inclusionExclusionCode = null)
    {
        // validation for constraint: string
        if (!is_null($inclusionExclusionCode) && !is_string($inclusionExclusionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inclusionExclusionCode, true), gettype($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        $this->InclusionExclusionCode = $inclusionExclusionCode;
        return $this;
    }
    /**
     * Get IntervalBoundaryTypeCode value
     * @return string|null
     */
    public function getIntervalBoundaryTypeCode()
    {
        return $this->IntervalBoundaryTypeCode;
    }
    /**
     * Set IntervalBoundaryTypeCode value
     * @param string $intervalBoundaryTypeCode
     * @return \StructType\SelectionByName
     */
    public function setIntervalBoundaryTypeCode($intervalBoundaryTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($intervalBoundaryTypeCode) && !is_string($intervalBoundaryTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intervalBoundaryTypeCode, true), gettype($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        $this->IntervalBoundaryTypeCode = $intervalBoundaryTypeCode;
        return $this;
    }
    /**
     * Get LowerBoundaryName value
     * @return string|null
     */
    public function getLowerBoundaryName()
    {
        return $this->LowerBoundaryName;
    }
    /**
     * Set LowerBoundaryName value
     * @param string $lowerBoundaryName
     * @return \StructType\SelectionByName
     */
    public function setLowerBoundaryName($lowerBoundaryName = null)
    {
        // validation for constraint: string
        if (!is_null($lowerBoundaryName) && !is_string($lowerBoundaryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lowerBoundaryName, true), gettype($lowerBoundaryName)), __LINE__);
        }
        $this->LowerBoundaryName = $lowerBoundaryName;
        return $this;
    }
    /**
     * Get UpperBoundaryName value
     * @return string|null
     */
    public function getUpperBoundaryName()
    {
        return $this->UpperBoundaryName;
    }
    /**
     * Set UpperBoundaryName value
     * @param string $upperBoundaryName
     * @return \StructType\SelectionByName
     */
    public function setUpperBoundaryName($upperBoundaryName = null)
    {
        // validation for constraint: string
        if (!is_null($upperBoundaryName) && !is_string($upperBoundaryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upperBoundaryName, true), gettype($upperBoundaryName)), __LINE__);
        }
        $this->UpperBoundaryName = $upperBoundaryName;
        return $this;
    }
}
