<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryProcessingConditions StructType
 * @subpackage Structs
 */
class QueryProcessingConditions extends AbstractStructBase
{
    /**
     * The QueryHitsMaximumNumberValue
     * Meta information extracted from the WSDL
     * - documentation: Value
     * - base: xsd:int
     * - maxInclusive: 999999999
     * - minInclusive: 0
     * - minOccurs: 0
     * @var int
     */
    public $QueryHitsMaximumNumberValue;
    /**
     * The QueryHitsUnlimitedIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator
     * - base: xsd:boolean
     * @var bool
     */
    public $QueryHitsUnlimitedIndicator;
    /**
     * The LastReturnedObjectID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ObjectID
     */
    public $LastReturnedObjectID;
    /**
     * Constructor method for QueryProcessingConditions
     * @uses QueryProcessingConditions::setQueryHitsMaximumNumberValue()
     * @uses QueryProcessingConditions::setQueryHitsUnlimitedIndicator()
     * @uses QueryProcessingConditions::setLastReturnedObjectID()
     * @param int $queryHitsMaximumNumberValue
     * @param bool $queryHitsUnlimitedIndicator
     * @param \StructType\ObjectID $lastReturnedObjectID
     */
    public function __construct($queryHitsMaximumNumberValue = null, $queryHitsUnlimitedIndicator = null, \StructType\ObjectID $lastReturnedObjectID = null)
    {
        $this
            ->setQueryHitsMaximumNumberValue($queryHitsMaximumNumberValue)
            ->setQueryHitsUnlimitedIndicator($queryHitsUnlimitedIndicator)
            ->setLastReturnedObjectID($lastReturnedObjectID);
    }
    /**
     * Get QueryHitsMaximumNumberValue value
     * @return int|null
     */
    public function getQueryHitsMaximumNumberValue()
    {
        return $this->QueryHitsMaximumNumberValue;
    }
    /**
     * Set QueryHitsMaximumNumberValue value
     * @param int $queryHitsMaximumNumberValue
     * @return \StructType\QueryProcessingConditions
     */
    public function setQueryHitsMaximumNumberValue($queryHitsMaximumNumberValue = null)
    {
        // validation for constraint: int
        if (!is_null($queryHitsMaximumNumberValue) && !(is_int($queryHitsMaximumNumberValue) || ctype_digit($queryHitsMaximumNumberValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($queryHitsMaximumNumberValue, true), gettype($queryHitsMaximumNumberValue)), __LINE__);
        }
        // validation for constraint: maxInclusive(999999999)
        if (!is_null($queryHitsMaximumNumberValue) && $queryHitsMaximumNumberValue > 999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999999999', var_export($queryHitsMaximumNumberValue, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($queryHitsMaximumNumberValue) && $queryHitsMaximumNumberValue < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($queryHitsMaximumNumberValue, true)), __LINE__);
        }
        $this->QueryHitsMaximumNumberValue = $queryHitsMaximumNumberValue;
        return $this;
    }
    /**
     * Get QueryHitsUnlimitedIndicator value
     * @return bool|null
     */
    public function getQueryHitsUnlimitedIndicator()
    {
        return $this->QueryHitsUnlimitedIndicator;
    }
    /**
     * Set QueryHitsUnlimitedIndicator value
     * @param bool $queryHitsUnlimitedIndicator
     * @return \StructType\QueryProcessingConditions
     */
    public function setQueryHitsUnlimitedIndicator($queryHitsUnlimitedIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($queryHitsUnlimitedIndicator) && !is_bool($queryHitsUnlimitedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($queryHitsUnlimitedIndicator, true), gettype($queryHitsUnlimitedIndicator)), __LINE__);
        }
        $this->QueryHitsUnlimitedIndicator = $queryHitsUnlimitedIndicator;
        return $this;
    }
    /**
     * Get LastReturnedObjectID value
     * @return \StructType\ObjectID|null
     */
    public function getLastReturnedObjectID()
    {
        return $this->LastReturnedObjectID;
    }
    /**
     * Set LastReturnedObjectID value
     * @param \StructType\ObjectID $lastReturnedObjectID
     * @return \StructType\QueryProcessingConditions
     */
    public function setLastReturnedObjectID(\StructType\ObjectID $lastReturnedObjectID = null)
    {
        $this->LastReturnedObjectID = $lastReturnedObjectID;
        return $this;
    }
}
