<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LogItem StructType
 * @subpackage Structs
 */
class LogItem extends AbstractStructBase
{
    /**
     * The TypeID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 40
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeID;
    /**
     * The CategoryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LogItemCategoryCode
     */
    public $CategoryCode;
    /**
     * The SeverityCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $SeverityCode;
    /**
     * The ReferenceObjectNodeSenderTechnicalID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 70
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReferenceObjectNodeSenderTechnicalID;
    /**
     * The ReferenceMessageElementName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - minOccurs: 0
     * @var string
     */
    public $ReferenceMessageElementName;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - documentation: Note
     * - base: xsd:string
     * - maxLength: 200
     * @var string
     */
    public $Note;
    /**
     * The NoteTemplateText
     * Meta information extracted from the WSDL
     * - documentation: Text
     * - base: xsd:string
     * - maxLength: 73
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $NoteTemplateText;
    /**
     * The LogItemNotePlaceholderSubstitutionList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LogItemNotePlaceholderSubstitutionList
     */
    public $LogItemNotePlaceholderSubstitutionList;
    /**
     * The WebURI
     * Meta information extracted from the WSDL
     * - documentation: URI
     * - base: xsd:anyURI
     * - minOccurs: 0
     * @var string
     */
    public $WebURI;
    /**
     * Constructor method for LogItem
     * @uses LogItem::setTypeID()
     * @uses LogItem::setCategoryCode()
     * @uses LogItem::setSeverityCode()
     * @uses LogItem::setReferenceObjectNodeSenderTechnicalID()
     * @uses LogItem::setReferenceMessageElementName()
     * @uses LogItem::setNote()
     * @uses LogItem::setNoteTemplateText()
     * @uses LogItem::setLogItemNotePlaceholderSubstitutionList()
     * @uses LogItem::setWebURI()
     * @param string $typeID
     * @param \StructType\LogItemCategoryCode $categoryCode
     * @param string $severityCode
     * @param string $referenceObjectNodeSenderTechnicalID
     * @param string $referenceMessageElementName
     * @param string $note
     * @param string $noteTemplateText
     * @param \StructType\LogItemNotePlaceholderSubstitutionList $logItemNotePlaceholderSubstitutionList
     * @param string $webURI
     */
    public function __construct($typeID = null, \StructType\LogItemCategoryCode $categoryCode = null, $severityCode = null, $referenceObjectNodeSenderTechnicalID = null, $referenceMessageElementName = null, $note = null, $noteTemplateText = null, \StructType\LogItemNotePlaceholderSubstitutionList $logItemNotePlaceholderSubstitutionList = null, $webURI = null)
    {
        $this
            ->setTypeID($typeID)
            ->setCategoryCode($categoryCode)
            ->setSeverityCode($severityCode)
            ->setReferenceObjectNodeSenderTechnicalID($referenceObjectNodeSenderTechnicalID)
            ->setReferenceMessageElementName($referenceMessageElementName)
            ->setNote($note)
            ->setNoteTemplateText($noteTemplateText)
            ->setLogItemNotePlaceholderSubstitutionList($logItemNotePlaceholderSubstitutionList)
            ->setWebURI($webURI);
    }
    /**
     * Get TypeID value
     * @return string|null
     */
    public function getTypeID()
    {
        return $this->TypeID;
    }
    /**
     * Set TypeID value
     * @param string $typeID
     * @return \StructType\LogItem
     */
    public function setTypeID($typeID = null)
    {
        // validation for constraint: string
        if (!is_null($typeID) && !is_string($typeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeID, true), gettype($typeID)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($typeID) && mb_strlen($typeID) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($typeID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($typeID) && mb_strlen($typeID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($typeID)), __LINE__);
        }
        $this->TypeID = $typeID;
        return $this;
    }
    /**
     * Get CategoryCode value
     * @return \StructType\LogItemCategoryCode|null
     */
    public function getCategoryCode()
    {
        return $this->CategoryCode;
    }
    /**
     * Set CategoryCode value
     * @param \StructType\LogItemCategoryCode $categoryCode
     * @return \StructType\LogItem
     */
    public function setCategoryCode(\StructType\LogItemCategoryCode $categoryCode = null)
    {
        $this->CategoryCode = $categoryCode;
        return $this;
    }
    /**
     * Get SeverityCode value
     * @return string|null
     */
    public function getSeverityCode()
    {
        return $this->SeverityCode;
    }
    /**
     * Set SeverityCode value
     * @param string $severityCode
     * @return \StructType\LogItem
     */
    public function setSeverityCode($severityCode = null)
    {
        // validation for constraint: string
        if (!is_null($severityCode) && !is_string($severityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($severityCode, true), gettype($severityCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($severityCode) && mb_strlen($severityCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($severityCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($severityCode) && mb_strlen($severityCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($severityCode)), __LINE__);
        }
        $this->SeverityCode = $severityCode;
        return $this;
    }
    /**
     * Get ReferenceObjectNodeSenderTechnicalID value
     * @return string|null
     */
    public function getReferenceObjectNodeSenderTechnicalID()
    {
        return $this->ReferenceObjectNodeSenderTechnicalID;
    }
    /**
     * Set ReferenceObjectNodeSenderTechnicalID value
     * @param string $referenceObjectNodeSenderTechnicalID
     * @return \StructType\LogItem
     */
    public function setReferenceObjectNodeSenderTechnicalID($referenceObjectNodeSenderTechnicalID = null)
    {
        // validation for constraint: string
        if (!is_null($referenceObjectNodeSenderTechnicalID) && !is_string($referenceObjectNodeSenderTechnicalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceObjectNodeSenderTechnicalID, true), gettype($referenceObjectNodeSenderTechnicalID)), __LINE__);
        }
        // validation for constraint: maxLength(70)
        if (!is_null($referenceObjectNodeSenderTechnicalID) && mb_strlen($referenceObjectNodeSenderTechnicalID) > 70) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 70', mb_strlen($referenceObjectNodeSenderTechnicalID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($referenceObjectNodeSenderTechnicalID) && mb_strlen($referenceObjectNodeSenderTechnicalID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($referenceObjectNodeSenderTechnicalID)), __LINE__);
        }
        $this->ReferenceObjectNodeSenderTechnicalID = $referenceObjectNodeSenderTechnicalID;
        return $this;
    }
    /**
     * Get ReferenceMessageElementName value
     * @return string|null
     */
    public function getReferenceMessageElementName()
    {
        return $this->ReferenceMessageElementName;
    }
    /**
     * Set ReferenceMessageElementName value
     * @param string $referenceMessageElementName
     * @return \StructType\LogItem
     */
    public function setReferenceMessageElementName($referenceMessageElementName = null)
    {
        // validation for constraint: string
        if (!is_null($referenceMessageElementName) && !is_string($referenceMessageElementName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceMessageElementName, true), gettype($referenceMessageElementName)), __LINE__);
        }
        $this->ReferenceMessageElementName = $referenceMessageElementName;
        return $this;
    }
    /**
     * Get Note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param string $note
     * @return \StructType\LogItem
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($note) && mb_strlen($note) > 200) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen($note)), __LINE__);
        }
        $this->Note = $note;
        return $this;
    }
    /**
     * Get NoteTemplateText value
     * @return string|null
     */
    public function getNoteTemplateText()
    {
        return $this->NoteTemplateText;
    }
    /**
     * Set NoteTemplateText value
     * @param string $noteTemplateText
     * @return \StructType\LogItem
     */
    public function setNoteTemplateText($noteTemplateText = null)
    {
        // validation for constraint: string
        if (!is_null($noteTemplateText) && !is_string($noteTemplateText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noteTemplateText, true), gettype($noteTemplateText)), __LINE__);
        }
        // validation for constraint: maxLength(73)
        if (!is_null($noteTemplateText) && mb_strlen($noteTemplateText) > 73) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 73', mb_strlen($noteTemplateText)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($noteTemplateText) && mb_strlen($noteTemplateText) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($noteTemplateText)), __LINE__);
        }
        $this->NoteTemplateText = $noteTemplateText;
        return $this;
    }
    /**
     * Get LogItemNotePlaceholderSubstitutionList value
     * @return \StructType\LogItemNotePlaceholderSubstitutionList|null
     */
    public function getLogItemNotePlaceholderSubstitutionList()
    {
        return $this->LogItemNotePlaceholderSubstitutionList;
    }
    /**
     * Set LogItemNotePlaceholderSubstitutionList value
     * @param \StructType\LogItemNotePlaceholderSubstitutionList $logItemNotePlaceholderSubstitutionList
     * @return \StructType\LogItem
     */
    public function setLogItemNotePlaceholderSubstitutionList(\StructType\LogItemNotePlaceholderSubstitutionList $logItemNotePlaceholderSubstitutionList = null)
    {
        $this->LogItemNotePlaceholderSubstitutionList = $logItemNotePlaceholderSubstitutionList;
        return $this;
    }
    /**
     * Get WebURI value
     * @return string|null
     */
    public function getWebURI()
    {
        return $this->WebURI;
    }
    /**
     * Set WebURI value
     * @param string $webURI
     * @return \StructType\LogItem
     */
    public function setWebURI($webURI = null)
    {
        // validation for constraint: string
        if (!is_null($webURI) && !is_string($webURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webURI, true), gettype($webURI)), __LINE__);
        }
        $this->WebURI = $webURI;
        return $this;
    }
}
