<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerSelectionByRegionCode StructType
 * @subpackage Structs
 */
class CustomerSelectionByRegionCode extends AbstractStructBase
{
    /**
     * The InclusionExclusionCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $InclusionExclusionCode;
    /**
     * The IntervalBoundaryTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntervalBoundaryTypeCode;
    /**
     * The LowerBoundaryRegionCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RegionCode
     */
    public $LowerBoundaryRegionCode;
    /**
     * The UpperBoundaryRegionCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RegionCode
     */
    public $UpperBoundaryRegionCode;
    /**
     * Constructor method for CustomerSelectionByRegionCode
     * @uses CustomerSelectionByRegionCode::setInclusionExclusionCode()
     * @uses CustomerSelectionByRegionCode::setIntervalBoundaryTypeCode()
     * @uses CustomerSelectionByRegionCode::setLowerBoundaryRegionCode()
     * @uses CustomerSelectionByRegionCode::setUpperBoundaryRegionCode()
     * @param string $inclusionExclusionCode
     * @param string $intervalBoundaryTypeCode
     * @param \StructType\RegionCode $lowerBoundaryRegionCode
     * @param \StructType\RegionCode $upperBoundaryRegionCode
     */
    public function __construct($inclusionExclusionCode = null, $intervalBoundaryTypeCode = null, \StructType\RegionCode $lowerBoundaryRegionCode = null, \StructType\RegionCode $upperBoundaryRegionCode = null)
    {
        $this
            ->setInclusionExclusionCode($inclusionExclusionCode)
            ->setIntervalBoundaryTypeCode($intervalBoundaryTypeCode)
            ->setLowerBoundaryRegionCode($lowerBoundaryRegionCode)
            ->setUpperBoundaryRegionCode($upperBoundaryRegionCode);
    }
    /**
     * Get InclusionExclusionCode value
     * @return string|null
     */
    public function getInclusionExclusionCode()
    {
        return $this->InclusionExclusionCode;
    }
    /**
     * Set InclusionExclusionCode value
     * @param string $inclusionExclusionCode
     * @return \StructType\CustomerSelectionByRegionCode
     */
    public function setInclusionExclusionCode($inclusionExclusionCode = null)
    {
        // validation for constraint: string
        if (!is_null($inclusionExclusionCode) && !is_string($inclusionExclusionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inclusionExclusionCode, true), gettype($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        $this->InclusionExclusionCode = $inclusionExclusionCode;
        return $this;
    }
    /**
     * Get IntervalBoundaryTypeCode value
     * @return string|null
     */
    public function getIntervalBoundaryTypeCode()
    {
        return $this->IntervalBoundaryTypeCode;
    }
    /**
     * Set IntervalBoundaryTypeCode value
     * @param string $intervalBoundaryTypeCode
     * @return \StructType\CustomerSelectionByRegionCode
     */
    public function setIntervalBoundaryTypeCode($intervalBoundaryTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($intervalBoundaryTypeCode) && !is_string($intervalBoundaryTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intervalBoundaryTypeCode, true), gettype($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        $this->IntervalBoundaryTypeCode = $intervalBoundaryTypeCode;
        return $this;
    }
    /**
     * Get LowerBoundaryRegionCode value
     * @return \StructType\RegionCode|null
     */
    public function getLowerBoundaryRegionCode()
    {
        return $this->LowerBoundaryRegionCode;
    }
    /**
     * Set LowerBoundaryRegionCode value
     * @param \StructType\RegionCode $lowerBoundaryRegionCode
     * @return \StructType\CustomerSelectionByRegionCode
     */
    public function setLowerBoundaryRegionCode(\StructType\RegionCode $lowerBoundaryRegionCode = null)
    {
        $this->LowerBoundaryRegionCode = $lowerBoundaryRegionCode;
        return $this;
    }
    /**
     * Get UpperBoundaryRegionCode value
     * @return \StructType\RegionCode|null
     */
    public function getUpperBoundaryRegionCode()
    {
        return $this->UpperBoundaryRegionCode;
    }
    /**
     * Set UpperBoundaryRegionCode value
     * @param \StructType\RegionCode $upperBoundaryRegionCode
     * @return \StructType\CustomerSelectionByRegionCode
     */
    public function setUpperBoundaryRegionCode(\StructType\RegionCode $upperBoundaryRegionCode = null)
    {
        $this->UpperBoundaryRegionCode = $upperBoundaryRegionCode;
        return $this;
    }
}
