<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerSelectionByBusinessPartnerName StructType
 * @subpackage Structs
 */
class CustomerSelectionByBusinessPartnerName extends AbstractStructBase
{
    /**
     * The InclusionExclusionCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $InclusionExclusionCode;
    /**
     * The IntervalBoundaryTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntervalBoundaryTypeCode;
    /**
     * The LowerBoundaryBusinessPartnerName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $LowerBoundaryBusinessPartnerName;
    /**
     * The UpperBoundaryBusinessPartnerName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $UpperBoundaryBusinessPartnerName;
    /**
     * Constructor method for CustomerSelectionByBusinessPartnerName
     * @uses CustomerSelectionByBusinessPartnerName::setInclusionExclusionCode()
     * @uses CustomerSelectionByBusinessPartnerName::setIntervalBoundaryTypeCode()
     * @uses CustomerSelectionByBusinessPartnerName::setLowerBoundaryBusinessPartnerName()
     * @uses CustomerSelectionByBusinessPartnerName::setUpperBoundaryBusinessPartnerName()
     * @param string $inclusionExclusionCode
     * @param string $intervalBoundaryTypeCode
     * @param string $lowerBoundaryBusinessPartnerName
     * @param string $upperBoundaryBusinessPartnerName
     */
    public function __construct($inclusionExclusionCode = null, $intervalBoundaryTypeCode = null, $lowerBoundaryBusinessPartnerName = null, $upperBoundaryBusinessPartnerName = null)
    {
        $this
            ->setInclusionExclusionCode($inclusionExclusionCode)
            ->setIntervalBoundaryTypeCode($intervalBoundaryTypeCode)
            ->setLowerBoundaryBusinessPartnerName($lowerBoundaryBusinessPartnerName)
            ->setUpperBoundaryBusinessPartnerName($upperBoundaryBusinessPartnerName);
    }
    /**
     * Get InclusionExclusionCode value
     * @return string|null
     */
    public function getInclusionExclusionCode()
    {
        return $this->InclusionExclusionCode;
    }
    /**
     * Set InclusionExclusionCode value
     * @param string $inclusionExclusionCode
     * @return \StructType\CustomerSelectionByBusinessPartnerName
     */
    public function setInclusionExclusionCode($inclusionExclusionCode = null)
    {
        // validation for constraint: string
        if (!is_null($inclusionExclusionCode) && !is_string($inclusionExclusionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inclusionExclusionCode, true), gettype($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        $this->InclusionExclusionCode = $inclusionExclusionCode;
        return $this;
    }
    /**
     * Get IntervalBoundaryTypeCode value
     * @return string|null
     */
    public function getIntervalBoundaryTypeCode()
    {
        return $this->IntervalBoundaryTypeCode;
    }
    /**
     * Set IntervalBoundaryTypeCode value
     * @param string $intervalBoundaryTypeCode
     * @return \StructType\CustomerSelectionByBusinessPartnerName
     */
    public function setIntervalBoundaryTypeCode($intervalBoundaryTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($intervalBoundaryTypeCode) && !is_string($intervalBoundaryTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intervalBoundaryTypeCode, true), gettype($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        $this->IntervalBoundaryTypeCode = $intervalBoundaryTypeCode;
        return $this;
    }
    /**
     * Get LowerBoundaryBusinessPartnerName value
     * @return string|null
     */
    public function getLowerBoundaryBusinessPartnerName()
    {
        return $this->LowerBoundaryBusinessPartnerName;
    }
    /**
     * Set LowerBoundaryBusinessPartnerName value
     * @param string $lowerBoundaryBusinessPartnerName
     * @return \StructType\CustomerSelectionByBusinessPartnerName
     */
    public function setLowerBoundaryBusinessPartnerName($lowerBoundaryBusinessPartnerName = null)
    {
        // validation for constraint: string
        if (!is_null($lowerBoundaryBusinessPartnerName) && !is_string($lowerBoundaryBusinessPartnerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lowerBoundaryBusinessPartnerName, true), gettype($lowerBoundaryBusinessPartnerName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($lowerBoundaryBusinessPartnerName) && mb_strlen($lowerBoundaryBusinessPartnerName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($lowerBoundaryBusinessPartnerName)), __LINE__);
        }
        $this->LowerBoundaryBusinessPartnerName = $lowerBoundaryBusinessPartnerName;
        return $this;
    }
    /**
     * Get UpperBoundaryBusinessPartnerName value
     * @return string|null
     */
    public function getUpperBoundaryBusinessPartnerName()
    {
        return $this->UpperBoundaryBusinessPartnerName;
    }
    /**
     * Set UpperBoundaryBusinessPartnerName value
     * @param string $upperBoundaryBusinessPartnerName
     * @return \StructType\CustomerSelectionByBusinessPartnerName
     */
    public function setUpperBoundaryBusinessPartnerName($upperBoundaryBusinessPartnerName = null)
    {
        // validation for constraint: string
        if (!is_null($upperBoundaryBusinessPartnerName) && !is_string($upperBoundaryBusinessPartnerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upperBoundaryBusinessPartnerName, true), gettype($upperBoundaryBusinessPartnerName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($upperBoundaryBusinessPartnerName) && mb_strlen($upperBoundaryBusinessPartnerName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($upperBoundaryBusinessPartnerName)), __LINE__);
        }
        $this->UpperBoundaryBusinessPartnerName = $upperBoundaryBusinessPartnerName;
        return $this;
    }
}
