<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerReponseCustomerPaymentDataPaymentForm StructType
 * @subpackage Structs
 */
class CustomerReponseCustomerPaymentDataPaymentForm extends AbstractStructBase
{
    /**
     * The PaymentFormCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 2
     * - minLength: 2
     * @var string
     */
    public $PaymentFormCode;
    /**
     * Constructor method for CustomerReponseCustomerPaymentDataPaymentForm
     * @uses CustomerReponseCustomerPaymentDataPaymentForm::setPaymentFormCode()
     * @param string $paymentFormCode
     */
    public function __construct($paymentFormCode = null)
    {
        $this
            ->setPaymentFormCode($paymentFormCode);
    }
    /**
     * Get PaymentFormCode value
     * @return string|null
     */
    public function getPaymentFormCode()
    {
        return $this->PaymentFormCode;
    }
    /**
     * Set PaymentFormCode value
     * @param string $paymentFormCode
     * @return \StructType\CustomerReponseCustomerPaymentDataPaymentForm
     */
    public function setPaymentFormCode($paymentFormCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentFormCode) && !is_string($paymentFormCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentFormCode, true), gettype($paymentFormCode)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($paymentFormCode) && mb_strlen($paymentFormCode) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($paymentFormCode)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($paymentFormCode) && mb_strlen($paymentFormCode) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($paymentFormCode)), __LINE__);
        }
        $this->PaymentFormCode = $paymentFormCode;
        return $this;
    }
}
