<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerReponseCustomerPaymentData StructType
 * @subpackage Structs
 */
class CustomerReponseCustomerPaymentData extends AbstractStructBase
{
    /**
     * The CompanyID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $CompanyID;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UUID
     */
    public $UUID;
    /**
     * The AccountDeterminationDebtorGroupCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountDeterminationDebtorGroupCode
     */
    public $AccountDeterminationDebtorGroupCode;
    /**
     * The AccountDebtorExternalID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 60
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountDebtorExternalID;
    /**
     * The PaymentBlockingReasonCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaymentBlockingReasonCode
     */
    public $PaymentBlockingReasonCode;
    /**
     * The PaymentBlockExpirationDateTime
     * Meta information extracted from the WSDL
     * - documentation: DateTime
     * - base: xsd:dateTime
     * - minOccurs: 0
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z
     * @var string
     */
    public $PaymentBlockExpirationDateTime;
    /**
     * The PaymentForm
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerReponseCustomerPaymentDataPaymentForm[]
     */
    public $PaymentForm;
    /**
     * The CreditLimitAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Amount
     */
    public $CreditLimitAmount;
    /**
     * The DirectDebitBankDetailsID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 4
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $DirectDebitBankDetailsID;
    /**
     * The DirectDebitValidityPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CLOSED_DatePeriod
     */
    public $DirectDebitValidityPeriod;
    /**
     * The PaymentCardDetailsID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 6
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentCardDetailsID;
    /**
     * The PaymentCardValidityPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CLOSED_DatePeriod
     */
    public $PaymentCardValidityPeriod;
    /**
     * The BillOfExchangeBankDetailsID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 4
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillOfExchangeBankDetailsID;
    /**
     * The PaymentAdviceRequiredIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator
     * - base: xsd:boolean
     * - minOccurs: 0
     * @var bool
     */
    public $PaymentAdviceRequiredIndicator;
    /**
     * The FirstPaymentInstructionCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstPaymentInstructionCode;
    /**
     * The SecondPaymentInstructionCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $SecondPaymentInstructionCode;
    /**
     * The ThirdPaymentInstructionCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ThirdPaymentInstructionCode;
    /**
     * The FourthPaymentInstructionCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $FourthPaymentInstructionCode;
    /**
     * The BankChargeBearerCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 4
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankChargeBearerCode;
    /**
     * The SinglePaymentIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator
     * - base: xsd:boolean
     * - minOccurs: 0
     * @var bool
     */
    public $SinglePaymentIndicator;
    /**
     * The VirtualAccountID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $VirtualAccountID;
    /**
     * Constructor method for CustomerReponseCustomerPaymentData
     * @uses CustomerReponseCustomerPaymentData::setCompanyID()
     * @uses CustomerReponseCustomerPaymentData::setUUID()
     * @uses CustomerReponseCustomerPaymentData::setAccountDeterminationDebtorGroupCode()
     * @uses CustomerReponseCustomerPaymentData::setAccountDebtorExternalID()
     * @uses CustomerReponseCustomerPaymentData::setPaymentBlockingReasonCode()
     * @uses CustomerReponseCustomerPaymentData::setPaymentBlockExpirationDateTime()
     * @uses CustomerReponseCustomerPaymentData::setPaymentForm()
     * @uses CustomerReponseCustomerPaymentData::setCreditLimitAmount()
     * @uses CustomerReponseCustomerPaymentData::setDirectDebitBankDetailsID()
     * @uses CustomerReponseCustomerPaymentData::setDirectDebitValidityPeriod()
     * @uses CustomerReponseCustomerPaymentData::setPaymentCardDetailsID()
     * @uses CustomerReponseCustomerPaymentData::setPaymentCardValidityPeriod()
     * @uses CustomerReponseCustomerPaymentData::setBillOfExchangeBankDetailsID()
     * @uses CustomerReponseCustomerPaymentData::setPaymentAdviceRequiredIndicator()
     * @uses CustomerReponseCustomerPaymentData::setFirstPaymentInstructionCode()
     * @uses CustomerReponseCustomerPaymentData::setSecondPaymentInstructionCode()
     * @uses CustomerReponseCustomerPaymentData::setThirdPaymentInstructionCode()
     * @uses CustomerReponseCustomerPaymentData::setFourthPaymentInstructionCode()
     * @uses CustomerReponseCustomerPaymentData::setBankChargeBearerCode()
     * @uses CustomerReponseCustomerPaymentData::setSinglePaymentIndicator()
     * @uses CustomerReponseCustomerPaymentData::setVirtualAccountID()
     * @param string $companyID
     * @param \StructType\UUID $uUID
     * @param \StructType\AccountDeterminationDebtorGroupCode $accountDeterminationDebtorGroupCode
     * @param string $accountDebtorExternalID
     * @param \StructType\PaymentBlockingReasonCode $paymentBlockingReasonCode
     * @param string $paymentBlockExpirationDateTime
     * @param \StructType\CustomerReponseCustomerPaymentDataPaymentForm[] $paymentForm
     * @param \StructType\Amount $creditLimitAmount
     * @param string $directDebitBankDetailsID
     * @param \StructType\CLOSED_DatePeriod $directDebitValidityPeriod
     * @param string $paymentCardDetailsID
     * @param \StructType\CLOSED_DatePeriod $paymentCardValidityPeriod
     * @param string $billOfExchangeBankDetailsID
     * @param bool $paymentAdviceRequiredIndicator
     * @param string $firstPaymentInstructionCode
     * @param string $secondPaymentInstructionCode
     * @param string $thirdPaymentInstructionCode
     * @param string $fourthPaymentInstructionCode
     * @param string $bankChargeBearerCode
     * @param bool $singlePaymentIndicator
     * @param string $virtualAccountID
     */
    public function __construct($companyID = null, \StructType\UUID $uUID = null, \StructType\AccountDeterminationDebtorGroupCode $accountDeterminationDebtorGroupCode = null, $accountDebtorExternalID = null, \StructType\PaymentBlockingReasonCode $paymentBlockingReasonCode = null, $paymentBlockExpirationDateTime = null, array $paymentForm = array(), \StructType\Amount $creditLimitAmount = null, $directDebitBankDetailsID = null, \StructType\CLOSED_DatePeriod $directDebitValidityPeriod = null, $paymentCardDetailsID = null, \StructType\CLOSED_DatePeriod $paymentCardValidityPeriod = null, $billOfExchangeBankDetailsID = null, $paymentAdviceRequiredIndicator = null, $firstPaymentInstructionCode = null, $secondPaymentInstructionCode = null, $thirdPaymentInstructionCode = null, $fourthPaymentInstructionCode = null, $bankChargeBearerCode = null, $singlePaymentIndicator = null, $virtualAccountID = null)
    {
        $this
            ->setCompanyID($companyID)
            ->setUUID($uUID)
            ->setAccountDeterminationDebtorGroupCode($accountDeterminationDebtorGroupCode)
            ->setAccountDebtorExternalID($accountDebtorExternalID)
            ->setPaymentBlockingReasonCode($paymentBlockingReasonCode)
            ->setPaymentBlockExpirationDateTime($paymentBlockExpirationDateTime)
            ->setPaymentForm($paymentForm)
            ->setCreditLimitAmount($creditLimitAmount)
            ->setDirectDebitBankDetailsID($directDebitBankDetailsID)
            ->setDirectDebitValidityPeriod($directDebitValidityPeriod)
            ->setPaymentCardDetailsID($paymentCardDetailsID)
            ->setPaymentCardValidityPeriod($paymentCardValidityPeriod)
            ->setBillOfExchangeBankDetailsID($billOfExchangeBankDetailsID)
            ->setPaymentAdviceRequiredIndicator($paymentAdviceRequiredIndicator)
            ->setFirstPaymentInstructionCode($firstPaymentInstructionCode)
            ->setSecondPaymentInstructionCode($secondPaymentInstructionCode)
            ->setThirdPaymentInstructionCode($thirdPaymentInstructionCode)
            ->setFourthPaymentInstructionCode($fourthPaymentInstructionCode)
            ->setBankChargeBearerCode($bankChargeBearerCode)
            ->setSinglePaymentIndicator($singlePaymentIndicator)
            ->setVirtualAccountID($virtualAccountID);
    }
    /**
     * Get CompanyID value
     * @return string|null
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }
    /**
     * Set CompanyID value
     * @param string $companyID
     * @return \StructType\CustomerReponseCustomerPaymentData
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: string
        if (!is_null($companyID) && !is_string($companyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyID, true), gettype($companyID)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($companyID) && mb_strlen($companyID) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($companyID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($companyID) && mb_strlen($companyID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($companyID)), __LINE__);
        }
        $this->CompanyID = $companyID;
        return $this;
    }
    /**
     * Get UUID value
     * @return \StructType\UUID|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param \StructType\UUID $uUID
     * @return \StructType\CustomerReponseCustomerPaymentData
     */
    public function setUUID(\StructType\UUID $uUID = null)
    {
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get AccountDeterminationDebtorGroupCode value
     * @return \StructType\AccountDeterminationDebtorGroupCode|null
     */
    public function getAccountDeterminationDebtorGroupCode()
    {
        return $this->AccountDeterminationDebtorGroupCode;
    }
    /**
     * Set AccountDeterminationDebtorGroupCode value
     * @param \StructType\AccountDeterminationDebtorGroupCode $accountDeterminationDebtorGroupCode
     * @return \StructType\CustomerReponseCustomerPaymentData
     */
    public function setAccountDeterminationDebtorGroupCode(\StructType\AccountDeterminationDebtorGroupCode $accountDeterminationDebtorGroupCode = null)
    {
        $this->AccountDeterminationDebtorGroupCode = $accountDeterminationDebtorGroupCode;
        return $this;
    }
    /**
     * Get AccountDebtorExternalID value
     * @return string|null
     */
    public function getAccountDebtorExternalID()
    {
        return $this->AccountDebtorExternalID;
    }
    /**
     * Set AccountDebtorExternalID value
     * @param string $accountDebtorExternalID
     * @return \StructType\CustomerReponseCustomerPaymentData
     */
    public function setAccountDebtorExternalID($accountDebtorExternalID = null)
    {
        // validation for constraint: string
        if (!is_null($accountDebtorExternalID) && !is_string($accountDebtorExternalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountDebtorExternalID, true), gettype($accountDebtorExternalID)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($accountDebtorExternalID) && mb_strlen($accountDebtorExternalID) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($accountDebtorExternalID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($accountDebtorExternalID) && mb_strlen($accountDebtorExternalID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($accountDebtorExternalID)), __LINE__);
        }
        $this->AccountDebtorExternalID = $accountDebtorExternalID;
        return $this;
    }
    /**
     * Get PaymentBlockingReasonCode value
     * @return \StructType\PaymentBlockingReasonCode|null
     */
    public function getPaymentBlockingReasonCode()
    {
        return $this->PaymentBlockingReasonCode;
    }
    /**
     * Set PaymentBlockingReasonCode value
     * @param \StructType\PaymentBlockingReasonCode $paymentBlockingReasonCode
     * @return \StructType\CustomerReponseCustomerPaymentData
     */
    public function setPaymentBlockingReasonCode(\StructType\PaymentBlockingReasonCode $paymentBlockingReasonCode = null)
    {
        $this->PaymentBlockingReasonCode = $paymentBlockingReasonCode;
        return $this;
    }
    /**
     * Get PaymentBlockExpirationDateTime value
     * @return string|null
     */
    public function getPaymentBlockExpirationDateTime()
    {
        return $this->PaymentBlockExpirationDateTime;
    }
    /**
     * Set PaymentBlockExpirationDateTime value
     * @param string $paymentBlockExpirationDateTime
     * @return \StructType\CustomerReponseCustomerPaymentData
     */
    public function setPaymentBlockExpirationDateTime($paymentBlockExpirationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($paymentBlockExpirationDateTime) && !is_string($paymentBlockExpirationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentBlockExpirationDateTime, true), gettype($paymentBlockExpirationDateTime)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z)
        if (!is_null($paymentBlockExpirationDateTime) && !preg_match('/[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z/', $paymentBlockExpirationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z', var_export($paymentBlockExpirationDateTime, true)), __LINE__);
        }
        $this->PaymentBlockExpirationDateTime = $paymentBlockExpirationDateTime;
        return $this;
    }
    /**
     * Get PaymentForm value
     * @return \StructType\CustomerReponseCustomerPaymentDataPaymentForm[]|null
     */
    public function getPaymentForm()
    {
        return $this->PaymentForm;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentForm method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentForm method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentFormForArrayConstraintsFromSetPaymentForm(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerReponseCustomerPaymentDataPaymentFormItem) {
            // validation for constraint: itemType
            if (!$customerReponseCustomerPaymentDataPaymentFormItem instanceof \StructType\CustomerReponseCustomerPaymentDataPaymentForm) {
                $invalidValues[] = is_object($customerReponseCustomerPaymentDataPaymentFormItem) ? get_class($customerReponseCustomerPaymentDataPaymentFormItem) : sprintf('%s(%s)', gettype($customerReponseCustomerPaymentDataPaymentFormItem), var_export($customerReponseCustomerPaymentDataPaymentFormItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentForm property can only contain items of type \StructType\CustomerReponseCustomerPaymentDataPaymentForm, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentForm value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerPaymentDataPaymentForm[] $paymentForm
     * @return \StructType\CustomerReponseCustomerPaymentData
     */
    public function setPaymentForm(array $paymentForm = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentFormArrayErrorMessage = self::validatePaymentFormForArrayConstraintsFromSetPaymentForm($paymentForm))) {
            throw new \InvalidArgumentException($paymentFormArrayErrorMessage, __LINE__);
        }
        $this->PaymentForm = $paymentForm;
        return $this;
    }
    /**
     * Add item to PaymentForm value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerPaymentDataPaymentForm $item
     * @return \StructType\CustomerReponseCustomerPaymentData
     */
    public function addToPaymentForm(\StructType\CustomerReponseCustomerPaymentDataPaymentForm $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerReponseCustomerPaymentDataPaymentForm) {
            throw new \InvalidArgumentException(sprintf('The PaymentForm property can only contain items of type \StructType\CustomerReponseCustomerPaymentDataPaymentForm, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentForm[] = $item;
        return $this;
    }
    /**
     * Get CreditLimitAmount value
     * @return \StructType\Amount|null
     */
    public function getCreditLimitAmount()
    {
        return $this->CreditLimitAmount;
    }
    /**
     * Set CreditLimitAmount value
     * @param \StructType\Amount $creditLimitAmount
     * @return \StructType\CustomerReponseCustomerPaymentData
     */
    public function setCreditLimitAmount(\StructType\Amount $creditLimitAmount = null)
    {
        $this->CreditLimitAmount = $creditLimitAmount;
        return $this;
    }
    /**
     * Get DirectDebitBankDetailsID value
     * @return string|null
     */
    public function getDirectDebitBankDetailsID()
    {
        return $this->DirectDebitBankDetailsID;
    }
    /**
     * Set DirectDebitBankDetailsID value
     * @param string $directDebitBankDetailsID
     * @return \StructType\CustomerReponseCustomerPaymentData
     */
    public function setDirectDebitBankDetailsID($directDebitBankDetailsID = null)
    {
        // validation for constraint: string
        if (!is_null($directDebitBankDetailsID) && !is_string($directDebitBankDetailsID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directDebitBankDetailsID, true), gettype($directDebitBankDetailsID)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($directDebitBankDetailsID) && mb_strlen($directDebitBankDetailsID) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($directDebitBankDetailsID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($directDebitBankDetailsID) && mb_strlen($directDebitBankDetailsID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($directDebitBankDetailsID)), __LINE__);
        }
        $this->DirectDebitBankDetailsID = $directDebitBankDetailsID;
        return $this;
    }
    /**
     * Get DirectDebitValidityPeriod value
     * @return \StructType\CLOSED_DatePeriod|null
     */
    public function getDirectDebitValidityPeriod()
    {
        return $this->DirectDebitValidityPeriod;
    }
    /**
     * Set DirectDebitValidityPeriod value
     * @param \StructType\CLOSED_DatePeriod $directDebitValidityPeriod
     * @return \StructType\CustomerReponseCustomerPaymentData
     */
    public function setDirectDebitValidityPeriod(\StructType\CLOSED_DatePeriod $directDebitValidityPeriod = null)
    {
        $this->DirectDebitValidityPeriod = $directDebitValidityPeriod;
        return $this;
    }
    /**
     * Get PaymentCardDetailsID value
     * @return string|null
     */
    public function getPaymentCardDetailsID()
    {
        return $this->PaymentCardDetailsID;
    }
    /**
     * Set PaymentCardDetailsID value
     * @param string $paymentCardDetailsID
     * @return \StructType\CustomerReponseCustomerPaymentData
     */
    public function setPaymentCardDetailsID($paymentCardDetailsID = null)
    {
        // validation for constraint: string
        if (!is_null($paymentCardDetailsID) && !is_string($paymentCardDetailsID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentCardDetailsID, true), gettype($paymentCardDetailsID)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($paymentCardDetailsID) && mb_strlen($paymentCardDetailsID) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($paymentCardDetailsID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($paymentCardDetailsID) && mb_strlen($paymentCardDetailsID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($paymentCardDetailsID)), __LINE__);
        }
        $this->PaymentCardDetailsID = $paymentCardDetailsID;
        return $this;
    }
    /**
     * Get PaymentCardValidityPeriod value
     * @return \StructType\CLOSED_DatePeriod|null
     */
    public function getPaymentCardValidityPeriod()
    {
        return $this->PaymentCardValidityPeriod;
    }
    /**
     * Set PaymentCardValidityPeriod value
     * @param \StructType\CLOSED_DatePeriod $paymentCardValidityPeriod
     * @return \StructType\CustomerReponseCustomerPaymentData
     */
    public function setPaymentCardValidityPeriod(\StructType\CLOSED_DatePeriod $paymentCardValidityPeriod = null)
    {
        $this->PaymentCardValidityPeriod = $paymentCardValidityPeriod;
        return $this;
    }
    /**
     * Get BillOfExchangeBankDetailsID value
     * @return string|null
     */
    public function getBillOfExchangeBankDetailsID()
    {
        return $this->BillOfExchangeBankDetailsID;
    }
    /**
     * Set BillOfExchangeBankDetailsID value
     * @param string $billOfExchangeBankDetailsID
     * @return \StructType\CustomerReponseCustomerPaymentData
     */
    public function setBillOfExchangeBankDetailsID($billOfExchangeBankDetailsID = null)
    {
        // validation for constraint: string
        if (!is_null($billOfExchangeBankDetailsID) && !is_string($billOfExchangeBankDetailsID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billOfExchangeBankDetailsID, true), gettype($billOfExchangeBankDetailsID)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($billOfExchangeBankDetailsID) && mb_strlen($billOfExchangeBankDetailsID) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($billOfExchangeBankDetailsID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($billOfExchangeBankDetailsID) && mb_strlen($billOfExchangeBankDetailsID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($billOfExchangeBankDetailsID)), __LINE__);
        }
        $this->BillOfExchangeBankDetailsID = $billOfExchangeBankDetailsID;
        return $this;
    }
    /**
     * Get PaymentAdviceRequiredIndicator value
     * @return bool|null
     */
    public function getPaymentAdviceRequiredIndicator()
    {
        return $this->PaymentAdviceRequiredIndicator;
    }
    /**
     * Set PaymentAdviceRequiredIndicator value
     * @param bool $paymentAdviceRequiredIndicator
     * @return \StructType\CustomerReponseCustomerPaymentData
     */
    public function setPaymentAdviceRequiredIndicator($paymentAdviceRequiredIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($paymentAdviceRequiredIndicator) && !is_bool($paymentAdviceRequiredIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($paymentAdviceRequiredIndicator, true), gettype($paymentAdviceRequiredIndicator)), __LINE__);
        }
        $this->PaymentAdviceRequiredIndicator = $paymentAdviceRequiredIndicator;
        return $this;
    }
    /**
     * Get FirstPaymentInstructionCode value
     * @return string|null
     */
    public function getFirstPaymentInstructionCode()
    {
        return $this->FirstPaymentInstructionCode;
    }
    /**
     * Set FirstPaymentInstructionCode value
     * @param string $firstPaymentInstructionCode
     * @return \StructType\CustomerReponseCustomerPaymentData
     */
    public function setFirstPaymentInstructionCode($firstPaymentInstructionCode = null)
    {
        // validation for constraint: string
        if (!is_null($firstPaymentInstructionCode) && !is_string($firstPaymentInstructionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstPaymentInstructionCode, true), gettype($firstPaymentInstructionCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($firstPaymentInstructionCode) && mb_strlen($firstPaymentInstructionCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($firstPaymentInstructionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($firstPaymentInstructionCode) && mb_strlen($firstPaymentInstructionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($firstPaymentInstructionCode)), __LINE__);
        }
        $this->FirstPaymentInstructionCode = $firstPaymentInstructionCode;
        return $this;
    }
    /**
     * Get SecondPaymentInstructionCode value
     * @return string|null
     */
    public function getSecondPaymentInstructionCode()
    {
        return $this->SecondPaymentInstructionCode;
    }
    /**
     * Set SecondPaymentInstructionCode value
     * @param string $secondPaymentInstructionCode
     * @return \StructType\CustomerReponseCustomerPaymentData
     */
    public function setSecondPaymentInstructionCode($secondPaymentInstructionCode = null)
    {
        // validation for constraint: string
        if (!is_null($secondPaymentInstructionCode) && !is_string($secondPaymentInstructionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondPaymentInstructionCode, true), gettype($secondPaymentInstructionCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($secondPaymentInstructionCode) && mb_strlen($secondPaymentInstructionCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($secondPaymentInstructionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($secondPaymentInstructionCode) && mb_strlen($secondPaymentInstructionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($secondPaymentInstructionCode)), __LINE__);
        }
        $this->SecondPaymentInstructionCode = $secondPaymentInstructionCode;
        return $this;
    }
    /**
     * Get ThirdPaymentInstructionCode value
     * @return string|null
     */
    public function getThirdPaymentInstructionCode()
    {
        return $this->ThirdPaymentInstructionCode;
    }
    /**
     * Set ThirdPaymentInstructionCode value
     * @param string $thirdPaymentInstructionCode
     * @return \StructType\CustomerReponseCustomerPaymentData
     */
    public function setThirdPaymentInstructionCode($thirdPaymentInstructionCode = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPaymentInstructionCode) && !is_string($thirdPaymentInstructionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdPaymentInstructionCode, true), gettype($thirdPaymentInstructionCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($thirdPaymentInstructionCode) && mb_strlen($thirdPaymentInstructionCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($thirdPaymentInstructionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($thirdPaymentInstructionCode) && mb_strlen($thirdPaymentInstructionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($thirdPaymentInstructionCode)), __LINE__);
        }
        $this->ThirdPaymentInstructionCode = $thirdPaymentInstructionCode;
        return $this;
    }
    /**
     * Get FourthPaymentInstructionCode value
     * @return string|null
     */
    public function getFourthPaymentInstructionCode()
    {
        return $this->FourthPaymentInstructionCode;
    }
    /**
     * Set FourthPaymentInstructionCode value
     * @param string $fourthPaymentInstructionCode
     * @return \StructType\CustomerReponseCustomerPaymentData
     */
    public function setFourthPaymentInstructionCode($fourthPaymentInstructionCode = null)
    {
        // validation for constraint: string
        if (!is_null($fourthPaymentInstructionCode) && !is_string($fourthPaymentInstructionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fourthPaymentInstructionCode, true), gettype($fourthPaymentInstructionCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($fourthPaymentInstructionCode) && mb_strlen($fourthPaymentInstructionCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($fourthPaymentInstructionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($fourthPaymentInstructionCode) && mb_strlen($fourthPaymentInstructionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($fourthPaymentInstructionCode)), __LINE__);
        }
        $this->FourthPaymentInstructionCode = $fourthPaymentInstructionCode;
        return $this;
    }
    /**
     * Get BankChargeBearerCode value
     * @return string|null
     */
    public function getBankChargeBearerCode()
    {
        return $this->BankChargeBearerCode;
    }
    /**
     * Set BankChargeBearerCode value
     * @param string $bankChargeBearerCode
     * @return \StructType\CustomerReponseCustomerPaymentData
     */
    public function setBankChargeBearerCode($bankChargeBearerCode = null)
    {
        // validation for constraint: string
        if (!is_null($bankChargeBearerCode) && !is_string($bankChargeBearerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankChargeBearerCode, true), gettype($bankChargeBearerCode)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($bankChargeBearerCode) && mb_strlen($bankChargeBearerCode) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($bankChargeBearerCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($bankChargeBearerCode) && mb_strlen($bankChargeBearerCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($bankChargeBearerCode)), __LINE__);
        }
        $this->BankChargeBearerCode = $bankChargeBearerCode;
        return $this;
    }
    /**
     * Get SinglePaymentIndicator value
     * @return bool|null
     */
    public function getSinglePaymentIndicator()
    {
        return $this->SinglePaymentIndicator;
    }
    /**
     * Set SinglePaymentIndicator value
     * @param bool $singlePaymentIndicator
     * @return \StructType\CustomerReponseCustomerPaymentData
     */
    public function setSinglePaymentIndicator($singlePaymentIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($singlePaymentIndicator) && !is_bool($singlePaymentIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($singlePaymentIndicator, true), gettype($singlePaymentIndicator)), __LINE__);
        }
        $this->SinglePaymentIndicator = $singlePaymentIndicator;
        return $this;
    }
    /**
     * Get VirtualAccountID value
     * @return string|null
     */
    public function getVirtualAccountID()
    {
        return $this->VirtualAccountID;
    }
    /**
     * Set VirtualAccountID value
     * @param string $virtualAccountID
     * @return \StructType\CustomerReponseCustomerPaymentData
     */
    public function setVirtualAccountID($virtualAccountID = null)
    {
        // validation for constraint: string
        if (!is_null($virtualAccountID) && !is_string($virtualAccountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($virtualAccountID, true), gettype($virtualAccountID)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($virtualAccountID) && mb_strlen($virtualAccountID) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($virtualAccountID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($virtualAccountID) && mb_strlen($virtualAccountID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($virtualAccountID)), __LINE__);
        }
        $this->VirtualAccountID = $virtualAccountID;
        return $this;
    }
}
