<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerReponseCustomerOrganisation StructType
 * @subpackage Structs
 */
class CustomerReponseCustomerOrganisation extends AbstractStructBase
{
    /**
     * The CompanyLegalFormCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CompanyLegalFormCode
     */
    public $CompanyLegalFormCode;
    /**
     * The FirstLineName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $FirstLineName;
    /**
     * The SecondLineName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $SecondLineName;
    /**
     * Constructor method for CustomerReponseCustomerOrganisation
     * @uses CustomerReponseCustomerOrganisation::setCompanyLegalFormCode()
     * @uses CustomerReponseCustomerOrganisation::setFirstLineName()
     * @uses CustomerReponseCustomerOrganisation::setSecondLineName()
     * @param \StructType\CompanyLegalFormCode $companyLegalFormCode
     * @param string $firstLineName
     * @param string $secondLineName
     */
    public function __construct(\StructType\CompanyLegalFormCode $companyLegalFormCode = null, $firstLineName = null, $secondLineName = null)
    {
        $this
            ->setCompanyLegalFormCode($companyLegalFormCode)
            ->setFirstLineName($firstLineName)
            ->setSecondLineName($secondLineName);
    }
    /**
     * Get CompanyLegalFormCode value
     * @return \StructType\CompanyLegalFormCode|null
     */
    public function getCompanyLegalFormCode()
    {
        return $this->CompanyLegalFormCode;
    }
    /**
     * Set CompanyLegalFormCode value
     * @param \StructType\CompanyLegalFormCode $companyLegalFormCode
     * @return \StructType\CustomerReponseCustomerOrganisation
     */
    public function setCompanyLegalFormCode(\StructType\CompanyLegalFormCode $companyLegalFormCode = null)
    {
        $this->CompanyLegalFormCode = $companyLegalFormCode;
        return $this;
    }
    /**
     * Get FirstLineName value
     * @return string|null
     */
    public function getFirstLineName()
    {
        return $this->FirstLineName;
    }
    /**
     * Set FirstLineName value
     * @param string $firstLineName
     * @return \StructType\CustomerReponseCustomerOrganisation
     */
    public function setFirstLineName($firstLineName = null)
    {
        // validation for constraint: string
        if (!is_null($firstLineName) && !is_string($firstLineName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstLineName, true), gettype($firstLineName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($firstLineName) && mb_strlen($firstLineName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($firstLineName)), __LINE__);
        }
        $this->FirstLineName = $firstLineName;
        return $this;
    }
    /**
     * Get SecondLineName value
     * @return string|null
     */
    public function getSecondLineName()
    {
        return $this->SecondLineName;
    }
    /**
     * Set SecondLineName value
     * @param string $secondLineName
     * @return \StructType\CustomerReponseCustomerOrganisation
     */
    public function setSecondLineName($secondLineName = null)
    {
        // validation for constraint: string
        if (!is_null($secondLineName) && !is_string($secondLineName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondLineName, true), gettype($secondLineName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($secondLineName) && mb_strlen($secondLineName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($secondLineName)), __LINE__);
        }
        $this->SecondLineName = $secondLineName;
        return $this;
    }
}
