<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerReponseCustomerOperatingHoursInformation
 * StructType
 * @subpackage Structs
 */
class CustomerReponseCustomerOperatingHoursInformation extends AbstractStructBase
{
    /**
     * The RoleCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - length: 1
     * @var string
     */
    public $RoleCode;
    /**
     * The RecurringDayProgramme
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerReponseCustomerOperatingHoursInformationRecurringDayProgramme[]
     */
    public $RecurringDayProgramme;
    /**
     * Constructor method for CustomerReponseCustomerOperatingHoursInformation
     * @uses CustomerReponseCustomerOperatingHoursInformation::setRoleCode()
     * @uses CustomerReponseCustomerOperatingHoursInformation::setRecurringDayProgramme()
     * @param string $roleCode
     * @param \StructType\CustomerReponseCustomerOperatingHoursInformationRecurringDayProgramme[] $recurringDayProgramme
     */
    public function __construct($roleCode = null, array $recurringDayProgramme = array())
    {
        $this
            ->setRoleCode($roleCode)
            ->setRecurringDayProgramme($recurringDayProgramme);
    }
    /**
     * Get RoleCode value
     * @return string|null
     */
    public function getRoleCode()
    {
        return $this->RoleCode;
    }
    /**
     * Set RoleCode value
     * @param string $roleCode
     * @return \StructType\CustomerReponseCustomerOperatingHoursInformation
     */
    public function setRoleCode($roleCode = null)
    {
        // validation for constraint: string
        if (!is_null($roleCode) && !is_string($roleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roleCode, true), gettype($roleCode)), __LINE__);
        }
        // validation for constraint: length(1)
        if (!is_null($roleCode) && mb_strlen($roleCode) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 1', mb_strlen($roleCode)), __LINE__);
        }
        $this->RoleCode = $roleCode;
        return $this;
    }
    /**
     * Get RecurringDayProgramme value
     * @return \StructType\CustomerReponseCustomerOperatingHoursInformationRecurringDayProgramme[]|null
     */
    public function getRecurringDayProgramme()
    {
        return $this->RecurringDayProgramme;
    }
    /**
     * This method is responsible for validating the values passed to the setRecurringDayProgramme method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecurringDayProgramme method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecurringDayProgrammeForArrayConstraintsFromSetRecurringDayProgramme(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerReponseCustomerOperatingHoursInformationRecurringDayProgrammeItem) {
            // validation for constraint: itemType
            if (!$customerReponseCustomerOperatingHoursInformationRecurringDayProgrammeItem instanceof \StructType\CustomerReponseCustomerOperatingHoursInformationRecurringDayProgramme) {
                $invalidValues[] = is_object($customerReponseCustomerOperatingHoursInformationRecurringDayProgrammeItem) ? get_class($customerReponseCustomerOperatingHoursInformationRecurringDayProgrammeItem) : sprintf('%s(%s)', gettype($customerReponseCustomerOperatingHoursInformationRecurringDayProgrammeItem), var_export($customerReponseCustomerOperatingHoursInformationRecurringDayProgrammeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RecurringDayProgramme property can only contain items of type \StructType\CustomerReponseCustomerOperatingHoursInformationRecurringDayProgramme, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RecurringDayProgramme value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerOperatingHoursInformationRecurringDayProgramme[] $recurringDayProgramme
     * @return \StructType\CustomerReponseCustomerOperatingHoursInformation
     */
    public function setRecurringDayProgramme(array $recurringDayProgramme = array())
    {
        // validation for constraint: array
        if ('' !== ($recurringDayProgrammeArrayErrorMessage = self::validateRecurringDayProgrammeForArrayConstraintsFromSetRecurringDayProgramme($recurringDayProgramme))) {
            throw new \InvalidArgumentException($recurringDayProgrammeArrayErrorMessage, __LINE__);
        }
        $this->RecurringDayProgramme = $recurringDayProgramme;
        return $this;
    }
    /**
     * Add item to RecurringDayProgramme value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerOperatingHoursInformationRecurringDayProgramme $item
     * @return \StructType\CustomerReponseCustomerOperatingHoursInformation
     */
    public function addToRecurringDayProgramme(\StructType\CustomerReponseCustomerOperatingHoursInformationRecurringDayProgramme $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerReponseCustomerOperatingHoursInformationRecurringDayProgramme) {
            throw new \InvalidArgumentException(sprintf('The RecurringDayProgramme property can only contain items of type \StructType\CustomerReponseCustomerOperatingHoursInformationRecurringDayProgramme, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RecurringDayProgramme[] = $item;
        return $this;
    }
}
