<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerReponseCustomerCommunicationEmail StructType
 * @subpackage Structs
 */
class CustomerReponseCustomerCommunicationEmail extends AbstractStructBase
{
    /**
     * The EmailURI
     * @var \StructType\EmailURI
     */
    public $EmailURI;
    /**
     * The RecipientFieldTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $RecipientFieldTypeCode;
    /**
     * Constructor method for CustomerReponseCustomerCommunicationEmail
     * @uses CustomerReponseCustomerCommunicationEmail::setEmailURI()
     * @uses CustomerReponseCustomerCommunicationEmail::setRecipientFieldTypeCode()
     * @param \StructType\EmailURI $emailURI
     * @param string $recipientFieldTypeCode
     */
    public function __construct(\StructType\EmailURI $emailURI = null, $recipientFieldTypeCode = null)
    {
        $this
            ->setEmailURI($emailURI)
            ->setRecipientFieldTypeCode($recipientFieldTypeCode);
    }
    /**
     * Get EmailURI value
     * @return \StructType\EmailURI|null
     */
    public function getEmailURI()
    {
        return $this->EmailURI;
    }
    /**
     * Set EmailURI value
     * @param \StructType\EmailURI $emailURI
     * @return \StructType\CustomerReponseCustomerCommunicationEmail
     */
    public function setEmailURI(\StructType\EmailURI $emailURI = null)
    {
        $this->EmailURI = $emailURI;
        return $this;
    }
    /**
     * Get RecipientFieldTypeCode value
     * @return string|null
     */
    public function getRecipientFieldTypeCode()
    {
        return $this->RecipientFieldTypeCode;
    }
    /**
     * Set RecipientFieldTypeCode value
     * @param string $recipientFieldTypeCode
     * @return \StructType\CustomerReponseCustomerCommunicationEmail
     */
    public function setRecipientFieldTypeCode($recipientFieldTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($recipientFieldTypeCode) && !is_string($recipientFieldTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipientFieldTypeCode, true), gettype($recipientFieldTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($recipientFieldTypeCode) && mb_strlen($recipientFieldTypeCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($recipientFieldTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($recipientFieldTypeCode) && mb_strlen($recipientFieldTypeCode) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($recipientFieldTypeCode)), __LINE__);
        }
        $this->RecipientFieldTypeCode = $recipientFieldTypeCode;
        return $this;
    }
}
