<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerReponseCustomerCommunicationChannel StructType
 * @subpackage Structs
 */
class CustomerReponseCustomerCommunicationChannel extends AbstractStructBase
{
    /**
     * The CommunicationMediumTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CommunicationMediumTypeCode
     */
    public $CommunicationMediumTypeCode;
    /**
     * The OutputRequestFormTemplateCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OutputRequestFormTemplateCode
     */
    public $OutputRequestFormTemplateCode;
    /**
     * The EmailURI
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerReponseCustomerCommunicationEmail[]
     */
    public $EmailURI;
    /**
     * The FacsimileFormattedNumberDescription
     * Meta information extracted from the WSDL
     * - documentation: Description
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $FacsimileFormattedNumberDescription;
    /**
     * The OutputCopyNumberValue
     * Meta information extracted from the WSDL
     * - documentation: Value
     * - base: xsd:int
     * - maxInclusive: 999999999
     * - minInclusive: 0
     * - minOccurs: 0
     * @var int
     */
    public $OutputCopyNumberValue;
    /**
     * The PrintQueueIdentifier
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 30
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrintQueueIdentifier;
    /**
     * The DuplicateIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator
     * - base: xsd:boolean
     * - minOccurs: 0
     * @var bool
     */
    public $DuplicateIndicator;
    /**
     * The TransformationID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\XSLTStorageXSLTID
     */
    public $TransformationID;
    /**
     * Constructor method for CustomerReponseCustomerCommunicationChannel
     * @uses CustomerReponseCustomerCommunicationChannel::setCommunicationMediumTypeCode()
     * @uses CustomerReponseCustomerCommunicationChannel::setOutputRequestFormTemplateCode()
     * @uses CustomerReponseCustomerCommunicationChannel::setEmailURI()
     * @uses CustomerReponseCustomerCommunicationChannel::setFacsimileFormattedNumberDescription()
     * @uses CustomerReponseCustomerCommunicationChannel::setOutputCopyNumberValue()
     * @uses CustomerReponseCustomerCommunicationChannel::setPrintQueueIdentifier()
     * @uses CustomerReponseCustomerCommunicationChannel::setDuplicateIndicator()
     * @uses CustomerReponseCustomerCommunicationChannel::setTransformationID()
     * @param \StructType\CommunicationMediumTypeCode $communicationMediumTypeCode
     * @param \StructType\OutputRequestFormTemplateCode $outputRequestFormTemplateCode
     * @param \StructType\CustomerReponseCustomerCommunicationEmail[] $emailURI
     * @param string $facsimileFormattedNumberDescription
     * @param int $outputCopyNumberValue
     * @param string $printQueueIdentifier
     * @param bool $duplicateIndicator
     * @param \StructType\XSLTStorageXSLTID $transformationID
     */
    public function __construct(\StructType\CommunicationMediumTypeCode $communicationMediumTypeCode = null, \StructType\OutputRequestFormTemplateCode $outputRequestFormTemplateCode = null, array $emailURI = array(), $facsimileFormattedNumberDescription = null, $outputCopyNumberValue = null, $printQueueIdentifier = null, $duplicateIndicator = null, \StructType\XSLTStorageXSLTID $transformationID = null)
    {
        $this
            ->setCommunicationMediumTypeCode($communicationMediumTypeCode)
            ->setOutputRequestFormTemplateCode($outputRequestFormTemplateCode)
            ->setEmailURI($emailURI)
            ->setFacsimileFormattedNumberDescription($facsimileFormattedNumberDescription)
            ->setOutputCopyNumberValue($outputCopyNumberValue)
            ->setPrintQueueIdentifier($printQueueIdentifier)
            ->setDuplicateIndicator($duplicateIndicator)
            ->setTransformationID($transformationID);
    }
    /**
     * Get CommunicationMediumTypeCode value
     * @return \StructType\CommunicationMediumTypeCode|null
     */
    public function getCommunicationMediumTypeCode()
    {
        return $this->CommunicationMediumTypeCode;
    }
    /**
     * Set CommunicationMediumTypeCode value
     * @param \StructType\CommunicationMediumTypeCode $communicationMediumTypeCode
     * @return \StructType\CustomerReponseCustomerCommunicationChannel
     */
    public function setCommunicationMediumTypeCode(\StructType\CommunicationMediumTypeCode $communicationMediumTypeCode = null)
    {
        $this->CommunicationMediumTypeCode = $communicationMediumTypeCode;
        return $this;
    }
    /**
     * Get OutputRequestFormTemplateCode value
     * @return \StructType\OutputRequestFormTemplateCode|null
     */
    public function getOutputRequestFormTemplateCode()
    {
        return $this->OutputRequestFormTemplateCode;
    }
    /**
     * Set OutputRequestFormTemplateCode value
     * @param \StructType\OutputRequestFormTemplateCode $outputRequestFormTemplateCode
     * @return \StructType\CustomerReponseCustomerCommunicationChannel
     */
    public function setOutputRequestFormTemplateCode(\StructType\OutputRequestFormTemplateCode $outputRequestFormTemplateCode = null)
    {
        $this->OutputRequestFormTemplateCode = $outputRequestFormTemplateCode;
        return $this;
    }
    /**
     * Get EmailURI value
     * @return \StructType\CustomerReponseCustomerCommunicationEmail[]|null
     */
    public function getEmailURI()
    {
        return $this->EmailURI;
    }
    /**
     * This method is responsible for validating the values passed to the setEmailURI method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmailURI method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailURIForArrayConstraintsFromSetEmailURI(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerReponseCustomerCommunicationChannelEmailURIItem) {
            // validation for constraint: itemType
            if (!$customerReponseCustomerCommunicationChannelEmailURIItem instanceof \StructType\CustomerReponseCustomerCommunicationEmail) {
                $invalidValues[] = is_object($customerReponseCustomerCommunicationChannelEmailURIItem) ? get_class($customerReponseCustomerCommunicationChannelEmailURIItem) : sprintf('%s(%s)', gettype($customerReponseCustomerCommunicationChannelEmailURIItem), var_export($customerReponseCustomerCommunicationChannelEmailURIItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EmailURI property can only contain items of type \StructType\CustomerReponseCustomerCommunicationEmail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EmailURI value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerCommunicationEmail[] $emailURI
     * @return \StructType\CustomerReponseCustomerCommunicationChannel
     */
    public function setEmailURI(array $emailURI = array())
    {
        // validation for constraint: array
        if ('' !== ($emailURIArrayErrorMessage = self::validateEmailURIForArrayConstraintsFromSetEmailURI($emailURI))) {
            throw new \InvalidArgumentException($emailURIArrayErrorMessage, __LINE__);
        }
        $this->EmailURI = $emailURI;
        return $this;
    }
    /**
     * Add item to EmailURI value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerCommunicationEmail $item
     * @return \StructType\CustomerReponseCustomerCommunicationChannel
     */
    public function addToEmailURI(\StructType\CustomerReponseCustomerCommunicationEmail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerReponseCustomerCommunicationEmail) {
            throw new \InvalidArgumentException(sprintf('The EmailURI property can only contain items of type \StructType\CustomerReponseCustomerCommunicationEmail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EmailURI[] = $item;
        return $this;
    }
    /**
     * Get FacsimileFormattedNumberDescription value
     * @return string|null
     */
    public function getFacsimileFormattedNumberDescription()
    {
        return $this->FacsimileFormattedNumberDescription;
    }
    /**
     * Set FacsimileFormattedNumberDescription value
     * @param string $facsimileFormattedNumberDescription
     * @return \StructType\CustomerReponseCustomerCommunicationChannel
     */
    public function setFacsimileFormattedNumberDescription($facsimileFormattedNumberDescription = null)
    {
        // validation for constraint: string
        if (!is_null($facsimileFormattedNumberDescription) && !is_string($facsimileFormattedNumberDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($facsimileFormattedNumberDescription, true), gettype($facsimileFormattedNumberDescription)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($facsimileFormattedNumberDescription) && mb_strlen($facsimileFormattedNumberDescription) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($facsimileFormattedNumberDescription)), __LINE__);
        }
        $this->FacsimileFormattedNumberDescription = $facsimileFormattedNumberDescription;
        return $this;
    }
    /**
     * Get OutputCopyNumberValue value
     * @return int|null
     */
    public function getOutputCopyNumberValue()
    {
        return $this->OutputCopyNumberValue;
    }
    /**
     * Set OutputCopyNumberValue value
     * @param int $outputCopyNumberValue
     * @return \StructType\CustomerReponseCustomerCommunicationChannel
     */
    public function setOutputCopyNumberValue($outputCopyNumberValue = null)
    {
        // validation for constraint: int
        if (!is_null($outputCopyNumberValue) && !(is_int($outputCopyNumberValue) || ctype_digit($outputCopyNumberValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($outputCopyNumberValue, true), gettype($outputCopyNumberValue)), __LINE__);
        }
        // validation for constraint: maxInclusive(999999999)
        if (!is_null($outputCopyNumberValue) && $outputCopyNumberValue > 999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999999999', var_export($outputCopyNumberValue, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($outputCopyNumberValue) && $outputCopyNumberValue < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($outputCopyNumberValue, true)), __LINE__);
        }
        $this->OutputCopyNumberValue = $outputCopyNumberValue;
        return $this;
    }
    /**
     * Get PrintQueueIdentifier value
     * @return string|null
     */
    public function getPrintQueueIdentifier()
    {
        return $this->PrintQueueIdentifier;
    }
    /**
     * Set PrintQueueIdentifier value
     * @param string $printQueueIdentifier
     * @return \StructType\CustomerReponseCustomerCommunicationChannel
     */
    public function setPrintQueueIdentifier($printQueueIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($printQueueIdentifier) && !is_string($printQueueIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printQueueIdentifier, true), gettype($printQueueIdentifier)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($printQueueIdentifier) && mb_strlen($printQueueIdentifier) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($printQueueIdentifier)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($printQueueIdentifier) && mb_strlen($printQueueIdentifier) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($printQueueIdentifier)), __LINE__);
        }
        $this->PrintQueueIdentifier = $printQueueIdentifier;
        return $this;
    }
    /**
     * Get DuplicateIndicator value
     * @return bool|null
     */
    public function getDuplicateIndicator()
    {
        return $this->DuplicateIndicator;
    }
    /**
     * Set DuplicateIndicator value
     * @param bool $duplicateIndicator
     * @return \StructType\CustomerReponseCustomerCommunicationChannel
     */
    public function setDuplicateIndicator($duplicateIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($duplicateIndicator) && !is_bool($duplicateIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($duplicateIndicator, true), gettype($duplicateIndicator)), __LINE__);
        }
        $this->DuplicateIndicator = $duplicateIndicator;
        return $this;
    }
    /**
     * Get TransformationID value
     * @return \StructType\XSLTStorageXSLTID|null
     */
    public function getTransformationID()
    {
        return $this->TransformationID;
    }
    /**
     * Set TransformationID value
     * @param \StructType\XSLTStorageXSLTID $transformationID
     * @return \StructType\CustomerReponseCustomerCommunicationChannel
     */
    public function setTransformationID(\StructType\XSLTStorageXSLTID $transformationID = null)
    {
        $this->TransformationID = $transformationID;
        return $this;
    }
}
