<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerReponseCustomerCommunicationArrangement StructType
 * @subpackage Structs
 */
class CustomerReponseCustomerCommunicationArrangement extends AbstractStructBase
{
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UUID
     */
    public $UUID;
    /**
     * The CompoundServiceInterfaceCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CompoundServiceInterfaceCode
     */
    public $CompoundServiceInterfaceCode;
    /**
     * The EnabledIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator
     * - base: xsd:boolean
     * - minOccurs: 0
     * @var bool
     */
    public $EnabledIndicator;
    /**
     * The CommunicationMediumTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CommunicationMediumTypeCode
     */
    public $CommunicationMediumTypeCode;
    /**
     * The OutputRequestFormTemplateCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OutputRequestFormTemplateCode
     */
    public $OutputRequestFormTemplateCode;
    /**
     * The EMailURI
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmailURI
     */
    public $EMailURI;
    /**
     * The FacsimileFormattedNumberDescription
     * Meta information extracted from the WSDL
     * - documentation: Description
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $FacsimileFormattedNumberDescription;
    /**
     * The OutputCopyNumberValue
     * Meta information extracted from the WSDL
     * - documentation: Value
     * - base: xsd:int
     * - maxInclusive: 999999999
     * - minInclusive: 0
     * - minOccurs: 0
     * @var int
     */
    public $OutputCopyNumberValue;
    /**
     * The TransformationID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\XSLTStorageXSLTID
     */
    public $TransformationID;
    /**
     * Constructor method for CustomerReponseCustomerCommunicationArrangement
     * @uses CustomerReponseCustomerCommunicationArrangement::setUUID()
     * @uses CustomerReponseCustomerCommunicationArrangement::setCompoundServiceInterfaceCode()
     * @uses CustomerReponseCustomerCommunicationArrangement::setEnabledIndicator()
     * @uses CustomerReponseCustomerCommunicationArrangement::setCommunicationMediumTypeCode()
     * @uses CustomerReponseCustomerCommunicationArrangement::setOutputRequestFormTemplateCode()
     * @uses CustomerReponseCustomerCommunicationArrangement::setEMailURI()
     * @uses CustomerReponseCustomerCommunicationArrangement::setFacsimileFormattedNumberDescription()
     * @uses CustomerReponseCustomerCommunicationArrangement::setOutputCopyNumberValue()
     * @uses CustomerReponseCustomerCommunicationArrangement::setTransformationID()
     * @param \StructType\UUID $uUID
     * @param \StructType\CompoundServiceInterfaceCode $compoundServiceInterfaceCode
     * @param bool $enabledIndicator
     * @param \StructType\CommunicationMediumTypeCode $communicationMediumTypeCode
     * @param \StructType\OutputRequestFormTemplateCode $outputRequestFormTemplateCode
     * @param \StructType\EmailURI $eMailURI
     * @param string $facsimileFormattedNumberDescription
     * @param int $outputCopyNumberValue
     * @param \StructType\XSLTStorageXSLTID $transformationID
     */
    public function __construct(\StructType\UUID $uUID = null, \StructType\CompoundServiceInterfaceCode $compoundServiceInterfaceCode = null, $enabledIndicator = null, \StructType\CommunicationMediumTypeCode $communicationMediumTypeCode = null, \StructType\OutputRequestFormTemplateCode $outputRequestFormTemplateCode = null, \StructType\EmailURI $eMailURI = null, $facsimileFormattedNumberDescription = null, $outputCopyNumberValue = null, \StructType\XSLTStorageXSLTID $transformationID = null)
    {
        $this
            ->setUUID($uUID)
            ->setCompoundServiceInterfaceCode($compoundServiceInterfaceCode)
            ->setEnabledIndicator($enabledIndicator)
            ->setCommunicationMediumTypeCode($communicationMediumTypeCode)
            ->setOutputRequestFormTemplateCode($outputRequestFormTemplateCode)
            ->setEMailURI($eMailURI)
            ->setFacsimileFormattedNumberDescription($facsimileFormattedNumberDescription)
            ->setOutputCopyNumberValue($outputCopyNumberValue)
            ->setTransformationID($transformationID);
    }
    /**
     * Get UUID value
     * @return \StructType\UUID|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param \StructType\UUID $uUID
     * @return \StructType\CustomerReponseCustomerCommunicationArrangement
     */
    public function setUUID(\StructType\UUID $uUID = null)
    {
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get CompoundServiceInterfaceCode value
     * @return \StructType\CompoundServiceInterfaceCode|null
     */
    public function getCompoundServiceInterfaceCode()
    {
        return $this->CompoundServiceInterfaceCode;
    }
    /**
     * Set CompoundServiceInterfaceCode value
     * @param \StructType\CompoundServiceInterfaceCode $compoundServiceInterfaceCode
     * @return \StructType\CustomerReponseCustomerCommunicationArrangement
     */
    public function setCompoundServiceInterfaceCode(\StructType\CompoundServiceInterfaceCode $compoundServiceInterfaceCode = null)
    {
        $this->CompoundServiceInterfaceCode = $compoundServiceInterfaceCode;
        return $this;
    }
    /**
     * Get EnabledIndicator value
     * @return bool|null
     */
    public function getEnabledIndicator()
    {
        return $this->EnabledIndicator;
    }
    /**
     * Set EnabledIndicator value
     * @param bool $enabledIndicator
     * @return \StructType\CustomerReponseCustomerCommunicationArrangement
     */
    public function setEnabledIndicator($enabledIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($enabledIndicator) && !is_bool($enabledIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enabledIndicator, true), gettype($enabledIndicator)), __LINE__);
        }
        $this->EnabledIndicator = $enabledIndicator;
        return $this;
    }
    /**
     * Get CommunicationMediumTypeCode value
     * @return \StructType\CommunicationMediumTypeCode|null
     */
    public function getCommunicationMediumTypeCode()
    {
        return $this->CommunicationMediumTypeCode;
    }
    /**
     * Set CommunicationMediumTypeCode value
     * @param \StructType\CommunicationMediumTypeCode $communicationMediumTypeCode
     * @return \StructType\CustomerReponseCustomerCommunicationArrangement
     */
    public function setCommunicationMediumTypeCode(\StructType\CommunicationMediumTypeCode $communicationMediumTypeCode = null)
    {
        $this->CommunicationMediumTypeCode = $communicationMediumTypeCode;
        return $this;
    }
    /**
     * Get OutputRequestFormTemplateCode value
     * @return \StructType\OutputRequestFormTemplateCode|null
     */
    public function getOutputRequestFormTemplateCode()
    {
        return $this->OutputRequestFormTemplateCode;
    }
    /**
     * Set OutputRequestFormTemplateCode value
     * @param \StructType\OutputRequestFormTemplateCode $outputRequestFormTemplateCode
     * @return \StructType\CustomerReponseCustomerCommunicationArrangement
     */
    public function setOutputRequestFormTemplateCode(\StructType\OutputRequestFormTemplateCode $outputRequestFormTemplateCode = null)
    {
        $this->OutputRequestFormTemplateCode = $outputRequestFormTemplateCode;
        return $this;
    }
    /**
     * Get EMailURI value
     * @return \StructType\EmailURI|null
     */
    public function getEMailURI()
    {
        return $this->EMailURI;
    }
    /**
     * Set EMailURI value
     * @param \StructType\EmailURI $eMailURI
     * @return \StructType\CustomerReponseCustomerCommunicationArrangement
     */
    public function setEMailURI(\StructType\EmailURI $eMailURI = null)
    {
        $this->EMailURI = $eMailURI;
        return $this;
    }
    /**
     * Get FacsimileFormattedNumberDescription value
     * @return string|null
     */
    public function getFacsimileFormattedNumberDescription()
    {
        return $this->FacsimileFormattedNumberDescription;
    }
    /**
     * Set FacsimileFormattedNumberDescription value
     * @param string $facsimileFormattedNumberDescription
     * @return \StructType\CustomerReponseCustomerCommunicationArrangement
     */
    public function setFacsimileFormattedNumberDescription($facsimileFormattedNumberDescription = null)
    {
        // validation for constraint: string
        if (!is_null($facsimileFormattedNumberDescription) && !is_string($facsimileFormattedNumberDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($facsimileFormattedNumberDescription, true), gettype($facsimileFormattedNumberDescription)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($facsimileFormattedNumberDescription) && mb_strlen($facsimileFormattedNumberDescription) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($facsimileFormattedNumberDescription)), __LINE__);
        }
        $this->FacsimileFormattedNumberDescription = $facsimileFormattedNumberDescription;
        return $this;
    }
    /**
     * Get OutputCopyNumberValue value
     * @return int|null
     */
    public function getOutputCopyNumberValue()
    {
        return $this->OutputCopyNumberValue;
    }
    /**
     * Set OutputCopyNumberValue value
     * @param int $outputCopyNumberValue
     * @return \StructType\CustomerReponseCustomerCommunicationArrangement
     */
    public function setOutputCopyNumberValue($outputCopyNumberValue = null)
    {
        // validation for constraint: int
        if (!is_null($outputCopyNumberValue) && !(is_int($outputCopyNumberValue) || ctype_digit($outputCopyNumberValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($outputCopyNumberValue, true), gettype($outputCopyNumberValue)), __LINE__);
        }
        // validation for constraint: maxInclusive(999999999)
        if (!is_null($outputCopyNumberValue) && $outputCopyNumberValue > 999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999999999', var_export($outputCopyNumberValue, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($outputCopyNumberValue) && $outputCopyNumberValue < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($outputCopyNumberValue, true)), __LINE__);
        }
        $this->OutputCopyNumberValue = $outputCopyNumberValue;
        return $this;
    }
    /**
     * Get TransformationID value
     * @return \StructType\XSLTStorageXSLTID|null
     */
    public function getTransformationID()
    {
        return $this->TransformationID;
    }
    /**
     * Set TransformationID value
     * @param \StructType\XSLTStorageXSLTID $transformationID
     * @return \StructType\CustomerReponseCustomerCommunicationArrangement
     */
    public function setTransformationID(\StructType\XSLTStorageXSLTID $transformationID = null)
    {
        $this->TransformationID = $transformationID;
        return $this;
    }
}
