<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerReponseCustomerBankDetails StructType
 * @subpackage Structs
 */
class CustomerReponseCustomerBankDetails extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 4
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The BankUUID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UUID
     */
    public $BankUUID;
    /**
     * The BankInternalID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BankInternalID
     */
    public $BankInternalID;
    /**
     * The BankRoutingID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 35
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankRoutingID;
    /**
     * The BankRoutingIDTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankRoutingIDTypeCode;
    /**
     * The BankStandardID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 11
     * - minLength: 8
     * - minOccurs: 0
     * @var string
     */
    public $BankStandardID;
    /**
     * The BankAccountID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 35
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankAccountID;
    /**
     * The BankAccountIDCheckDigitValue
     * Meta information extracted from the WSDL
     * - documentation: Note
     * - base: xsd:string
     * - maxLength: 2
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankAccountIDCheckDigitValue;
    /**
     * The BankAccountTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankAccountTypeCode;
    /**
     * The BankAccountHolderName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 60
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankAccountHolderName;
    /**
     * The BankAccountStandardID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 34
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankAccountStandardID;
    /**
     * The ValidityPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CLOSED_DatePeriod
     */
    public $ValidityPeriod;
    /**
     * The BankDirectoryBranchID
     * @var \StructType\BankBranchID
     */
    public $BankDirectoryBranchID;
    /**
     * The GoldenTaxRelevanceIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator
     * - base: xsd:boolean
     * @var bool
     */
    public $GoldenTaxRelevanceIndicator;
    /**
     * Constructor method for CustomerReponseCustomerBankDetails
     * @uses CustomerReponseCustomerBankDetails::setID()
     * @uses CustomerReponseCustomerBankDetails::setBankUUID()
     * @uses CustomerReponseCustomerBankDetails::setBankInternalID()
     * @uses CustomerReponseCustomerBankDetails::setBankRoutingID()
     * @uses CustomerReponseCustomerBankDetails::setBankRoutingIDTypeCode()
     * @uses CustomerReponseCustomerBankDetails::setBankStandardID()
     * @uses CustomerReponseCustomerBankDetails::setBankAccountID()
     * @uses CustomerReponseCustomerBankDetails::setBankAccountIDCheckDigitValue()
     * @uses CustomerReponseCustomerBankDetails::setBankAccountTypeCode()
     * @uses CustomerReponseCustomerBankDetails::setBankAccountHolderName()
     * @uses CustomerReponseCustomerBankDetails::setBankAccountStandardID()
     * @uses CustomerReponseCustomerBankDetails::setValidityPeriod()
     * @uses CustomerReponseCustomerBankDetails::setBankDirectoryBranchID()
     * @uses CustomerReponseCustomerBankDetails::setGoldenTaxRelevanceIndicator()
     * @param string $iD
     * @param \StructType\UUID $bankUUID
     * @param \StructType\BankInternalID $bankInternalID
     * @param string $bankRoutingID
     * @param string $bankRoutingIDTypeCode
     * @param string $bankStandardID
     * @param string $bankAccountID
     * @param string $bankAccountIDCheckDigitValue
     * @param string $bankAccountTypeCode
     * @param string $bankAccountHolderName
     * @param string $bankAccountStandardID
     * @param \StructType\CLOSED_DatePeriod $validityPeriod
     * @param \StructType\BankBranchID $bankDirectoryBranchID
     * @param bool $goldenTaxRelevanceIndicator
     */
    public function __construct($iD = null, \StructType\UUID $bankUUID = null, \StructType\BankInternalID $bankInternalID = null, $bankRoutingID = null, $bankRoutingIDTypeCode = null, $bankStandardID = null, $bankAccountID = null, $bankAccountIDCheckDigitValue = null, $bankAccountTypeCode = null, $bankAccountHolderName = null, $bankAccountStandardID = null, \StructType\CLOSED_DatePeriod $validityPeriod = null, \StructType\BankBranchID $bankDirectoryBranchID = null, $goldenTaxRelevanceIndicator = null)
    {
        $this
            ->setID($iD)
            ->setBankUUID($bankUUID)
            ->setBankInternalID($bankInternalID)
            ->setBankRoutingID($bankRoutingID)
            ->setBankRoutingIDTypeCode($bankRoutingIDTypeCode)
            ->setBankStandardID($bankStandardID)
            ->setBankAccountID($bankAccountID)
            ->setBankAccountIDCheckDigitValue($bankAccountIDCheckDigitValue)
            ->setBankAccountTypeCode($bankAccountTypeCode)
            ->setBankAccountHolderName($bankAccountHolderName)
            ->setBankAccountStandardID($bankAccountStandardID)
            ->setValidityPeriod($validityPeriod)
            ->setBankDirectoryBranchID($bankDirectoryBranchID)
            ->setGoldenTaxRelevanceIndicator($goldenTaxRelevanceIndicator);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\CustomerReponseCustomerBankDetails
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($iD) && mb_strlen($iD) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($iD)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($iD) && mb_strlen($iD) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get BankUUID value
     * @return \StructType\UUID|null
     */
    public function getBankUUID()
    {
        return $this->BankUUID;
    }
    /**
     * Set BankUUID value
     * @param \StructType\UUID $bankUUID
     * @return \StructType\CustomerReponseCustomerBankDetails
     */
    public function setBankUUID(\StructType\UUID $bankUUID = null)
    {
        $this->BankUUID = $bankUUID;
        return $this;
    }
    /**
     * Get BankInternalID value
     * @return \StructType\BankInternalID|null
     */
    public function getBankInternalID()
    {
        return $this->BankInternalID;
    }
    /**
     * Set BankInternalID value
     * @param \StructType\BankInternalID $bankInternalID
     * @return \StructType\CustomerReponseCustomerBankDetails
     */
    public function setBankInternalID(\StructType\BankInternalID $bankInternalID = null)
    {
        $this->BankInternalID = $bankInternalID;
        return $this;
    }
    /**
     * Get BankRoutingID value
     * @return string|null
     */
    public function getBankRoutingID()
    {
        return $this->BankRoutingID;
    }
    /**
     * Set BankRoutingID value
     * @param string $bankRoutingID
     * @return \StructType\CustomerReponseCustomerBankDetails
     */
    public function setBankRoutingID($bankRoutingID = null)
    {
        // validation for constraint: string
        if (!is_null($bankRoutingID) && !is_string($bankRoutingID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankRoutingID, true), gettype($bankRoutingID)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($bankRoutingID) && mb_strlen($bankRoutingID) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($bankRoutingID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($bankRoutingID) && mb_strlen($bankRoutingID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($bankRoutingID)), __LINE__);
        }
        $this->BankRoutingID = $bankRoutingID;
        return $this;
    }
    /**
     * Get BankRoutingIDTypeCode value
     * @return string|null
     */
    public function getBankRoutingIDTypeCode()
    {
        return $this->BankRoutingIDTypeCode;
    }
    /**
     * Set BankRoutingIDTypeCode value
     * @param string $bankRoutingIDTypeCode
     * @return \StructType\CustomerReponseCustomerBankDetails
     */
    public function setBankRoutingIDTypeCode($bankRoutingIDTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($bankRoutingIDTypeCode) && !is_string($bankRoutingIDTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankRoutingIDTypeCode, true), gettype($bankRoutingIDTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($bankRoutingIDTypeCode) && mb_strlen($bankRoutingIDTypeCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($bankRoutingIDTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($bankRoutingIDTypeCode) && mb_strlen($bankRoutingIDTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($bankRoutingIDTypeCode)), __LINE__);
        }
        $this->BankRoutingIDTypeCode = $bankRoutingIDTypeCode;
        return $this;
    }
    /**
     * Get BankStandardID value
     * @return string|null
     */
    public function getBankStandardID()
    {
        return $this->BankStandardID;
    }
    /**
     * Set BankStandardID value
     * @param string $bankStandardID
     * @return \StructType\CustomerReponseCustomerBankDetails
     */
    public function setBankStandardID($bankStandardID = null)
    {
        // validation for constraint: string
        if (!is_null($bankStandardID) && !is_string($bankStandardID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankStandardID, true), gettype($bankStandardID)), __LINE__);
        }
        // validation for constraint: maxLength(11)
        if (!is_null($bankStandardID) && mb_strlen($bankStandardID) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 11', mb_strlen($bankStandardID)), __LINE__);
        }
        // validation for constraint: minLength(8)
        if (!is_null($bankStandardID) && mb_strlen($bankStandardID) < 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 8', mb_strlen($bankStandardID)), __LINE__);
        }
        $this->BankStandardID = $bankStandardID;
        return $this;
    }
    /**
     * Get BankAccountID value
     * @return string|null
     */
    public function getBankAccountID()
    {
        return $this->BankAccountID;
    }
    /**
     * Set BankAccountID value
     * @param string $bankAccountID
     * @return \StructType\CustomerReponseCustomerBankDetails
     */
    public function setBankAccountID($bankAccountID = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccountID) && !is_string($bankAccountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAccountID, true), gettype($bankAccountID)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($bankAccountID) && mb_strlen($bankAccountID) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($bankAccountID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($bankAccountID) && mb_strlen($bankAccountID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($bankAccountID)), __LINE__);
        }
        $this->BankAccountID = $bankAccountID;
        return $this;
    }
    /**
     * Get BankAccountIDCheckDigitValue value
     * @return string|null
     */
    public function getBankAccountIDCheckDigitValue()
    {
        return $this->BankAccountIDCheckDigitValue;
    }
    /**
     * Set BankAccountIDCheckDigitValue value
     * @param string $bankAccountIDCheckDigitValue
     * @return \StructType\CustomerReponseCustomerBankDetails
     */
    public function setBankAccountIDCheckDigitValue($bankAccountIDCheckDigitValue = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccountIDCheckDigitValue) && !is_string($bankAccountIDCheckDigitValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAccountIDCheckDigitValue, true), gettype($bankAccountIDCheckDigitValue)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($bankAccountIDCheckDigitValue) && mb_strlen($bankAccountIDCheckDigitValue) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($bankAccountIDCheckDigitValue)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($bankAccountIDCheckDigitValue) && mb_strlen($bankAccountIDCheckDigitValue) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($bankAccountIDCheckDigitValue)), __LINE__);
        }
        $this->BankAccountIDCheckDigitValue = $bankAccountIDCheckDigitValue;
        return $this;
    }
    /**
     * Get BankAccountTypeCode value
     * @return string|null
     */
    public function getBankAccountTypeCode()
    {
        return $this->BankAccountTypeCode;
    }
    /**
     * Set BankAccountTypeCode value
     * @param string $bankAccountTypeCode
     * @return \StructType\CustomerReponseCustomerBankDetails
     */
    public function setBankAccountTypeCode($bankAccountTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccountTypeCode) && !is_string($bankAccountTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAccountTypeCode, true), gettype($bankAccountTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($bankAccountTypeCode) && mb_strlen($bankAccountTypeCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($bankAccountTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($bankAccountTypeCode) && mb_strlen($bankAccountTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($bankAccountTypeCode)), __LINE__);
        }
        $this->BankAccountTypeCode = $bankAccountTypeCode;
        return $this;
    }
    /**
     * Get BankAccountHolderName value
     * @return string|null
     */
    public function getBankAccountHolderName()
    {
        return $this->BankAccountHolderName;
    }
    /**
     * Set BankAccountHolderName value
     * @param string $bankAccountHolderName
     * @return \StructType\CustomerReponseCustomerBankDetails
     */
    public function setBankAccountHolderName($bankAccountHolderName = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccountHolderName) && !is_string($bankAccountHolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAccountHolderName, true), gettype($bankAccountHolderName)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($bankAccountHolderName) && mb_strlen($bankAccountHolderName) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($bankAccountHolderName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($bankAccountHolderName) && mb_strlen($bankAccountHolderName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($bankAccountHolderName)), __LINE__);
        }
        $this->BankAccountHolderName = $bankAccountHolderName;
        return $this;
    }
    /**
     * Get BankAccountStandardID value
     * @return string|null
     */
    public function getBankAccountStandardID()
    {
        return $this->BankAccountStandardID;
    }
    /**
     * Set BankAccountStandardID value
     * @param string $bankAccountStandardID
     * @return \StructType\CustomerReponseCustomerBankDetails
     */
    public function setBankAccountStandardID($bankAccountStandardID = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccountStandardID) && !is_string($bankAccountStandardID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAccountStandardID, true), gettype($bankAccountStandardID)), __LINE__);
        }
        // validation for constraint: maxLength(34)
        if (!is_null($bankAccountStandardID) && mb_strlen($bankAccountStandardID) > 34) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 34', mb_strlen($bankAccountStandardID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($bankAccountStandardID) && mb_strlen($bankAccountStandardID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($bankAccountStandardID)), __LINE__);
        }
        $this->BankAccountStandardID = $bankAccountStandardID;
        return $this;
    }
    /**
     * Get ValidityPeriod value
     * @return \StructType\CLOSED_DatePeriod|null
     */
    public function getValidityPeriod()
    {
        return $this->ValidityPeriod;
    }
    /**
     * Set ValidityPeriod value
     * @param \StructType\CLOSED_DatePeriod $validityPeriod
     * @return \StructType\CustomerReponseCustomerBankDetails
     */
    public function setValidityPeriod(\StructType\CLOSED_DatePeriod $validityPeriod = null)
    {
        $this->ValidityPeriod = $validityPeriod;
        return $this;
    }
    /**
     * Get BankDirectoryBranchID value
     * @return \StructType\BankBranchID|null
     */
    public function getBankDirectoryBranchID()
    {
        return $this->BankDirectoryBranchID;
    }
    /**
     * Set BankDirectoryBranchID value
     * @param \StructType\BankBranchID $bankDirectoryBranchID
     * @return \StructType\CustomerReponseCustomerBankDetails
     */
    public function setBankDirectoryBranchID(\StructType\BankBranchID $bankDirectoryBranchID = null)
    {
        $this->BankDirectoryBranchID = $bankDirectoryBranchID;
        return $this;
    }
    /**
     * Get GoldenTaxRelevanceIndicator value
     * @return bool|null
     */
    public function getGoldenTaxRelevanceIndicator()
    {
        return $this->GoldenTaxRelevanceIndicator;
    }
    /**
     * Set GoldenTaxRelevanceIndicator value
     * @param bool $goldenTaxRelevanceIndicator
     * @return \StructType\CustomerReponseCustomerBankDetails
     */
    public function setGoldenTaxRelevanceIndicator($goldenTaxRelevanceIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($goldenTaxRelevanceIndicator) && !is_bool($goldenTaxRelevanceIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($goldenTaxRelevanceIndicator, true), gettype($goldenTaxRelevanceIndicator)), __LINE__);
        }
        $this->GoldenTaxRelevanceIndicator = $goldenTaxRelevanceIndicator;
        return $this;
    }
}
