<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerReponseCustomerAddressPostalAddress StructType
 * @subpackage Structs
 */
class CustomerReponseCustomerAddressPostalAddress extends AbstractStructBase
{
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 2
     * @var string
     */
    public $CountryCode;
    /**
     * The RegionCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RegionCode
     */
    public $RegionCode;
    /**
     * The CountyName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $CountyName;
    /**
     * The CityName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $CityName;
    /**
     * The AdditionalCityName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $AdditionalCityName;
    /**
     * The DistrictName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $DistrictName;
    /**
     * The StreetPostalCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 10
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $StreetPostalCode;
    /**
     * The POBoxPostalCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 10
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $POBoxPostalCode;
    /**
     * The CompanyPostalCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 10
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyPostalCode;
    /**
     * The StreetPrefixName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $StreetPrefixName;
    /**
     * The AdditionalStreetPrefixName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $AdditionalStreetPrefixName;
    /**
     * The StreetName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 60
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $StreetName;
    /**
     * The StreetSuffixName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $StreetSuffixName;
    /**
     * The AdditionalStreetSuffixName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $AdditionalStreetSuffixName;
    /**
     * The HouseID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 10
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $HouseID;
    /**
     * The CareOfName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $CareOfName;
    /**
     * The POBoxDeviatingCountryCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $POBoxDeviatingCountryCode;
    /**
     * The POBoxDeviatingRegionCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RegionCode
     */
    public $POBoxDeviatingRegionCode;
    /**
     * The POBoxDeviatingCityName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $POBoxDeviatingCityName;
    /**
     * The POBoxID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 10
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $POBoxID;
    /**
     * The POBoxIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator
     * - base: xsd:boolean
     * - minOccurs: 0
     * @var bool
     */
    public $POBoxIndicator;
    /**
     * The TaxJurisdictionCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxJurisdictionCode
     */
    public $TaxJurisdictionCode;
    /**
     * The TimeZoneCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 10
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $TimeZoneCode;
    /**
     * Constructor method for CustomerReponseCustomerAddressPostalAddress
     * @uses CustomerReponseCustomerAddressPostalAddress::setCountryCode()
     * @uses CustomerReponseCustomerAddressPostalAddress::setRegionCode()
     * @uses CustomerReponseCustomerAddressPostalAddress::setCountyName()
     * @uses CustomerReponseCustomerAddressPostalAddress::setCityName()
     * @uses CustomerReponseCustomerAddressPostalAddress::setAdditionalCityName()
     * @uses CustomerReponseCustomerAddressPostalAddress::setDistrictName()
     * @uses CustomerReponseCustomerAddressPostalAddress::setStreetPostalCode()
     * @uses CustomerReponseCustomerAddressPostalAddress::setPOBoxPostalCode()
     * @uses CustomerReponseCustomerAddressPostalAddress::setCompanyPostalCode()
     * @uses CustomerReponseCustomerAddressPostalAddress::setStreetPrefixName()
     * @uses CustomerReponseCustomerAddressPostalAddress::setAdditionalStreetPrefixName()
     * @uses CustomerReponseCustomerAddressPostalAddress::setStreetName()
     * @uses CustomerReponseCustomerAddressPostalAddress::setStreetSuffixName()
     * @uses CustomerReponseCustomerAddressPostalAddress::setAdditionalStreetSuffixName()
     * @uses CustomerReponseCustomerAddressPostalAddress::setHouseID()
     * @uses CustomerReponseCustomerAddressPostalAddress::setCareOfName()
     * @uses CustomerReponseCustomerAddressPostalAddress::setPOBoxDeviatingCountryCode()
     * @uses CustomerReponseCustomerAddressPostalAddress::setPOBoxDeviatingRegionCode()
     * @uses CustomerReponseCustomerAddressPostalAddress::setPOBoxDeviatingCityName()
     * @uses CustomerReponseCustomerAddressPostalAddress::setPOBoxID()
     * @uses CustomerReponseCustomerAddressPostalAddress::setPOBoxIndicator()
     * @uses CustomerReponseCustomerAddressPostalAddress::setTaxJurisdictionCode()
     * @uses CustomerReponseCustomerAddressPostalAddress::setTimeZoneCode()
     * @param string $countryCode
     * @param \StructType\RegionCode $regionCode
     * @param string $countyName
     * @param string $cityName
     * @param string $additionalCityName
     * @param string $districtName
     * @param string $streetPostalCode
     * @param string $pOBoxPostalCode
     * @param string $companyPostalCode
     * @param string $streetPrefixName
     * @param string $additionalStreetPrefixName
     * @param string $streetName
     * @param string $streetSuffixName
     * @param string $additionalStreetSuffixName
     * @param string $houseID
     * @param string $careOfName
     * @param string $pOBoxDeviatingCountryCode
     * @param \StructType\RegionCode $pOBoxDeviatingRegionCode
     * @param string $pOBoxDeviatingCityName
     * @param string $pOBoxID
     * @param bool $pOBoxIndicator
     * @param \StructType\TaxJurisdictionCode $taxJurisdictionCode
     * @param string $timeZoneCode
     */
    public function __construct($countryCode = null, \StructType\RegionCode $regionCode = null, $countyName = null, $cityName = null, $additionalCityName = null, $districtName = null, $streetPostalCode = null, $pOBoxPostalCode = null, $companyPostalCode = null, $streetPrefixName = null, $additionalStreetPrefixName = null, $streetName = null, $streetSuffixName = null, $additionalStreetSuffixName = null, $houseID = null, $careOfName = null, $pOBoxDeviatingCountryCode = null, \StructType\RegionCode $pOBoxDeviatingRegionCode = null, $pOBoxDeviatingCityName = null, $pOBoxID = null, $pOBoxIndicator = null, \StructType\TaxJurisdictionCode $taxJurisdictionCode = null, $timeZoneCode = null)
    {
        $this
            ->setCountryCode($countryCode)
            ->setRegionCode($regionCode)
            ->setCountyName($countyName)
            ->setCityName($cityName)
            ->setAdditionalCityName($additionalCityName)
            ->setDistrictName($districtName)
            ->setStreetPostalCode($streetPostalCode)
            ->setPOBoxPostalCode($pOBoxPostalCode)
            ->setCompanyPostalCode($companyPostalCode)
            ->setStreetPrefixName($streetPrefixName)
            ->setAdditionalStreetPrefixName($additionalStreetPrefixName)
            ->setStreetName($streetName)
            ->setStreetSuffixName($streetSuffixName)
            ->setAdditionalStreetSuffixName($additionalStreetSuffixName)
            ->setHouseID($houseID)
            ->setCareOfName($careOfName)
            ->setPOBoxDeviatingCountryCode($pOBoxDeviatingCountryCode)
            ->setPOBoxDeviatingRegionCode($pOBoxDeviatingRegionCode)
            ->setPOBoxDeviatingCityName($pOBoxDeviatingCityName)
            ->setPOBoxID($pOBoxID)
            ->setPOBoxIndicator($pOBoxIndicator)
            ->setTaxJurisdictionCode($taxJurisdictionCode)
            ->setTimeZoneCode($timeZoneCode);
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\CustomerReponseCustomerAddressPostalAddress
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($countryCode) && mb_strlen($countryCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($countryCode)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($countryCode) && mb_strlen($countryCode) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get RegionCode value
     * @return \StructType\RegionCode|null
     */
    public function getRegionCode()
    {
        return $this->RegionCode;
    }
    /**
     * Set RegionCode value
     * @param \StructType\RegionCode $regionCode
     * @return \StructType\CustomerReponseCustomerAddressPostalAddress
     */
    public function setRegionCode(\StructType\RegionCode $regionCode = null)
    {
        $this->RegionCode = $regionCode;
        return $this;
    }
    /**
     * Get CountyName value
     * @return string|null
     */
    public function getCountyName()
    {
        return $this->CountyName;
    }
    /**
     * Set CountyName value
     * @param string $countyName
     * @return \StructType\CustomerReponseCustomerAddressPostalAddress
     */
    public function setCountyName($countyName = null)
    {
        // validation for constraint: string
        if (!is_null($countyName) && !is_string($countyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countyName, true), gettype($countyName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($countyName) && mb_strlen($countyName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($countyName)), __LINE__);
        }
        $this->CountyName = $countyName;
        return $this;
    }
    /**
     * Get CityName value
     * @return string|null
     */
    public function getCityName()
    {
        return $this->CityName;
    }
    /**
     * Set CityName value
     * @param string $cityName
     * @return \StructType\CustomerReponseCustomerAddressPostalAddress
     */
    public function setCityName($cityName = null)
    {
        // validation for constraint: string
        if (!is_null($cityName) && !is_string($cityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityName, true), gettype($cityName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($cityName) && mb_strlen($cityName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($cityName)), __LINE__);
        }
        $this->CityName = $cityName;
        return $this;
    }
    /**
     * Get AdditionalCityName value
     * @return string|null
     */
    public function getAdditionalCityName()
    {
        return $this->AdditionalCityName;
    }
    /**
     * Set AdditionalCityName value
     * @param string $additionalCityName
     * @return \StructType\CustomerReponseCustomerAddressPostalAddress
     */
    public function setAdditionalCityName($additionalCityName = null)
    {
        // validation for constraint: string
        if (!is_null($additionalCityName) && !is_string($additionalCityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalCityName, true), gettype($additionalCityName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($additionalCityName) && mb_strlen($additionalCityName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($additionalCityName)), __LINE__);
        }
        $this->AdditionalCityName = $additionalCityName;
        return $this;
    }
    /**
     * Get DistrictName value
     * @return string|null
     */
    public function getDistrictName()
    {
        return $this->DistrictName;
    }
    /**
     * Set DistrictName value
     * @param string $districtName
     * @return \StructType\CustomerReponseCustomerAddressPostalAddress
     */
    public function setDistrictName($districtName = null)
    {
        // validation for constraint: string
        if (!is_null($districtName) && !is_string($districtName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($districtName, true), gettype($districtName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($districtName) && mb_strlen($districtName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($districtName)), __LINE__);
        }
        $this->DistrictName = $districtName;
        return $this;
    }
    /**
     * Get StreetPostalCode value
     * @return string|null
     */
    public function getStreetPostalCode()
    {
        return $this->StreetPostalCode;
    }
    /**
     * Set StreetPostalCode value
     * @param string $streetPostalCode
     * @return \StructType\CustomerReponseCustomerAddressPostalAddress
     */
    public function setStreetPostalCode($streetPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($streetPostalCode) && !is_string($streetPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetPostalCode, true), gettype($streetPostalCode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($streetPostalCode) && mb_strlen($streetPostalCode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($streetPostalCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($streetPostalCode) && mb_strlen($streetPostalCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($streetPostalCode)), __LINE__);
        }
        $this->StreetPostalCode = $streetPostalCode;
        return $this;
    }
    /**
     * Get POBoxPostalCode value
     * @return string|null
     */
    public function getPOBoxPostalCode()
    {
        return $this->POBoxPostalCode;
    }
    /**
     * Set POBoxPostalCode value
     * @param string $pOBoxPostalCode
     * @return \StructType\CustomerReponseCustomerAddressPostalAddress
     */
    public function setPOBoxPostalCode($pOBoxPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($pOBoxPostalCode) && !is_string($pOBoxPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pOBoxPostalCode, true), gettype($pOBoxPostalCode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($pOBoxPostalCode) && mb_strlen($pOBoxPostalCode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($pOBoxPostalCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($pOBoxPostalCode) && mb_strlen($pOBoxPostalCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($pOBoxPostalCode)), __LINE__);
        }
        $this->POBoxPostalCode = $pOBoxPostalCode;
        return $this;
    }
    /**
     * Get CompanyPostalCode value
     * @return string|null
     */
    public function getCompanyPostalCode()
    {
        return $this->CompanyPostalCode;
    }
    /**
     * Set CompanyPostalCode value
     * @param string $companyPostalCode
     * @return \StructType\CustomerReponseCustomerAddressPostalAddress
     */
    public function setCompanyPostalCode($companyPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($companyPostalCode) && !is_string($companyPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyPostalCode, true), gettype($companyPostalCode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($companyPostalCode) && mb_strlen($companyPostalCode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($companyPostalCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($companyPostalCode) && mb_strlen($companyPostalCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($companyPostalCode)), __LINE__);
        }
        $this->CompanyPostalCode = $companyPostalCode;
        return $this;
    }
    /**
     * Get StreetPrefixName value
     * @return string|null
     */
    public function getStreetPrefixName()
    {
        return $this->StreetPrefixName;
    }
    /**
     * Set StreetPrefixName value
     * @param string $streetPrefixName
     * @return \StructType\CustomerReponseCustomerAddressPostalAddress
     */
    public function setStreetPrefixName($streetPrefixName = null)
    {
        // validation for constraint: string
        if (!is_null($streetPrefixName) && !is_string($streetPrefixName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetPrefixName, true), gettype($streetPrefixName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($streetPrefixName) && mb_strlen($streetPrefixName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($streetPrefixName)), __LINE__);
        }
        $this->StreetPrefixName = $streetPrefixName;
        return $this;
    }
    /**
     * Get AdditionalStreetPrefixName value
     * @return string|null
     */
    public function getAdditionalStreetPrefixName()
    {
        return $this->AdditionalStreetPrefixName;
    }
    /**
     * Set AdditionalStreetPrefixName value
     * @param string $additionalStreetPrefixName
     * @return \StructType\CustomerReponseCustomerAddressPostalAddress
     */
    public function setAdditionalStreetPrefixName($additionalStreetPrefixName = null)
    {
        // validation for constraint: string
        if (!is_null($additionalStreetPrefixName) && !is_string($additionalStreetPrefixName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalStreetPrefixName, true), gettype($additionalStreetPrefixName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($additionalStreetPrefixName) && mb_strlen($additionalStreetPrefixName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($additionalStreetPrefixName)), __LINE__);
        }
        $this->AdditionalStreetPrefixName = $additionalStreetPrefixName;
        return $this;
    }
    /**
     * Get StreetName value
     * @return string|null
     */
    public function getStreetName()
    {
        return $this->StreetName;
    }
    /**
     * Set StreetName value
     * @param string $streetName
     * @return \StructType\CustomerReponseCustomerAddressPostalAddress
     */
    public function setStreetName($streetName = null)
    {
        // validation for constraint: string
        if (!is_null($streetName) && !is_string($streetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetName, true), gettype($streetName)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($streetName) && mb_strlen($streetName) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($streetName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($streetName) && mb_strlen($streetName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($streetName)), __LINE__);
        }
        $this->StreetName = $streetName;
        return $this;
    }
    /**
     * Get StreetSuffixName value
     * @return string|null
     */
    public function getStreetSuffixName()
    {
        return $this->StreetSuffixName;
    }
    /**
     * Set StreetSuffixName value
     * @param string $streetSuffixName
     * @return \StructType\CustomerReponseCustomerAddressPostalAddress
     */
    public function setStreetSuffixName($streetSuffixName = null)
    {
        // validation for constraint: string
        if (!is_null($streetSuffixName) && !is_string($streetSuffixName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetSuffixName, true), gettype($streetSuffixName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($streetSuffixName) && mb_strlen($streetSuffixName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($streetSuffixName)), __LINE__);
        }
        $this->StreetSuffixName = $streetSuffixName;
        return $this;
    }
    /**
     * Get AdditionalStreetSuffixName value
     * @return string|null
     */
    public function getAdditionalStreetSuffixName()
    {
        return $this->AdditionalStreetSuffixName;
    }
    /**
     * Set AdditionalStreetSuffixName value
     * @param string $additionalStreetSuffixName
     * @return \StructType\CustomerReponseCustomerAddressPostalAddress
     */
    public function setAdditionalStreetSuffixName($additionalStreetSuffixName = null)
    {
        // validation for constraint: string
        if (!is_null($additionalStreetSuffixName) && !is_string($additionalStreetSuffixName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalStreetSuffixName, true), gettype($additionalStreetSuffixName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($additionalStreetSuffixName) && mb_strlen($additionalStreetSuffixName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($additionalStreetSuffixName)), __LINE__);
        }
        $this->AdditionalStreetSuffixName = $additionalStreetSuffixName;
        return $this;
    }
    /**
     * Get HouseID value
     * @return string|null
     */
    public function getHouseID()
    {
        return $this->HouseID;
    }
    /**
     * Set HouseID value
     * @param string $houseID
     * @return \StructType\CustomerReponseCustomerAddressPostalAddress
     */
    public function setHouseID($houseID = null)
    {
        // validation for constraint: string
        if (!is_null($houseID) && !is_string($houseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($houseID, true), gettype($houseID)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($houseID) && mb_strlen($houseID) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($houseID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($houseID) && mb_strlen($houseID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($houseID)), __LINE__);
        }
        $this->HouseID = $houseID;
        return $this;
    }
    /**
     * Get CareOfName value
     * @return string|null
     */
    public function getCareOfName()
    {
        return $this->CareOfName;
    }
    /**
     * Set CareOfName value
     * @param string $careOfName
     * @return \StructType\CustomerReponseCustomerAddressPostalAddress
     */
    public function setCareOfName($careOfName = null)
    {
        // validation for constraint: string
        if (!is_null($careOfName) && !is_string($careOfName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($careOfName, true), gettype($careOfName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($careOfName) && mb_strlen($careOfName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($careOfName)), __LINE__);
        }
        $this->CareOfName = $careOfName;
        return $this;
    }
    /**
     * Get POBoxDeviatingCountryCode value
     * @return string|null
     */
    public function getPOBoxDeviatingCountryCode()
    {
        return $this->POBoxDeviatingCountryCode;
    }
    /**
     * Set POBoxDeviatingCountryCode value
     * @param string $pOBoxDeviatingCountryCode
     * @return \StructType\CustomerReponseCustomerAddressPostalAddress
     */
    public function setPOBoxDeviatingCountryCode($pOBoxDeviatingCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($pOBoxDeviatingCountryCode) && !is_string($pOBoxDeviatingCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pOBoxDeviatingCountryCode, true), gettype($pOBoxDeviatingCountryCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($pOBoxDeviatingCountryCode) && mb_strlen($pOBoxDeviatingCountryCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($pOBoxDeviatingCountryCode)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($pOBoxDeviatingCountryCode) && mb_strlen($pOBoxDeviatingCountryCode) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($pOBoxDeviatingCountryCode)), __LINE__);
        }
        $this->POBoxDeviatingCountryCode = $pOBoxDeviatingCountryCode;
        return $this;
    }
    /**
     * Get POBoxDeviatingRegionCode value
     * @return \StructType\RegionCode|null
     */
    public function getPOBoxDeviatingRegionCode()
    {
        return $this->POBoxDeviatingRegionCode;
    }
    /**
     * Set POBoxDeviatingRegionCode value
     * @param \StructType\RegionCode $pOBoxDeviatingRegionCode
     * @return \StructType\CustomerReponseCustomerAddressPostalAddress
     */
    public function setPOBoxDeviatingRegionCode(\StructType\RegionCode $pOBoxDeviatingRegionCode = null)
    {
        $this->POBoxDeviatingRegionCode = $pOBoxDeviatingRegionCode;
        return $this;
    }
    /**
     * Get POBoxDeviatingCityName value
     * @return string|null
     */
    public function getPOBoxDeviatingCityName()
    {
        return $this->POBoxDeviatingCityName;
    }
    /**
     * Set POBoxDeviatingCityName value
     * @param string $pOBoxDeviatingCityName
     * @return \StructType\CustomerReponseCustomerAddressPostalAddress
     */
    public function setPOBoxDeviatingCityName($pOBoxDeviatingCityName = null)
    {
        // validation for constraint: string
        if (!is_null($pOBoxDeviatingCityName) && !is_string($pOBoxDeviatingCityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pOBoxDeviatingCityName, true), gettype($pOBoxDeviatingCityName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($pOBoxDeviatingCityName) && mb_strlen($pOBoxDeviatingCityName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($pOBoxDeviatingCityName)), __LINE__);
        }
        $this->POBoxDeviatingCityName = $pOBoxDeviatingCityName;
        return $this;
    }
    /**
     * Get POBoxID value
     * @return string|null
     */
    public function getPOBoxID()
    {
        return $this->POBoxID;
    }
    /**
     * Set POBoxID value
     * @param string $pOBoxID
     * @return \StructType\CustomerReponseCustomerAddressPostalAddress
     */
    public function setPOBoxID($pOBoxID = null)
    {
        // validation for constraint: string
        if (!is_null($pOBoxID) && !is_string($pOBoxID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pOBoxID, true), gettype($pOBoxID)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($pOBoxID) && mb_strlen($pOBoxID) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($pOBoxID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($pOBoxID) && mb_strlen($pOBoxID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($pOBoxID)), __LINE__);
        }
        $this->POBoxID = $pOBoxID;
        return $this;
    }
    /**
     * Get POBoxIndicator value
     * @return bool|null
     */
    public function getPOBoxIndicator()
    {
        return $this->POBoxIndicator;
    }
    /**
     * Set POBoxIndicator value
     * @param bool $pOBoxIndicator
     * @return \StructType\CustomerReponseCustomerAddressPostalAddress
     */
    public function setPOBoxIndicator($pOBoxIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($pOBoxIndicator) && !is_bool($pOBoxIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pOBoxIndicator, true), gettype($pOBoxIndicator)), __LINE__);
        }
        $this->POBoxIndicator = $pOBoxIndicator;
        return $this;
    }
    /**
     * Get TaxJurisdictionCode value
     * @return \StructType\TaxJurisdictionCode|null
     */
    public function getTaxJurisdictionCode()
    {
        return $this->TaxJurisdictionCode;
    }
    /**
     * Set TaxJurisdictionCode value
     * @param \StructType\TaxJurisdictionCode $taxJurisdictionCode
     * @return \StructType\CustomerReponseCustomerAddressPostalAddress
     */
    public function setTaxJurisdictionCode(\StructType\TaxJurisdictionCode $taxJurisdictionCode = null)
    {
        $this->TaxJurisdictionCode = $taxJurisdictionCode;
        return $this;
    }
    /**
     * Get TimeZoneCode value
     * @return string|null
     */
    public function getTimeZoneCode()
    {
        return $this->TimeZoneCode;
    }
    /**
     * Set TimeZoneCode value
     * @param string $timeZoneCode
     * @return \StructType\CustomerReponseCustomerAddressPostalAddress
     */
    public function setTimeZoneCode($timeZoneCode = null)
    {
        // validation for constraint: string
        if (!is_null($timeZoneCode) && !is_string($timeZoneCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeZoneCode, true), gettype($timeZoneCode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($timeZoneCode) && mb_strlen($timeZoneCode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($timeZoneCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($timeZoneCode) && mb_strlen($timeZoneCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($timeZoneCode)), __LINE__);
        }
        $this->TimeZoneCode = $timeZoneCode;
        return $this;
    }
}
