<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CashDiscountTermsCode StructType
 * Meta information extracted from the WSDL
 * - documentation: Code
 * - base: xsd:token
 * - maxLength: 4
 * - minLength: 1
 * @subpackage Structs
 */
class CashDiscountTermsCode extends AbstractStructBase
{
    /**
     * The _
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 4
     * - minLength: 1
     * @var string
     */
    public $_;
    /**
     * The listAgencyID
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $listAgencyID;
    /**
     * Constructor method for CashDiscountTermsCode
     * @uses CashDiscountTermsCode::set_()
     * @uses CashDiscountTermsCode::setListAgencyID()
     * @param string $_
     * @param string $listAgencyID
     */
    public function __construct($_ = null, $listAgencyID = null)
    {
        $this
            ->set_($_)
            ->setListAgencyID($listAgencyID);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\CashDiscountTermsCode
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($_) && mb_strlen($_) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($_)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($_) && mb_strlen($_) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get listAgencyID value
     * @return string|null
     */
    public function getListAgencyID()
    {
        return $this->listAgencyID;
    }
    /**
     * Set listAgencyID value
     * @param string $listAgencyID
     * @return \StructType\CashDiscountTermsCode
     */
    public function setListAgencyID($listAgencyID = null)
    {
        // validation for constraint: string
        if (!is_null($listAgencyID) && !is_string($listAgencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($listAgencyID, true), gettype($listAgencyID)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($listAgencyID) && mb_strlen($listAgencyID) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($listAgencyID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($listAgencyID) && mb_strlen($listAgencyID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($listAgencyID)), __LINE__);
        }
        $this->listAgencyID = $listAgencyID;
        return $this;
    }
}
