<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SelectionByIdentifier StructType
 * @subpackage Structs
 */
class SelectionByIdentifier extends AbstractStructBase
{
    /**
     * The InclusionExclusionCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $InclusionExclusionCode;
    /**
     * The IntervalBoundaryTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * @var string
     */
    public $IntervalBoundaryTypeCode;
    /**
     * The LowerBoundaryIdentifier
     * Meta information extracted from the WSDL
     * - documentation: Text
     * - base: xsd:string
     * - minOccurs: 0
     * @var string
     */
    public $LowerBoundaryIdentifier;
    /**
     * The UpperBoundaryIdentifier
     * Meta information extracted from the WSDL
     * - documentation: Text
     * - base: xsd:string
     * - minOccurs: 0
     * @var string
     */
    public $UpperBoundaryIdentifier;
    /**
     * Constructor method for SelectionByIdentifier
     * @uses SelectionByIdentifier::setInclusionExclusionCode()
     * @uses SelectionByIdentifier::setIntervalBoundaryTypeCode()
     * @uses SelectionByIdentifier::setLowerBoundaryIdentifier()
     * @uses SelectionByIdentifier::setUpperBoundaryIdentifier()
     * @param string $inclusionExclusionCode
     * @param string $intervalBoundaryTypeCode
     * @param string $lowerBoundaryIdentifier
     * @param string $upperBoundaryIdentifier
     */
    public function __construct($inclusionExclusionCode = null, $intervalBoundaryTypeCode = null, $lowerBoundaryIdentifier = null, $upperBoundaryIdentifier = null)
    {
        $this
            ->setInclusionExclusionCode($inclusionExclusionCode)
            ->setIntervalBoundaryTypeCode($intervalBoundaryTypeCode)
            ->setLowerBoundaryIdentifier($lowerBoundaryIdentifier)
            ->setUpperBoundaryIdentifier($upperBoundaryIdentifier);
    }
    /**
     * Get InclusionExclusionCode value
     * @return string|null
     */
    public function getInclusionExclusionCode()
    {
        return $this->InclusionExclusionCode;
    }
    /**
     * Set InclusionExclusionCode value
     * @param string $inclusionExclusionCode
     * @return \StructType\SelectionByIdentifier
     */
    public function setInclusionExclusionCode($inclusionExclusionCode = null)
    {
        // validation for constraint: string
        if (!is_null($inclusionExclusionCode) && !is_string($inclusionExclusionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inclusionExclusionCode, true), gettype($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        $this->InclusionExclusionCode = $inclusionExclusionCode;
        return $this;
    }
    /**
     * Get IntervalBoundaryTypeCode value
     * @return string|null
     */
    public function getIntervalBoundaryTypeCode()
    {
        return $this->IntervalBoundaryTypeCode;
    }
    /**
     * Set IntervalBoundaryTypeCode value
     * @param string $intervalBoundaryTypeCode
     * @return \StructType\SelectionByIdentifier
     */
    public function setIntervalBoundaryTypeCode($intervalBoundaryTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($intervalBoundaryTypeCode) && !is_string($intervalBoundaryTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intervalBoundaryTypeCode, true), gettype($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        $this->IntervalBoundaryTypeCode = $intervalBoundaryTypeCode;
        return $this;
    }
    /**
     * Get LowerBoundaryIdentifier value
     * @return string|null
     */
    public function getLowerBoundaryIdentifier()
    {
        return $this->LowerBoundaryIdentifier;
    }
    /**
     * Set LowerBoundaryIdentifier value
     * @param string $lowerBoundaryIdentifier
     * @return \StructType\SelectionByIdentifier
     */
    public function setLowerBoundaryIdentifier($lowerBoundaryIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($lowerBoundaryIdentifier) && !is_string($lowerBoundaryIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lowerBoundaryIdentifier, true), gettype($lowerBoundaryIdentifier)), __LINE__);
        }
        $this->LowerBoundaryIdentifier = $lowerBoundaryIdentifier;
        return $this;
    }
    /**
     * Get UpperBoundaryIdentifier value
     * @return string|null
     */
    public function getUpperBoundaryIdentifier()
    {
        return $this->UpperBoundaryIdentifier;
    }
    /**
     * Set UpperBoundaryIdentifier value
     * @param string $upperBoundaryIdentifier
     * @return \StructType\SelectionByIdentifier
     */
    public function setUpperBoundaryIdentifier($upperBoundaryIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($upperBoundaryIdentifier) && !is_string($upperBoundaryIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upperBoundaryIdentifier, true), gettype($upperBoundaryIdentifier)), __LINE__);
        }
        $this->UpperBoundaryIdentifier = $upperBoundaryIdentifier;
        return $this;
    }
}
