<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseProcessingConditions StructType
 * @subpackage Structs
 */
class ResponseProcessingConditions extends AbstractStructBase
{
    /**
     * The ReturnedQueryHitsNumberValue
     * Meta information extracted from the WSDL
     * - documentation: Value
     * - base: xsd:int
     * - maxInclusive: 999999999
     * - minInclusive: 0
     * @var int
     */
    public $ReturnedQueryHitsNumberValue;
    /**
     * The MoreHitsAvailableIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator
     * - base: xsd:boolean
     * @var bool
     */
    public $MoreHitsAvailableIndicator;
    /**
     * The LastReturnedObjectID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ObjectID
     */
    public $LastReturnedObjectID;
    /**
     * Constructor method for ResponseProcessingConditions
     * @uses ResponseProcessingConditions::setReturnedQueryHitsNumberValue()
     * @uses ResponseProcessingConditions::setMoreHitsAvailableIndicator()
     * @uses ResponseProcessingConditions::setLastReturnedObjectID()
     * @param int $returnedQueryHitsNumberValue
     * @param bool $moreHitsAvailableIndicator
     * @param \StructType\ObjectID $lastReturnedObjectID
     */
    public function __construct($returnedQueryHitsNumberValue = null, $moreHitsAvailableIndicator = null, \StructType\ObjectID $lastReturnedObjectID = null)
    {
        $this
            ->setReturnedQueryHitsNumberValue($returnedQueryHitsNumberValue)
            ->setMoreHitsAvailableIndicator($moreHitsAvailableIndicator)
            ->setLastReturnedObjectID($lastReturnedObjectID);
    }
    /**
     * Get ReturnedQueryHitsNumberValue value
     * @return int|null
     */
    public function getReturnedQueryHitsNumberValue()
    {
        return $this->ReturnedQueryHitsNumberValue;
    }
    /**
     * Set ReturnedQueryHitsNumberValue value
     * @param int $returnedQueryHitsNumberValue
     * @return \StructType\ResponseProcessingConditions
     */
    public function setReturnedQueryHitsNumberValue($returnedQueryHitsNumberValue = null)
    {
        // validation for constraint: int
        if (!is_null($returnedQueryHitsNumberValue) && !(is_int($returnedQueryHitsNumberValue) || ctype_digit($returnedQueryHitsNumberValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($returnedQueryHitsNumberValue, true), gettype($returnedQueryHitsNumberValue)), __LINE__);
        }
        // validation for constraint: maxInclusive(999999999)
        if (!is_null($returnedQueryHitsNumberValue) && $returnedQueryHitsNumberValue > 999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999999999', var_export($returnedQueryHitsNumberValue, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($returnedQueryHitsNumberValue) && $returnedQueryHitsNumberValue < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($returnedQueryHitsNumberValue, true)), __LINE__);
        }
        $this->ReturnedQueryHitsNumberValue = $returnedQueryHitsNumberValue;
        return $this;
    }
    /**
     * Get MoreHitsAvailableIndicator value
     * @return bool|null
     */
    public function getMoreHitsAvailableIndicator()
    {
        return $this->MoreHitsAvailableIndicator;
    }
    /**
     * Set MoreHitsAvailableIndicator value
     * @param bool $moreHitsAvailableIndicator
     * @return \StructType\ResponseProcessingConditions
     */
    public function setMoreHitsAvailableIndicator($moreHitsAvailableIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($moreHitsAvailableIndicator) && !is_bool($moreHitsAvailableIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($moreHitsAvailableIndicator, true), gettype($moreHitsAvailableIndicator)), __LINE__);
        }
        $this->MoreHitsAvailableIndicator = $moreHitsAvailableIndicator;
        return $this;
    }
    /**
     * Get LastReturnedObjectID value
     * @return \StructType\ObjectID|null
     */
    public function getLastReturnedObjectID()
    {
        return $this->LastReturnedObjectID;
    }
    /**
     * Set LastReturnedObjectID value
     * @param \StructType\ObjectID $lastReturnedObjectID
     * @return \StructType\ResponseProcessingConditions
     */
    public function setLastReturnedObjectID(\StructType\ObjectID $lastReturnedObjectID = null)
    {
        $this->LastReturnedObjectID = $lastReturnedObjectID;
        return $this;
    }
}
