<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NamespaceURI StructType
 * Meta information extracted from the WSDL
 * - documentation: URI
 * @subpackage Structs
 */
class NamespaceURI extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The schemeID
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $schemeID;
    /**
     * Constructor method for NamespaceURI
     * @uses NamespaceURI::set_()
     * @uses NamespaceURI::setSchemeID()
     * @param string $_
     * @param string $schemeID
     */
    public function __construct($_ = null, $schemeID = null)
    {
        $this
            ->set_($_)
            ->setSchemeID($schemeID);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\NamespaceURI
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get schemeID value
     * @return string|null
     */
    public function getSchemeID()
    {
        return $this->schemeID;
    }
    /**
     * Set schemeID value
     * @param string $schemeID
     * @return \StructType\NamespaceURI
     */
    public function setSchemeID($schemeID = null)
    {
        // validation for constraint: string
        if (!is_null($schemeID) && !is_string($schemeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeID, true), gettype($schemeID)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($schemeID) && mb_strlen($schemeID) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($schemeID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($schemeID) && mb_strlen($schemeID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($schemeID)), __LINE__);
        }
        $this->schemeID = $schemeID;
        return $this;
    }
}
