<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerSelectionByLifeCycleStatusCode StructType
 * @subpackage Structs
 */
class CustomerSelectionByLifeCycleStatusCode extends AbstractStructBase
{
    /**
     * The InclusionExclusionCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $InclusionExclusionCode;
    /**
     * The IntervalBoundaryTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntervalBoundaryTypeCode;
    /**
     * The LowerBoundaryLifeCycleStatusCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LowerBoundaryLifeCycleStatusCode;
    /**
     * The UpperBoundaryLifeCycleStatusCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UpperBoundaryLifeCycleStatusCode;
    /**
     * Constructor method for CustomerSelectionByLifeCycleStatusCode
     * @uses CustomerSelectionByLifeCycleStatusCode::setInclusionExclusionCode()
     * @uses CustomerSelectionByLifeCycleStatusCode::setIntervalBoundaryTypeCode()
     * @uses CustomerSelectionByLifeCycleStatusCode::setLowerBoundaryLifeCycleStatusCode()
     * @uses CustomerSelectionByLifeCycleStatusCode::setUpperBoundaryLifeCycleStatusCode()
     * @param string $inclusionExclusionCode
     * @param string $intervalBoundaryTypeCode
     * @param string $lowerBoundaryLifeCycleStatusCode
     * @param string $upperBoundaryLifeCycleStatusCode
     */
    public function __construct($inclusionExclusionCode = null, $intervalBoundaryTypeCode = null, $lowerBoundaryLifeCycleStatusCode = null, $upperBoundaryLifeCycleStatusCode = null)
    {
        $this
            ->setInclusionExclusionCode($inclusionExclusionCode)
            ->setIntervalBoundaryTypeCode($intervalBoundaryTypeCode)
            ->setLowerBoundaryLifeCycleStatusCode($lowerBoundaryLifeCycleStatusCode)
            ->setUpperBoundaryLifeCycleStatusCode($upperBoundaryLifeCycleStatusCode);
    }
    /**
     * Get InclusionExclusionCode value
     * @return string|null
     */
    public function getInclusionExclusionCode()
    {
        return $this->InclusionExclusionCode;
    }
    /**
     * Set InclusionExclusionCode value
     * @param string $inclusionExclusionCode
     * @return \StructType\CustomerSelectionByLifeCycleStatusCode
     */
    public function setInclusionExclusionCode($inclusionExclusionCode = null)
    {
        // validation for constraint: string
        if (!is_null($inclusionExclusionCode) && !is_string($inclusionExclusionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inclusionExclusionCode, true), gettype($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        $this->InclusionExclusionCode = $inclusionExclusionCode;
        return $this;
    }
    /**
     * Get IntervalBoundaryTypeCode value
     * @return string|null
     */
    public function getIntervalBoundaryTypeCode()
    {
        return $this->IntervalBoundaryTypeCode;
    }
    /**
     * Set IntervalBoundaryTypeCode value
     * @param string $intervalBoundaryTypeCode
     * @return \StructType\CustomerSelectionByLifeCycleStatusCode
     */
    public function setIntervalBoundaryTypeCode($intervalBoundaryTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($intervalBoundaryTypeCode) && !is_string($intervalBoundaryTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intervalBoundaryTypeCode, true), gettype($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        $this->IntervalBoundaryTypeCode = $intervalBoundaryTypeCode;
        return $this;
    }
    /**
     * Get LowerBoundaryLifeCycleStatusCode value
     * @return string|null
     */
    public function getLowerBoundaryLifeCycleStatusCode()
    {
        return $this->LowerBoundaryLifeCycleStatusCode;
    }
    /**
     * Set LowerBoundaryLifeCycleStatusCode value
     * @uses \EnumType\NOTDELETED_PartyLifeCycleStatusCode::valueIsValid()
     * @uses \EnumType\NOTDELETED_PartyLifeCycleStatusCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lowerBoundaryLifeCycleStatusCode
     * @return \StructType\CustomerSelectionByLifeCycleStatusCode
     */
    public function setLowerBoundaryLifeCycleStatusCode($lowerBoundaryLifeCycleStatusCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\NOTDELETED_PartyLifeCycleStatusCode::valueIsValid($lowerBoundaryLifeCycleStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\NOTDELETED_PartyLifeCycleStatusCode', is_array($lowerBoundaryLifeCycleStatusCode) ? implode(', ', $lowerBoundaryLifeCycleStatusCode) : var_export($lowerBoundaryLifeCycleStatusCode, true), implode(', ', \EnumType\NOTDELETED_PartyLifeCycleStatusCode::getValidValues())), __LINE__);
        }
        $this->LowerBoundaryLifeCycleStatusCode = $lowerBoundaryLifeCycleStatusCode;
        return $this;
    }
    /**
     * Get UpperBoundaryLifeCycleStatusCode value
     * @return string|null
     */
    public function getUpperBoundaryLifeCycleStatusCode()
    {
        return $this->UpperBoundaryLifeCycleStatusCode;
    }
    /**
     * Set UpperBoundaryLifeCycleStatusCode value
     * @uses \EnumType\NOTDELETED_PartyLifeCycleStatusCode::valueIsValid()
     * @uses \EnumType\NOTDELETED_PartyLifeCycleStatusCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $upperBoundaryLifeCycleStatusCode
     * @return \StructType\CustomerSelectionByLifeCycleStatusCode
     */
    public function setUpperBoundaryLifeCycleStatusCode($upperBoundaryLifeCycleStatusCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\NOTDELETED_PartyLifeCycleStatusCode::valueIsValid($upperBoundaryLifeCycleStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\NOTDELETED_PartyLifeCycleStatusCode', is_array($upperBoundaryLifeCycleStatusCode) ? implode(', ', $upperBoundaryLifeCycleStatusCode) : var_export($upperBoundaryLifeCycleStatusCode, true), implode(', ', \EnumType\NOTDELETED_PartyLifeCycleStatusCode::getValidValues())), __LINE__);
        }
        $this->UpperBoundaryLifeCycleStatusCode = $upperBoundaryLifeCycleStatusCode;
        return $this;
    }
}
