<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerSelectionByChangeDateTime StructType
 * @subpackage Structs
 */
class CustomerSelectionByChangeDateTime extends AbstractStructBase
{
    /**
     * The InclusionExclusionCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $InclusionExclusionCode;
    /**
     * The IntervalBoundaryDateTime
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * @var string
     */
    public $IntervalBoundaryDateTime;
    /**
     * The LowerBoundaryDateTime
     * Meta information extracted from the WSDL
     * - documentation: DateTime
     * - base: xsd:dateTime
     * - minOccurs: 0
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z
     * @var string
     */
    public $LowerBoundaryDateTime;
    /**
     * The UpperBoundaryDateTime
     * Meta information extracted from the WSDL
     * - documentation: DateTime
     * - base: xsd:dateTime
     * - minOccurs: 0
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z
     * @var string
     */
    public $UpperBoundaryDateTime;
    /**
     * Constructor method for CustomerSelectionByChangeDateTime
     * @uses CustomerSelectionByChangeDateTime::setInclusionExclusionCode()
     * @uses CustomerSelectionByChangeDateTime::setIntervalBoundaryDateTime()
     * @uses CustomerSelectionByChangeDateTime::setLowerBoundaryDateTime()
     * @uses CustomerSelectionByChangeDateTime::setUpperBoundaryDateTime()
     * @param string $inclusionExclusionCode
     * @param string $intervalBoundaryDateTime
     * @param string $lowerBoundaryDateTime
     * @param string $upperBoundaryDateTime
     */
    public function __construct($inclusionExclusionCode = null, $intervalBoundaryDateTime = null, $lowerBoundaryDateTime = null, $upperBoundaryDateTime = null)
    {
        $this
            ->setInclusionExclusionCode($inclusionExclusionCode)
            ->setIntervalBoundaryDateTime($intervalBoundaryDateTime)
            ->setLowerBoundaryDateTime($lowerBoundaryDateTime)
            ->setUpperBoundaryDateTime($upperBoundaryDateTime);
    }
    /**
     * Get InclusionExclusionCode value
     * @return string|null
     */
    public function getInclusionExclusionCode()
    {
        return $this->InclusionExclusionCode;
    }
    /**
     * Set InclusionExclusionCode value
     * @param string $inclusionExclusionCode
     * @return \StructType\CustomerSelectionByChangeDateTime
     */
    public function setInclusionExclusionCode($inclusionExclusionCode = null)
    {
        // validation for constraint: string
        if (!is_null($inclusionExclusionCode) && !is_string($inclusionExclusionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inclusionExclusionCode, true), gettype($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        $this->InclusionExclusionCode = $inclusionExclusionCode;
        return $this;
    }
    /**
     * Get IntervalBoundaryDateTime value
     * @return string|null
     */
    public function getIntervalBoundaryDateTime()
    {
        return $this->IntervalBoundaryDateTime;
    }
    /**
     * Set IntervalBoundaryDateTime value
     * @param string $intervalBoundaryDateTime
     * @return \StructType\CustomerSelectionByChangeDateTime
     */
    public function setIntervalBoundaryDateTime($intervalBoundaryDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($intervalBoundaryDateTime) && !is_string($intervalBoundaryDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intervalBoundaryDateTime, true), gettype($intervalBoundaryDateTime)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($intervalBoundaryDateTime) && mb_strlen($intervalBoundaryDateTime) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($intervalBoundaryDateTime)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($intervalBoundaryDateTime) && mb_strlen($intervalBoundaryDateTime) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($intervalBoundaryDateTime)), __LINE__);
        }
        $this->IntervalBoundaryDateTime = $intervalBoundaryDateTime;
        return $this;
    }
    /**
     * Get LowerBoundaryDateTime value
     * @return string|null
     */
    public function getLowerBoundaryDateTime()
    {
        return $this->LowerBoundaryDateTime;
    }
    /**
     * Set LowerBoundaryDateTime value
     * @param string $lowerBoundaryDateTime
     * @return \StructType\CustomerSelectionByChangeDateTime
     */
    public function setLowerBoundaryDateTime($lowerBoundaryDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lowerBoundaryDateTime) && !is_string($lowerBoundaryDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lowerBoundaryDateTime, true), gettype($lowerBoundaryDateTime)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z)
        if (!is_null($lowerBoundaryDateTime) && !preg_match('/[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z/', $lowerBoundaryDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z', var_export($lowerBoundaryDateTime, true)), __LINE__);
        }
        $this->LowerBoundaryDateTime = $lowerBoundaryDateTime;
        return $this;
    }
    /**
     * Get UpperBoundaryDateTime value
     * @return string|null
     */
    public function getUpperBoundaryDateTime()
    {
        return $this->UpperBoundaryDateTime;
    }
    /**
     * Set UpperBoundaryDateTime value
     * @param string $upperBoundaryDateTime
     * @return \StructType\CustomerSelectionByChangeDateTime
     */
    public function setUpperBoundaryDateTime($upperBoundaryDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($upperBoundaryDateTime) && !is_string($upperBoundaryDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upperBoundaryDateTime, true), gettype($upperBoundaryDateTime)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z)
        if (!is_null($upperBoundaryDateTime) && !preg_match('/[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z/', $upperBoundaryDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z', var_export($upperBoundaryDateTime, true)), __LINE__);
        }
        $this->UpperBoundaryDateTime = $upperBoundaryDateTime;
        return $this;
    }
}
