<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerReponseCustomerFormattedAddress StructType
 * @subpackage Structs
 */
class CustomerReponseCustomerFormattedAddress extends AbstractStructBase
{
    /**
     * The FormattedAddressDescription
     * Meta information extracted from the WSDL
     * - documentation: Description
     * - base: xsd:string
     * - maxLength: 80
     * - minOccurs: 0
     * @var string
     */
    public $FormattedAddressDescription;
    /**
     * The FormattedPostalAddressDescription
     * Meta information extracted from the WSDL
     * - documentation: Description
     * - base: xsd:string
     * - maxLength: 80
     * - minOccurs: 0
     * @var string
     */
    public $FormattedPostalAddressDescription;
    /**
     * The FormattedAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FormattedAddress
     */
    public $FormattedAddress;
    /**
     * The FormattedPostalAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FormattedPostalAddress
     */
    public $FormattedPostalAddress;
    /**
     * Constructor method for CustomerReponseCustomerFormattedAddress
     * @uses CustomerReponseCustomerFormattedAddress::setFormattedAddressDescription()
     * @uses CustomerReponseCustomerFormattedAddress::setFormattedPostalAddressDescription()
     * @uses CustomerReponseCustomerFormattedAddress::setFormattedAddress()
     * @uses CustomerReponseCustomerFormattedAddress::setFormattedPostalAddress()
     * @param string $formattedAddressDescription
     * @param string $formattedPostalAddressDescription
     * @param \StructType\FormattedAddress $formattedAddress
     * @param \StructType\FormattedPostalAddress $formattedPostalAddress
     */
    public function __construct($formattedAddressDescription = null, $formattedPostalAddressDescription = null, \StructType\FormattedAddress $formattedAddress = null, \StructType\FormattedPostalAddress $formattedPostalAddress = null)
    {
        $this
            ->setFormattedAddressDescription($formattedAddressDescription)
            ->setFormattedPostalAddressDescription($formattedPostalAddressDescription)
            ->setFormattedAddress($formattedAddress)
            ->setFormattedPostalAddress($formattedPostalAddress);
    }
    /**
     * Get FormattedAddressDescription value
     * @return string|null
     */
    public function getFormattedAddressDescription()
    {
        return $this->FormattedAddressDescription;
    }
    /**
     * Set FormattedAddressDescription value
     * @param string $formattedAddressDescription
     * @return \StructType\CustomerReponseCustomerFormattedAddress
     */
    public function setFormattedAddressDescription($formattedAddressDescription = null)
    {
        // validation for constraint: string
        if (!is_null($formattedAddressDescription) && !is_string($formattedAddressDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formattedAddressDescription, true), gettype($formattedAddressDescription)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($formattedAddressDescription) && mb_strlen($formattedAddressDescription) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($formattedAddressDescription)), __LINE__);
        }
        $this->FormattedAddressDescription = $formattedAddressDescription;
        return $this;
    }
    /**
     * Get FormattedPostalAddressDescription value
     * @return string|null
     */
    public function getFormattedPostalAddressDescription()
    {
        return $this->FormattedPostalAddressDescription;
    }
    /**
     * Set FormattedPostalAddressDescription value
     * @param string $formattedPostalAddressDescription
     * @return \StructType\CustomerReponseCustomerFormattedAddress
     */
    public function setFormattedPostalAddressDescription($formattedPostalAddressDescription = null)
    {
        // validation for constraint: string
        if (!is_null($formattedPostalAddressDescription) && !is_string($formattedPostalAddressDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formattedPostalAddressDescription, true), gettype($formattedPostalAddressDescription)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($formattedPostalAddressDescription) && mb_strlen($formattedPostalAddressDescription) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($formattedPostalAddressDescription)), __LINE__);
        }
        $this->FormattedPostalAddressDescription = $formattedPostalAddressDescription;
        return $this;
    }
    /**
     * Get FormattedAddress value
     * @return \StructType\FormattedAddress|null
     */
    public function getFormattedAddress()
    {
        return $this->FormattedAddress;
    }
    /**
     * Set FormattedAddress value
     * @param \StructType\FormattedAddress $formattedAddress
     * @return \StructType\CustomerReponseCustomerFormattedAddress
     */
    public function setFormattedAddress(\StructType\FormattedAddress $formattedAddress = null)
    {
        $this->FormattedAddress = $formattedAddress;
        return $this;
    }
    /**
     * Get FormattedPostalAddress value
     * @return \StructType\FormattedPostalAddress|null
     */
    public function getFormattedPostalAddress()
    {
        return $this->FormattedPostalAddress;
    }
    /**
     * Set FormattedPostalAddress value
     * @param \StructType\FormattedPostalAddress $formattedPostalAddress
     * @return \StructType\CustomerReponseCustomerFormattedAddress
     */
    public function setFormattedPostalAddress(\StructType\FormattedPostalAddress $formattedPostalAddress = null)
    {
        $this->FormattedPostalAddress = $formattedPostalAddress;
        return $this;
    }
}
