<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommunicationMediumTypeCode StructType
 * Meta information extracted from the WSDL
 * - documentation: Code
 * - base: xsd:token
 * - maxLength: 3
 * - minLength: 1
 * @subpackage Structs
 */
class CommunicationMediumTypeCode extends AbstractStructBase
{
    /**
     * The _
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 1
     * @var string
     */
    public $_;
    /**
     * The listID
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $listID;
    /**
     * The listVersionID
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 15
     * - minLength: 1
     * @var string
     */
    public $listVersionID;
    /**
     * The listAgencyID
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $listAgencyID;
    /**
     * Constructor method for CommunicationMediumTypeCode
     * @uses CommunicationMediumTypeCode::set_()
     * @uses CommunicationMediumTypeCode::setListID()
     * @uses CommunicationMediumTypeCode::setListVersionID()
     * @uses CommunicationMediumTypeCode::setListAgencyID()
     * @param string $_
     * @param string $listID
     * @param string $listVersionID
     * @param string $listAgencyID
     */
    public function __construct($_ = null, $listID = null, $listVersionID = null, $listAgencyID = null)
    {
        $this
            ->set_($_)
            ->setListID($listID)
            ->setListVersionID($listVersionID)
            ->setListAgencyID($listAgencyID);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\CommunicationMediumTypeCode
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($_) && mb_strlen($_) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($_)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($_) && mb_strlen($_) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get listID value
     * @return string|null
     */
    public function getListID()
    {
        return $this->listID;
    }
    /**
     * Set listID value
     * @param string $listID
     * @return \StructType\CommunicationMediumTypeCode
     */
    public function setListID($listID = null)
    {
        // validation for constraint: string
        if (!is_null($listID) && !is_string($listID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($listID, true), gettype($listID)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($listID) && mb_strlen($listID) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($listID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($listID) && mb_strlen($listID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($listID)), __LINE__);
        }
        $this->listID = $listID;
        return $this;
    }
    /**
     * Get listVersionID value
     * @return string|null
     */
    public function getListVersionID()
    {
        return $this->listVersionID;
    }
    /**
     * Set listVersionID value
     * @param string $listVersionID
     * @return \StructType\CommunicationMediumTypeCode
     */
    public function setListVersionID($listVersionID = null)
    {
        // validation for constraint: string
        if (!is_null($listVersionID) && !is_string($listVersionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($listVersionID, true), gettype($listVersionID)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($listVersionID) && mb_strlen($listVersionID) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($listVersionID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($listVersionID) && mb_strlen($listVersionID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($listVersionID)), __LINE__);
        }
        $this->listVersionID = $listVersionID;
        return $this;
    }
    /**
     * Get listAgencyID value
     * @return string|null
     */
    public function getListAgencyID()
    {
        return $this->listAgencyID;
    }
    /**
     * Set listAgencyID value
     * @param string $listAgencyID
     * @return \StructType\CommunicationMediumTypeCode
     */
    public function setListAgencyID($listAgencyID = null)
    {
        // validation for constraint: string
        if (!is_null($listAgencyID) && !is_string($listAgencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($listAgencyID, true), gettype($listAgencyID)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($listAgencyID) && mb_strlen($listAgencyID) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($listAgencyID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($listAgencyID) && mb_strlen($listAgencyID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($listAgencyID)), __LINE__);
        }
        $this->listAgencyID = $listAgencyID;
        return $this;
    }
}
