<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxExemptionCertificateID StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifier
 * - base: xsd:token
 * - maxLength: 30
 * - minLength: 1
 * @subpackage Structs
 */
class TaxExemptionCertificateID extends AbstractStructBase
{
    /**
     * The _
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 30
     * - minLength: 1
     * @var string
     */
    public $_;
    /**
     * The schemeAgencyID
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $schemeAgencyID;
    /**
     * Constructor method for TaxExemptionCertificateID
     * @uses TaxExemptionCertificateID::set_()
     * @uses TaxExemptionCertificateID::setSchemeAgencyID()
     * @param string $_
     * @param string $schemeAgencyID
     */
    public function __construct($_ = null, $schemeAgencyID = null)
    {
        $this
            ->set_($_)
            ->setSchemeAgencyID($schemeAgencyID);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\TaxExemptionCertificateID
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($_) && mb_strlen($_) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($_)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($_) && mb_strlen($_) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get schemeAgencyID value
     * @return string|null
     */
    public function getSchemeAgencyID()
    {
        return $this->schemeAgencyID;
    }
    /**
     * Set schemeAgencyID value
     * @param string $schemeAgencyID
     * @return \StructType\TaxExemptionCertificateID
     */
    public function setSchemeAgencyID($schemeAgencyID = null)
    {
        // validation for constraint: string
        if (!is_null($schemeAgencyID) && !is_string($schemeAgencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeAgencyID, true), gettype($schemeAgencyID)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($schemeAgencyID) && mb_strlen($schemeAgencyID) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($schemeAgencyID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($schemeAgencyID) && mb_strlen($schemeAgencyID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($schemeAgencyID)), __LINE__);
        }
        $this->schemeAgencyID = $schemeAgencyID;
        return $this;
    }
}
