<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SystemAdministrativeData StructType
 * @subpackage Structs
 */
class SystemAdministrativeData extends AbstractStructBase
{
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - documentation: DateTime
     * - base: xsd:dateTime
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z
     * @var string
     */
    public $CreationDateTime;
    /**
     * The CreationIdentityUUID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UUID
     */
    public $CreationIdentityUUID;
    /**
     * The LastChangeDateTime
     * Meta information extracted from the WSDL
     * - documentation: DateTime
     * - base: xsd:dateTime
     * - minOccurs: 0
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z
     * @var string
     */
    public $LastChangeDateTime;
    /**
     * The LastChangeIdentityUUID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UUID
     */
    public $LastChangeIdentityUUID;
    /**
     * Constructor method for SystemAdministrativeData
     * @uses SystemAdministrativeData::setCreationDateTime()
     * @uses SystemAdministrativeData::setCreationIdentityUUID()
     * @uses SystemAdministrativeData::setLastChangeDateTime()
     * @uses SystemAdministrativeData::setLastChangeIdentityUUID()
     * @param string $creationDateTime
     * @param \StructType\UUID $creationIdentityUUID
     * @param string $lastChangeDateTime
     * @param \StructType\UUID $lastChangeIdentityUUID
     */
    public function __construct($creationDateTime = null, \StructType\UUID $creationIdentityUUID = null, $lastChangeDateTime = null, \StructType\UUID $lastChangeIdentityUUID = null)
    {
        $this
            ->setCreationDateTime($creationDateTime)
            ->setCreationIdentityUUID($creationIdentityUUID)
            ->setLastChangeDateTime($lastChangeDateTime)
            ->setLastChangeIdentityUUID($lastChangeIdentityUUID);
    }
    /**
     * Get CreationDateTime value
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return $this->CreationDateTime;
    }
    /**
     * Set CreationDateTime value
     * @param string $creationDateTime
     * @return \StructType\SystemAdministrativeData
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z)
        if (!is_null($creationDateTime) && !preg_match('/[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z/', $creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z', var_export($creationDateTime, true)), __LINE__);
        }
        $this->CreationDateTime = $creationDateTime;
        return $this;
    }
    /**
     * Get CreationIdentityUUID value
     * @return \StructType\UUID|null
     */
    public function getCreationIdentityUUID()
    {
        return $this->CreationIdentityUUID;
    }
    /**
     * Set CreationIdentityUUID value
     * @param \StructType\UUID $creationIdentityUUID
     * @return \StructType\SystemAdministrativeData
     */
    public function setCreationIdentityUUID(\StructType\UUID $creationIdentityUUID = null)
    {
        $this->CreationIdentityUUID = $creationIdentityUUID;
        return $this;
    }
    /**
     * Get LastChangeDateTime value
     * @return string|null
     */
    public function getLastChangeDateTime()
    {
        return $this->LastChangeDateTime;
    }
    /**
     * Set LastChangeDateTime value
     * @param string $lastChangeDateTime
     * @return \StructType\SystemAdministrativeData
     */
    public function setLastChangeDateTime($lastChangeDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastChangeDateTime) && !is_string($lastChangeDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastChangeDateTime, true), gettype($lastChangeDateTime)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z)
        if (!is_null($lastChangeDateTime) && !preg_match('/[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z/', $lastChangeDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z', var_export($lastChangeDateTime, true)), __LINE__);
        }
        $this->LastChangeDateTime = $lastChangeDateTime;
        return $this;
    }
    /**
     * Get LastChangeIdentityUUID value
     * @return \StructType\UUID|null
     */
    public function getLastChangeIdentityUUID()
    {
        return $this->LastChangeIdentityUUID;
    }
    /**
     * Set LastChangeIdentityUUID value
     * @param \StructType\UUID $lastChangeIdentityUUID
     * @return \StructType\SystemAdministrativeData
     */
    public function setLastChangeIdentityUUID(\StructType\UUID $lastChangeIdentityUUID = null)
    {
        $this->LastChangeIdentityUUID = $lastChangeIdentityUUID;
        return $this;
    }
}
