<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SelectionByCode StructType
 * @subpackage Structs
 */
class SelectionByCode extends AbstractStructBase
{
    /**
     * The InclusionExclusionCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $InclusionExclusionCode;
    /**
     * The IntervalBoundaryTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * @var string
     */
    public $IntervalBoundaryTypeCode;
    /**
     * The LowerBoundaryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Code
     */
    public $LowerBoundaryCode;
    /**
     * The UpperBoundaryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Code
     */
    public $UpperBoundaryCode;
    /**
     * Constructor method for SelectionByCode
     * @uses SelectionByCode::setInclusionExclusionCode()
     * @uses SelectionByCode::setIntervalBoundaryTypeCode()
     * @uses SelectionByCode::setLowerBoundaryCode()
     * @uses SelectionByCode::setUpperBoundaryCode()
     * @param string $inclusionExclusionCode
     * @param string $intervalBoundaryTypeCode
     * @param \StructType\Code $lowerBoundaryCode
     * @param \StructType\Code $upperBoundaryCode
     */
    public function __construct($inclusionExclusionCode = null, $intervalBoundaryTypeCode = null, \StructType\Code $lowerBoundaryCode = null, \StructType\Code $upperBoundaryCode = null)
    {
        $this
            ->setInclusionExclusionCode($inclusionExclusionCode)
            ->setIntervalBoundaryTypeCode($intervalBoundaryTypeCode)
            ->setLowerBoundaryCode($lowerBoundaryCode)
            ->setUpperBoundaryCode($upperBoundaryCode);
    }
    /**
     * Get InclusionExclusionCode value
     * @return string|null
     */
    public function getInclusionExclusionCode()
    {
        return $this->InclusionExclusionCode;
    }
    /**
     * Set InclusionExclusionCode value
     * @param string $inclusionExclusionCode
     * @return \StructType\SelectionByCode
     */
    public function setInclusionExclusionCode($inclusionExclusionCode = null)
    {
        // validation for constraint: string
        if (!is_null($inclusionExclusionCode) && !is_string($inclusionExclusionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inclusionExclusionCode, true), gettype($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        $this->InclusionExclusionCode = $inclusionExclusionCode;
        return $this;
    }
    /**
     * Get IntervalBoundaryTypeCode value
     * @return string|null
     */
    public function getIntervalBoundaryTypeCode()
    {
        return $this->IntervalBoundaryTypeCode;
    }
    /**
     * Set IntervalBoundaryTypeCode value
     * @param string $intervalBoundaryTypeCode
     * @return \StructType\SelectionByCode
     */
    public function setIntervalBoundaryTypeCode($intervalBoundaryTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($intervalBoundaryTypeCode) && !is_string($intervalBoundaryTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intervalBoundaryTypeCode, true), gettype($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        $this->IntervalBoundaryTypeCode = $intervalBoundaryTypeCode;
        return $this;
    }
    /**
     * Get LowerBoundaryCode value
     * @return \StructType\Code|null
     */
    public function getLowerBoundaryCode()
    {
        return $this->LowerBoundaryCode;
    }
    /**
     * Set LowerBoundaryCode value
     * @param \StructType\Code $lowerBoundaryCode
     * @return \StructType\SelectionByCode
     */
    public function setLowerBoundaryCode(\StructType\Code $lowerBoundaryCode = null)
    {
        $this->LowerBoundaryCode = $lowerBoundaryCode;
        return $this;
    }
    /**
     * Get UpperBoundaryCode value
     * @return \StructType\Code|null
     */
    public function getUpperBoundaryCode()
    {
        return $this->UpperBoundaryCode;
    }
    /**
     * Set UpperBoundaryCode value
     * @param \StructType\Code $upperBoundaryCode
     * @return \StructType\SelectionByCode
     */
    public function setUpperBoundaryCode(\StructType\Code $upperBoundaryCode = null)
    {
        $this->UpperBoundaryCode = $upperBoundaryCode;
        return $this;
    }
}
