<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartyTaxID StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifier
 * - base: xsd:token
 * - maxLength: 20
 * - minLength: 1
 * @subpackage Structs
 */
class PartyTaxID extends AbstractStructBase
{
    /**
     * The schemeID
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 60
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $schemeID;
    /**
     * The _
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $_;
    /**
     * Constructor method for PartyTaxID
     * @uses PartyTaxID::setSchemeID()
     * @uses PartyTaxID::set_()
     * @param string $schemeID
     * @param string $_
     */
    public function __construct($schemeID = null, $_ = null)
    {
        $this
            ->setSchemeID($schemeID)
            ->set_($_);
    }
    /**
     * Get schemeID value
     * @return string
     */
    public function getSchemeID()
    {
        return $this->schemeID;
    }
    /**
     * Set schemeID value
     * @param string $schemeID
     * @return \StructType\PartyTaxID
     */
    public function setSchemeID($schemeID = null)
    {
        // validation for constraint: string
        if (!is_null($schemeID) && !is_string($schemeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeID, true), gettype($schemeID)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($schemeID) && mb_strlen($schemeID) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($schemeID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($schemeID) && mb_strlen($schemeID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($schemeID)), __LINE__);
        }
        $this->schemeID = $schemeID;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\PartyTaxID
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($_) && mb_strlen($_) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($_)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($_) && mb_strlen($_) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
}
