<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObjectID StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifier
 * - base: xsd:token
 * - maxLength: 100
 * - minLength: 1
 * @subpackage Structs
 */
class ObjectID extends AbstractStructBase
{
    /**
     * The _
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $_;
    /**
     * The schemeID
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $schemeID;
    /**
     * The schemeVersionID
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 15
     * - minLength: 1
     * @var string
     */
    public $schemeVersionID;
    /**
     * The schemeAgencyID
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $schemeAgencyID;
    /**
     * The schemeAgencySchemeID
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $schemeAgencySchemeID;
    /**
     * The schemeAgencySchemeAgencyID
     * @var string
     */
    public $schemeAgencySchemeAgencyID;
    /**
     * Constructor method for ObjectID
     * @uses ObjectID::set_()
     * @uses ObjectID::setSchemeID()
     * @uses ObjectID::setSchemeVersionID()
     * @uses ObjectID::setSchemeAgencyID()
     * @uses ObjectID::setSchemeAgencySchemeID()
     * @uses ObjectID::setSchemeAgencySchemeAgencyID()
     * @param string $_
     * @param string $schemeID
     * @param string $schemeVersionID
     * @param string $schemeAgencyID
     * @param string $schemeAgencySchemeID
     * @param string $schemeAgencySchemeAgencyID
     */
    public function __construct($_ = null, $schemeID = null, $schemeVersionID = null, $schemeAgencyID = null, $schemeAgencySchemeID = null, $schemeAgencySchemeAgencyID = null)
    {
        $this
            ->set_($_)
            ->setSchemeID($schemeID)
            ->setSchemeVersionID($schemeVersionID)
            ->setSchemeAgencyID($schemeAgencyID)
            ->setSchemeAgencySchemeID($schemeAgencySchemeID)
            ->setSchemeAgencySchemeAgencyID($schemeAgencySchemeAgencyID);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\ObjectID
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($_) && mb_strlen($_) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($_)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($_) && mb_strlen($_) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get schemeID value
     * @return string|null
     */
    public function getSchemeID()
    {
        return $this->schemeID;
    }
    /**
     * Set schemeID value
     * @param string $schemeID
     * @return \StructType\ObjectID
     */
    public function setSchemeID($schemeID = null)
    {
        // validation for constraint: string
        if (!is_null($schemeID) && !is_string($schemeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeID, true), gettype($schemeID)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($schemeID) && mb_strlen($schemeID) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($schemeID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($schemeID) && mb_strlen($schemeID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($schemeID)), __LINE__);
        }
        $this->schemeID = $schemeID;
        return $this;
    }
    /**
     * Get schemeVersionID value
     * @return string|null
     */
    public function getSchemeVersionID()
    {
        return $this->schemeVersionID;
    }
    /**
     * Set schemeVersionID value
     * @param string $schemeVersionID
     * @return \StructType\ObjectID
     */
    public function setSchemeVersionID($schemeVersionID = null)
    {
        // validation for constraint: string
        if (!is_null($schemeVersionID) && !is_string($schemeVersionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeVersionID, true), gettype($schemeVersionID)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($schemeVersionID) && mb_strlen($schemeVersionID) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($schemeVersionID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($schemeVersionID) && mb_strlen($schemeVersionID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($schemeVersionID)), __LINE__);
        }
        $this->schemeVersionID = $schemeVersionID;
        return $this;
    }
    /**
     * Get schemeAgencyID value
     * @return string|null
     */
    public function getSchemeAgencyID()
    {
        return $this->schemeAgencyID;
    }
    /**
     * Set schemeAgencyID value
     * @param string $schemeAgencyID
     * @return \StructType\ObjectID
     */
    public function setSchemeAgencyID($schemeAgencyID = null)
    {
        // validation for constraint: string
        if (!is_null($schemeAgencyID) && !is_string($schemeAgencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeAgencyID, true), gettype($schemeAgencyID)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($schemeAgencyID) && mb_strlen($schemeAgencyID) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($schemeAgencyID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($schemeAgencyID) && mb_strlen($schemeAgencyID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($schemeAgencyID)), __LINE__);
        }
        $this->schemeAgencyID = $schemeAgencyID;
        return $this;
    }
    /**
     * Get schemeAgencySchemeID value
     * @return string|null
     */
    public function getSchemeAgencySchemeID()
    {
        return $this->schemeAgencySchemeID;
    }
    /**
     * Set schemeAgencySchemeID value
     * @param string $schemeAgencySchemeID
     * @return \StructType\ObjectID
     */
    public function setSchemeAgencySchemeID($schemeAgencySchemeID = null)
    {
        // validation for constraint: string
        if (!is_null($schemeAgencySchemeID) && !is_string($schemeAgencySchemeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeAgencySchemeID, true), gettype($schemeAgencySchemeID)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($schemeAgencySchemeID) && mb_strlen($schemeAgencySchemeID) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($schemeAgencySchemeID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($schemeAgencySchemeID) && mb_strlen($schemeAgencySchemeID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($schemeAgencySchemeID)), __LINE__);
        }
        $this->schemeAgencySchemeID = $schemeAgencySchemeID;
        return $this;
    }
    /**
     * Get schemeAgencySchemeAgencyID value
     * @return string|null
     */
    public function getSchemeAgencySchemeAgencyID()
    {
        return $this->schemeAgencySchemeAgencyID;
    }
    /**
     * Set schemeAgencySchemeAgencyID value
     * @uses \EnumType\AgencyIdentificationCode::valueIsValid()
     * @uses \EnumType\AgencyIdentificationCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $schemeAgencySchemeAgencyID
     * @return \StructType\ObjectID
     */
    public function setSchemeAgencySchemeAgencyID($schemeAgencySchemeAgencyID = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AgencyIdentificationCode::valueIsValid($schemeAgencySchemeAgencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AgencyIdentificationCode', is_array($schemeAgencySchemeAgencyID) ? implode(', ', $schemeAgencySchemeAgencyID) : var_export($schemeAgencySchemeAgencyID, true), implode(', ', \EnumType\AgencyIdentificationCode::getValidValues())), __LINE__);
        }
        $this->schemeAgencySchemeAgencyID = $schemeAgencySchemeAgencyID;
        return $this;
    }
}
