<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Log StructType
 * @subpackage Structs
 */
class Log extends AbstractStructBase
{
    /**
     * The BusinessDocumentProcessingResultCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 2
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $BusinessDocumentProcessingResultCode;
    /**
     * The MaximumLogItemSeverityCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $MaximumLogItemSeverityCode;
    /**
     * The Item
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LogItem[]
     */
    public $Item;
    /**
     * Constructor method for Log
     * @uses Log::setBusinessDocumentProcessingResultCode()
     * @uses Log::setMaximumLogItemSeverityCode()
     * @uses Log::setItem()
     * @param string $businessDocumentProcessingResultCode
     * @param string $maximumLogItemSeverityCode
     * @param \StructType\LogItem[] $item
     */
    public function __construct($businessDocumentProcessingResultCode = null, $maximumLogItemSeverityCode = null, array $item = array())
    {
        $this
            ->setBusinessDocumentProcessingResultCode($businessDocumentProcessingResultCode)
            ->setMaximumLogItemSeverityCode($maximumLogItemSeverityCode)
            ->setItem($item);
    }
    /**
     * Get BusinessDocumentProcessingResultCode value
     * @return string|null
     */
    public function getBusinessDocumentProcessingResultCode()
    {
        return $this->BusinessDocumentProcessingResultCode;
    }
    /**
     * Set BusinessDocumentProcessingResultCode value
     * @param string $businessDocumentProcessingResultCode
     * @return \StructType\Log
     */
    public function setBusinessDocumentProcessingResultCode($businessDocumentProcessingResultCode = null)
    {
        // validation for constraint: string
        if (!is_null($businessDocumentProcessingResultCode) && !is_string($businessDocumentProcessingResultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessDocumentProcessingResultCode, true), gettype($businessDocumentProcessingResultCode)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($businessDocumentProcessingResultCode) && mb_strlen($businessDocumentProcessingResultCode) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($businessDocumentProcessingResultCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($businessDocumentProcessingResultCode) && mb_strlen($businessDocumentProcessingResultCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($businessDocumentProcessingResultCode)), __LINE__);
        }
        $this->BusinessDocumentProcessingResultCode = $businessDocumentProcessingResultCode;
        return $this;
    }
    /**
     * Get MaximumLogItemSeverityCode value
     * @return string|null
     */
    public function getMaximumLogItemSeverityCode()
    {
        return $this->MaximumLogItemSeverityCode;
    }
    /**
     * Set MaximumLogItemSeverityCode value
     * @param string $maximumLogItemSeverityCode
     * @return \StructType\Log
     */
    public function setMaximumLogItemSeverityCode($maximumLogItemSeverityCode = null)
    {
        // validation for constraint: string
        if (!is_null($maximumLogItemSeverityCode) && !is_string($maximumLogItemSeverityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maximumLogItemSeverityCode, true), gettype($maximumLogItemSeverityCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($maximumLogItemSeverityCode) && mb_strlen($maximumLogItemSeverityCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($maximumLogItemSeverityCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($maximumLogItemSeverityCode) && mb_strlen($maximumLogItemSeverityCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($maximumLogItemSeverityCode)), __LINE__);
        }
        $this->MaximumLogItemSeverityCode = $maximumLogItemSeverityCode;
        return $this;
    }
    /**
     * Get Item value
     * @return \StructType\LogItem[]|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * This method is responsible for validating the values passed to the setItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemForArrayConstraintsFromSetItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $logItemItem) {
            // validation for constraint: itemType
            if (!$logItemItem instanceof \StructType\LogItem) {
                $invalidValues[] = is_object($logItemItem) ? get_class($logItemItem) : sprintf('%s(%s)', gettype($logItemItem), var_export($logItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item property can only contain items of type \StructType\LogItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item value
     * @throws \InvalidArgumentException
     * @param \StructType\LogItem[] $item
     * @return \StructType\Log
     */
    public function setItem(array $item = array())
    {
        // validation for constraint: array
        if ('' !== ($itemArrayErrorMessage = self::validateItemForArrayConstraintsFromSetItem($item))) {
            throw new \InvalidArgumentException($itemArrayErrorMessage, __LINE__);
        }
        $this->Item = $item;
        return $this;
    }
    /**
     * Add item to Item value
     * @throws \InvalidArgumentException
     * @param \StructType\LogItem $item
     * @return \StructType\Log
     */
    public function addToItem(\StructType\LogItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LogItem) {
            throw new \InvalidArgumentException(sprintf('The Item property can only contain items of type \StructType\LogItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item[] = $item;
        return $this;
    }
}
