<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Incoterms StructType
 * @subpackage Structs
 */
class Incoterms extends AbstractStructBase
{
    /**
     * The ClassificationCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 1
     * @var string
     */
    public $ClassificationCode;
    /**
     * The TransferLocationName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 28
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransferLocationName;
    /**
     * Constructor method for Incoterms
     * @uses Incoterms::setClassificationCode()
     * @uses Incoterms::setTransferLocationName()
     * @param string $classificationCode
     * @param string $transferLocationName
     */
    public function __construct($classificationCode = null, $transferLocationName = null)
    {
        $this
            ->setClassificationCode($classificationCode)
            ->setTransferLocationName($transferLocationName);
    }
    /**
     * Get ClassificationCode value
     * @return string|null
     */
    public function getClassificationCode()
    {
        return $this->ClassificationCode;
    }
    /**
     * Set ClassificationCode value
     * @param string $classificationCode
     * @return \StructType\Incoterms
     */
    public function setClassificationCode($classificationCode = null)
    {
        // validation for constraint: string
        if (!is_null($classificationCode) && !is_string($classificationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classificationCode, true), gettype($classificationCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($classificationCode) && mb_strlen($classificationCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($classificationCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($classificationCode) && mb_strlen($classificationCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($classificationCode)), __LINE__);
        }
        $this->ClassificationCode = $classificationCode;
        return $this;
    }
    /**
     * Get TransferLocationName value
     * @return string|null
     */
    public function getTransferLocationName()
    {
        return $this->TransferLocationName;
    }
    /**
     * Set TransferLocationName value
     * @param string $transferLocationName
     * @return \StructType\Incoterms
     */
    public function setTransferLocationName($transferLocationName = null)
    {
        // validation for constraint: string
        if (!is_null($transferLocationName) && !is_string($transferLocationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transferLocationName, true), gettype($transferLocationName)), __LINE__);
        }
        // validation for constraint: maxLength(28)
        if (!is_null($transferLocationName) && mb_strlen($transferLocationName) > 28) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 28', mb_strlen($transferLocationName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($transferLocationName) && mb_strlen($transferLocationName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($transferLocationName)), __LINE__);
        }
        $this->TransferLocationName = $transferLocationName;
        return $this;
    }
}
