<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerSelectionByStreetPostalCode StructType
 * @subpackage Structs
 */
class CustomerSelectionByStreetPostalCode extends AbstractStructBase
{
    /**
     * The InclusionExclusionCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $InclusionExclusionCode;
    /**
     * The IntervalBoundaryTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntervalBoundaryTypeCode;
    /**
     * The LowerBoundaryStreetPostalCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 10
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $LowerBoundaryStreetPostalCode;
    /**
     * The UpperBoundaryStreetPostalCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 10
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $UpperBoundaryStreetPostalCode;
    /**
     * Constructor method for CustomerSelectionByStreetPostalCode
     * @uses CustomerSelectionByStreetPostalCode::setInclusionExclusionCode()
     * @uses CustomerSelectionByStreetPostalCode::setIntervalBoundaryTypeCode()
     * @uses CustomerSelectionByStreetPostalCode::setLowerBoundaryStreetPostalCode()
     * @uses CustomerSelectionByStreetPostalCode::setUpperBoundaryStreetPostalCode()
     * @param string $inclusionExclusionCode
     * @param string $intervalBoundaryTypeCode
     * @param string $lowerBoundaryStreetPostalCode
     * @param string $upperBoundaryStreetPostalCode
     */
    public function __construct($inclusionExclusionCode = null, $intervalBoundaryTypeCode = null, $lowerBoundaryStreetPostalCode = null, $upperBoundaryStreetPostalCode = null)
    {
        $this
            ->setInclusionExclusionCode($inclusionExclusionCode)
            ->setIntervalBoundaryTypeCode($intervalBoundaryTypeCode)
            ->setLowerBoundaryStreetPostalCode($lowerBoundaryStreetPostalCode)
            ->setUpperBoundaryStreetPostalCode($upperBoundaryStreetPostalCode);
    }
    /**
     * Get InclusionExclusionCode value
     * @return string|null
     */
    public function getInclusionExclusionCode()
    {
        return $this->InclusionExclusionCode;
    }
    /**
     * Set InclusionExclusionCode value
     * @param string $inclusionExclusionCode
     * @return \StructType\CustomerSelectionByStreetPostalCode
     */
    public function setInclusionExclusionCode($inclusionExclusionCode = null)
    {
        // validation for constraint: string
        if (!is_null($inclusionExclusionCode) && !is_string($inclusionExclusionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inclusionExclusionCode, true), gettype($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        $this->InclusionExclusionCode = $inclusionExclusionCode;
        return $this;
    }
    /**
     * Get IntervalBoundaryTypeCode value
     * @return string|null
     */
    public function getIntervalBoundaryTypeCode()
    {
        return $this->IntervalBoundaryTypeCode;
    }
    /**
     * Set IntervalBoundaryTypeCode value
     * @param string $intervalBoundaryTypeCode
     * @return \StructType\CustomerSelectionByStreetPostalCode
     */
    public function setIntervalBoundaryTypeCode($intervalBoundaryTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($intervalBoundaryTypeCode) && !is_string($intervalBoundaryTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intervalBoundaryTypeCode, true), gettype($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        $this->IntervalBoundaryTypeCode = $intervalBoundaryTypeCode;
        return $this;
    }
    /**
     * Get LowerBoundaryStreetPostalCode value
     * @return string|null
     */
    public function getLowerBoundaryStreetPostalCode()
    {
        return $this->LowerBoundaryStreetPostalCode;
    }
    /**
     * Set LowerBoundaryStreetPostalCode value
     * @param string $lowerBoundaryStreetPostalCode
     * @return \StructType\CustomerSelectionByStreetPostalCode
     */
    public function setLowerBoundaryStreetPostalCode($lowerBoundaryStreetPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($lowerBoundaryStreetPostalCode) && !is_string($lowerBoundaryStreetPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lowerBoundaryStreetPostalCode, true), gettype($lowerBoundaryStreetPostalCode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($lowerBoundaryStreetPostalCode) && mb_strlen($lowerBoundaryStreetPostalCode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($lowerBoundaryStreetPostalCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($lowerBoundaryStreetPostalCode) && mb_strlen($lowerBoundaryStreetPostalCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($lowerBoundaryStreetPostalCode)), __LINE__);
        }
        $this->LowerBoundaryStreetPostalCode = $lowerBoundaryStreetPostalCode;
        return $this;
    }
    /**
     * Get UpperBoundaryStreetPostalCode value
     * @return string|null
     */
    public function getUpperBoundaryStreetPostalCode()
    {
        return $this->UpperBoundaryStreetPostalCode;
    }
    /**
     * Set UpperBoundaryStreetPostalCode value
     * @param string $upperBoundaryStreetPostalCode
     * @return \StructType\CustomerSelectionByStreetPostalCode
     */
    public function setUpperBoundaryStreetPostalCode($upperBoundaryStreetPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($upperBoundaryStreetPostalCode) && !is_string($upperBoundaryStreetPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upperBoundaryStreetPostalCode, true), gettype($upperBoundaryStreetPostalCode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($upperBoundaryStreetPostalCode) && mb_strlen($upperBoundaryStreetPostalCode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($upperBoundaryStreetPostalCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($upperBoundaryStreetPostalCode) && mb_strlen($upperBoundaryStreetPostalCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($upperBoundaryStreetPostalCode)), __LINE__);
        }
        $this->UpperBoundaryStreetPostalCode = $upperBoundaryStreetPostalCode;
        return $this;
    }
}
