<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerSelectionByNormalisedTelephoneNumber StructType
 * @subpackage Structs
 */
class CustomerSelectionByNormalisedTelephoneNumber extends AbstractStructBase
{
    /**
     * The InclusionExclusionCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $InclusionExclusionCode;
    /**
     * The IntervalBoundaryTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntervalBoundaryTypeCode;
    /**
     * The LowerBoundaryNormalisedTelephoneNumber
     * Meta information extracted from the WSDL
     * - documentation: Description
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $LowerBoundaryNormalisedTelephoneNumber;
    /**
     * The UpperBoundaryNormalisedTelephoneNumber
     * Meta information extracted from the WSDL
     * - documentation: Description
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $UpperBoundaryNormalisedTelephoneNumber;
    /**
     * Constructor method for CustomerSelectionByNormalisedTelephoneNumber
     * @uses CustomerSelectionByNormalisedTelephoneNumber::setInclusionExclusionCode()
     * @uses CustomerSelectionByNormalisedTelephoneNumber::setIntervalBoundaryTypeCode()
     * @uses CustomerSelectionByNormalisedTelephoneNumber::setLowerBoundaryNormalisedTelephoneNumber()
     * @uses CustomerSelectionByNormalisedTelephoneNumber::setUpperBoundaryNormalisedTelephoneNumber()
     * @param string $inclusionExclusionCode
     * @param string $intervalBoundaryTypeCode
     * @param string $lowerBoundaryNormalisedTelephoneNumber
     * @param string $upperBoundaryNormalisedTelephoneNumber
     */
    public function __construct($inclusionExclusionCode = null, $intervalBoundaryTypeCode = null, $lowerBoundaryNormalisedTelephoneNumber = null, $upperBoundaryNormalisedTelephoneNumber = null)
    {
        $this
            ->setInclusionExclusionCode($inclusionExclusionCode)
            ->setIntervalBoundaryTypeCode($intervalBoundaryTypeCode)
            ->setLowerBoundaryNormalisedTelephoneNumber($lowerBoundaryNormalisedTelephoneNumber)
            ->setUpperBoundaryNormalisedTelephoneNumber($upperBoundaryNormalisedTelephoneNumber);
    }
    /**
     * Get InclusionExclusionCode value
     * @return string|null
     */
    public function getInclusionExclusionCode()
    {
        return $this->InclusionExclusionCode;
    }
    /**
     * Set InclusionExclusionCode value
     * @param string $inclusionExclusionCode
     * @return \StructType\CustomerSelectionByNormalisedTelephoneNumber
     */
    public function setInclusionExclusionCode($inclusionExclusionCode = null)
    {
        // validation for constraint: string
        if (!is_null($inclusionExclusionCode) && !is_string($inclusionExclusionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inclusionExclusionCode, true), gettype($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        $this->InclusionExclusionCode = $inclusionExclusionCode;
        return $this;
    }
    /**
     * Get IntervalBoundaryTypeCode value
     * @return string|null
     */
    public function getIntervalBoundaryTypeCode()
    {
        return $this->IntervalBoundaryTypeCode;
    }
    /**
     * Set IntervalBoundaryTypeCode value
     * @param string $intervalBoundaryTypeCode
     * @return \StructType\CustomerSelectionByNormalisedTelephoneNumber
     */
    public function setIntervalBoundaryTypeCode($intervalBoundaryTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($intervalBoundaryTypeCode) && !is_string($intervalBoundaryTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intervalBoundaryTypeCode, true), gettype($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        $this->IntervalBoundaryTypeCode = $intervalBoundaryTypeCode;
        return $this;
    }
    /**
     * Get LowerBoundaryNormalisedTelephoneNumber value
     * @return string|null
     */
    public function getLowerBoundaryNormalisedTelephoneNumber()
    {
        return $this->LowerBoundaryNormalisedTelephoneNumber;
    }
    /**
     * Set LowerBoundaryNormalisedTelephoneNumber value
     * @param string $lowerBoundaryNormalisedTelephoneNumber
     * @return \StructType\CustomerSelectionByNormalisedTelephoneNumber
     */
    public function setLowerBoundaryNormalisedTelephoneNumber($lowerBoundaryNormalisedTelephoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($lowerBoundaryNormalisedTelephoneNumber) && !is_string($lowerBoundaryNormalisedTelephoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lowerBoundaryNormalisedTelephoneNumber, true), gettype($lowerBoundaryNormalisedTelephoneNumber)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($lowerBoundaryNormalisedTelephoneNumber) && mb_strlen($lowerBoundaryNormalisedTelephoneNumber) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($lowerBoundaryNormalisedTelephoneNumber)), __LINE__);
        }
        $this->LowerBoundaryNormalisedTelephoneNumber = $lowerBoundaryNormalisedTelephoneNumber;
        return $this;
    }
    /**
     * Get UpperBoundaryNormalisedTelephoneNumber value
     * @return string|null
     */
    public function getUpperBoundaryNormalisedTelephoneNumber()
    {
        return $this->UpperBoundaryNormalisedTelephoneNumber;
    }
    /**
     * Set UpperBoundaryNormalisedTelephoneNumber value
     * @param string $upperBoundaryNormalisedTelephoneNumber
     * @return \StructType\CustomerSelectionByNormalisedTelephoneNumber
     */
    public function setUpperBoundaryNormalisedTelephoneNumber($upperBoundaryNormalisedTelephoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($upperBoundaryNormalisedTelephoneNumber) && !is_string($upperBoundaryNormalisedTelephoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upperBoundaryNormalisedTelephoneNumber, true), gettype($upperBoundaryNormalisedTelephoneNumber)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($upperBoundaryNormalisedTelephoneNumber) && mb_strlen($upperBoundaryNormalisedTelephoneNumber) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($upperBoundaryNormalisedTelephoneNumber)), __LINE__);
        }
        $this->UpperBoundaryNormalisedTelephoneNumber = $upperBoundaryNormalisedTelephoneNumber;
        return $this;
    }
}
