<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerSelectionByInternalID StructType
 * @subpackage Structs
 */
class CustomerSelectionByInternalID extends AbstractStructBase
{
    /**
     * The InclusionExclusionCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $InclusionExclusionCode;
    /**
     * The IntervalBoundaryTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntervalBoundaryTypeCode;
    /**
     * The LowerBoundaryInternalID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 10
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $LowerBoundaryInternalID;
    /**
     * The UpperBoundaryInternalID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 10
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $UpperBoundaryInternalID;
    /**
     * Constructor method for CustomerSelectionByInternalID
     * @uses CustomerSelectionByInternalID::setInclusionExclusionCode()
     * @uses CustomerSelectionByInternalID::setIntervalBoundaryTypeCode()
     * @uses CustomerSelectionByInternalID::setLowerBoundaryInternalID()
     * @uses CustomerSelectionByInternalID::setUpperBoundaryInternalID()
     * @param string $inclusionExclusionCode
     * @param string $intervalBoundaryTypeCode
     * @param string $lowerBoundaryInternalID
     * @param string $upperBoundaryInternalID
     */
    public function __construct($inclusionExclusionCode = null, $intervalBoundaryTypeCode = null, $lowerBoundaryInternalID = null, $upperBoundaryInternalID = null)
    {
        $this
            ->setInclusionExclusionCode($inclusionExclusionCode)
            ->setIntervalBoundaryTypeCode($intervalBoundaryTypeCode)
            ->setLowerBoundaryInternalID($lowerBoundaryInternalID)
            ->setUpperBoundaryInternalID($upperBoundaryInternalID);
    }
    /**
     * Get InclusionExclusionCode value
     * @return string|null
     */
    public function getInclusionExclusionCode()
    {
        return $this->InclusionExclusionCode;
    }
    /**
     * Set InclusionExclusionCode value
     * @param string $inclusionExclusionCode
     * @return \StructType\CustomerSelectionByInternalID
     */
    public function setInclusionExclusionCode($inclusionExclusionCode = null)
    {
        // validation for constraint: string
        if (!is_null($inclusionExclusionCode) && !is_string($inclusionExclusionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inclusionExclusionCode, true), gettype($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        $this->InclusionExclusionCode = $inclusionExclusionCode;
        return $this;
    }
    /**
     * Get IntervalBoundaryTypeCode value
     * @return string|null
     */
    public function getIntervalBoundaryTypeCode()
    {
        return $this->IntervalBoundaryTypeCode;
    }
    /**
     * Set IntervalBoundaryTypeCode value
     * @param string $intervalBoundaryTypeCode
     * @return \StructType\CustomerSelectionByInternalID
     */
    public function setIntervalBoundaryTypeCode($intervalBoundaryTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($intervalBoundaryTypeCode) && !is_string($intervalBoundaryTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intervalBoundaryTypeCode, true), gettype($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        $this->IntervalBoundaryTypeCode = $intervalBoundaryTypeCode;
        return $this;
    }
    /**
     * Get LowerBoundaryInternalID value
     * @return string|null
     */
    public function getLowerBoundaryInternalID()
    {
        return $this->LowerBoundaryInternalID;
    }
    /**
     * Set LowerBoundaryInternalID value
     * @param string $lowerBoundaryInternalID
     * @return \StructType\CustomerSelectionByInternalID
     */
    public function setLowerBoundaryInternalID($lowerBoundaryInternalID = null)
    {
        // validation for constraint: string
        if (!is_null($lowerBoundaryInternalID) && !is_string($lowerBoundaryInternalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lowerBoundaryInternalID, true), gettype($lowerBoundaryInternalID)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($lowerBoundaryInternalID) && mb_strlen($lowerBoundaryInternalID) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($lowerBoundaryInternalID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($lowerBoundaryInternalID) && mb_strlen($lowerBoundaryInternalID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($lowerBoundaryInternalID)), __LINE__);
        }
        $this->LowerBoundaryInternalID = $lowerBoundaryInternalID;
        return $this;
    }
    /**
     * Get UpperBoundaryInternalID value
     * @return string|null
     */
    public function getUpperBoundaryInternalID()
    {
        return $this->UpperBoundaryInternalID;
    }
    /**
     * Set UpperBoundaryInternalID value
     * @param string $upperBoundaryInternalID
     * @return \StructType\CustomerSelectionByInternalID
     */
    public function setUpperBoundaryInternalID($upperBoundaryInternalID = null)
    {
        // validation for constraint: string
        if (!is_null($upperBoundaryInternalID) && !is_string($upperBoundaryInternalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upperBoundaryInternalID, true), gettype($upperBoundaryInternalID)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($upperBoundaryInternalID) && mb_strlen($upperBoundaryInternalID) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($upperBoundaryInternalID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($upperBoundaryInternalID) && mb_strlen($upperBoundaryInternalID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($upperBoundaryInternalID)), __LINE__);
        }
        $this->UpperBoundaryInternalID = $upperBoundaryInternalID;
        return $this;
    }
}
