<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerSelectionByIdentityID StructType
 * @subpackage Structs
 */
class CustomerSelectionByIdentityID extends AbstractStructBase
{
    /**
     * The InclusionExclusionCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $InclusionExclusionCode;
    /**
     * The IntervalBoundaryTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntervalBoundaryTypeCode;
    /**
     * The LowerBoundaryIdentityID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\IdentityID
     */
    public $LowerBoundaryIdentityID;
    /**
     * The UpperBoundaryIdentityID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\IdentityID
     */
    public $UpperBoundaryIdentityID;
    /**
     * Constructor method for CustomerSelectionByIdentityID
     * @uses CustomerSelectionByIdentityID::setInclusionExclusionCode()
     * @uses CustomerSelectionByIdentityID::setIntervalBoundaryTypeCode()
     * @uses CustomerSelectionByIdentityID::setLowerBoundaryIdentityID()
     * @uses CustomerSelectionByIdentityID::setUpperBoundaryIdentityID()
     * @param string $inclusionExclusionCode
     * @param string $intervalBoundaryTypeCode
     * @param \StructType\IdentityID $lowerBoundaryIdentityID
     * @param \StructType\IdentityID $upperBoundaryIdentityID
     */
    public function __construct($inclusionExclusionCode = null, $intervalBoundaryTypeCode = null, \StructType\IdentityID $lowerBoundaryIdentityID = null, \StructType\IdentityID $upperBoundaryIdentityID = null)
    {
        $this
            ->setInclusionExclusionCode($inclusionExclusionCode)
            ->setIntervalBoundaryTypeCode($intervalBoundaryTypeCode)
            ->setLowerBoundaryIdentityID($lowerBoundaryIdentityID)
            ->setUpperBoundaryIdentityID($upperBoundaryIdentityID);
    }
    /**
     * Get InclusionExclusionCode value
     * @return string|null
     */
    public function getInclusionExclusionCode()
    {
        return $this->InclusionExclusionCode;
    }
    /**
     * Set InclusionExclusionCode value
     * @param string $inclusionExclusionCode
     * @return \StructType\CustomerSelectionByIdentityID
     */
    public function setInclusionExclusionCode($inclusionExclusionCode = null)
    {
        // validation for constraint: string
        if (!is_null($inclusionExclusionCode) && !is_string($inclusionExclusionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inclusionExclusionCode, true), gettype($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        $this->InclusionExclusionCode = $inclusionExclusionCode;
        return $this;
    }
    /**
     * Get IntervalBoundaryTypeCode value
     * @return string|null
     */
    public function getIntervalBoundaryTypeCode()
    {
        return $this->IntervalBoundaryTypeCode;
    }
    /**
     * Set IntervalBoundaryTypeCode value
     * @param string $intervalBoundaryTypeCode
     * @return \StructType\CustomerSelectionByIdentityID
     */
    public function setIntervalBoundaryTypeCode($intervalBoundaryTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($intervalBoundaryTypeCode) && !is_string($intervalBoundaryTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intervalBoundaryTypeCode, true), gettype($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        $this->IntervalBoundaryTypeCode = $intervalBoundaryTypeCode;
        return $this;
    }
    /**
     * Get LowerBoundaryIdentityID value
     * @return \StructType\IdentityID|null
     */
    public function getLowerBoundaryIdentityID()
    {
        return $this->LowerBoundaryIdentityID;
    }
    /**
     * Set LowerBoundaryIdentityID value
     * @param \StructType\IdentityID $lowerBoundaryIdentityID
     * @return \StructType\CustomerSelectionByIdentityID
     */
    public function setLowerBoundaryIdentityID(\StructType\IdentityID $lowerBoundaryIdentityID = null)
    {
        $this->LowerBoundaryIdentityID = $lowerBoundaryIdentityID;
        return $this;
    }
    /**
     * Get UpperBoundaryIdentityID value
     * @return \StructType\IdentityID|null
     */
    public function getUpperBoundaryIdentityID()
    {
        return $this->UpperBoundaryIdentityID;
    }
    /**
     * Set UpperBoundaryIdentityID value
     * @param \StructType\IdentityID $upperBoundaryIdentityID
     * @return \StructType\CustomerSelectionByIdentityID
     */
    public function setUpperBoundaryIdentityID(\StructType\IdentityID $upperBoundaryIdentityID = null)
    {
        $this->UpperBoundaryIdentityID = $upperBoundaryIdentityID;
        return $this;
    }
}
