<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerSelectionByCountryCode StructType
 * @subpackage Structs
 */
class CustomerSelectionByCountryCode extends AbstractStructBase
{
    /**
     * The InclusionExclusionCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $InclusionExclusionCode;
    /**
     * The IntervalBoundaryTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntervalBoundaryTypeCode;
    /**
     * The LowerBoundaryCountryCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $LowerBoundaryCountryCode;
    /**
     * The UpperBoundaryCountryCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $UpperBoundaryCountryCode;
    /**
     * Constructor method for CustomerSelectionByCountryCode
     * @uses CustomerSelectionByCountryCode::setInclusionExclusionCode()
     * @uses CustomerSelectionByCountryCode::setIntervalBoundaryTypeCode()
     * @uses CustomerSelectionByCountryCode::setLowerBoundaryCountryCode()
     * @uses CustomerSelectionByCountryCode::setUpperBoundaryCountryCode()
     * @param string $inclusionExclusionCode
     * @param string $intervalBoundaryTypeCode
     * @param string $lowerBoundaryCountryCode
     * @param string $upperBoundaryCountryCode
     */
    public function __construct($inclusionExclusionCode = null, $intervalBoundaryTypeCode = null, $lowerBoundaryCountryCode = null, $upperBoundaryCountryCode = null)
    {
        $this
            ->setInclusionExclusionCode($inclusionExclusionCode)
            ->setIntervalBoundaryTypeCode($intervalBoundaryTypeCode)
            ->setLowerBoundaryCountryCode($lowerBoundaryCountryCode)
            ->setUpperBoundaryCountryCode($upperBoundaryCountryCode);
    }
    /**
     * Get InclusionExclusionCode value
     * @return string|null
     */
    public function getInclusionExclusionCode()
    {
        return $this->InclusionExclusionCode;
    }
    /**
     * Set InclusionExclusionCode value
     * @param string $inclusionExclusionCode
     * @return \StructType\CustomerSelectionByCountryCode
     */
    public function setInclusionExclusionCode($inclusionExclusionCode = null)
    {
        // validation for constraint: string
        if (!is_null($inclusionExclusionCode) && !is_string($inclusionExclusionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inclusionExclusionCode, true), gettype($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        $this->InclusionExclusionCode = $inclusionExclusionCode;
        return $this;
    }
    /**
     * Get IntervalBoundaryTypeCode value
     * @return string|null
     */
    public function getIntervalBoundaryTypeCode()
    {
        return $this->IntervalBoundaryTypeCode;
    }
    /**
     * Set IntervalBoundaryTypeCode value
     * @param string $intervalBoundaryTypeCode
     * @return \StructType\CustomerSelectionByCountryCode
     */
    public function setIntervalBoundaryTypeCode($intervalBoundaryTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($intervalBoundaryTypeCode) && !is_string($intervalBoundaryTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intervalBoundaryTypeCode, true), gettype($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        $this->IntervalBoundaryTypeCode = $intervalBoundaryTypeCode;
        return $this;
    }
    /**
     * Get LowerBoundaryCountryCode value
     * @return string|null
     */
    public function getLowerBoundaryCountryCode()
    {
        return $this->LowerBoundaryCountryCode;
    }
    /**
     * Set LowerBoundaryCountryCode value
     * @param string $lowerBoundaryCountryCode
     * @return \StructType\CustomerSelectionByCountryCode
     */
    public function setLowerBoundaryCountryCode($lowerBoundaryCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($lowerBoundaryCountryCode) && !is_string($lowerBoundaryCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lowerBoundaryCountryCode, true), gettype($lowerBoundaryCountryCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($lowerBoundaryCountryCode) && mb_strlen($lowerBoundaryCountryCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($lowerBoundaryCountryCode)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($lowerBoundaryCountryCode) && mb_strlen($lowerBoundaryCountryCode) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($lowerBoundaryCountryCode)), __LINE__);
        }
        $this->LowerBoundaryCountryCode = $lowerBoundaryCountryCode;
        return $this;
    }
    /**
     * Get UpperBoundaryCountryCode value
     * @return string|null
     */
    public function getUpperBoundaryCountryCode()
    {
        return $this->UpperBoundaryCountryCode;
    }
    /**
     * Set UpperBoundaryCountryCode value
     * @param string $upperBoundaryCountryCode
     * @return \StructType\CustomerSelectionByCountryCode
     */
    public function setUpperBoundaryCountryCode($upperBoundaryCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($upperBoundaryCountryCode) && !is_string($upperBoundaryCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upperBoundaryCountryCode, true), gettype($upperBoundaryCountryCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($upperBoundaryCountryCode) && mb_strlen($upperBoundaryCountryCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($upperBoundaryCountryCode)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($upperBoundaryCountryCode) && mb_strlen($upperBoundaryCountryCode) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($upperBoundaryCountryCode)), __LINE__);
        }
        $this->UpperBoundaryCountryCode = $upperBoundaryCountryCode;
        return $this;
    }
}
