<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerSelectionByCityName StructType
 * @subpackage Structs
 */
class CustomerSelectionByCityName extends AbstractStructBase
{
    /**
     * The InclusionExclusionCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $InclusionExclusionCode;
    /**
     * The IntervalBoundaryTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntervalBoundaryTypeCode;
    /**
     * The LowerBoundaryCityName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $LowerBoundaryCityName;
    /**
     * The UpperBoundaryCityName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $UpperBoundaryCityName;
    /**
     * Constructor method for CustomerSelectionByCityName
     * @uses CustomerSelectionByCityName::setInclusionExclusionCode()
     * @uses CustomerSelectionByCityName::setIntervalBoundaryTypeCode()
     * @uses CustomerSelectionByCityName::setLowerBoundaryCityName()
     * @uses CustomerSelectionByCityName::setUpperBoundaryCityName()
     * @param string $inclusionExclusionCode
     * @param string $intervalBoundaryTypeCode
     * @param string $lowerBoundaryCityName
     * @param string $upperBoundaryCityName
     */
    public function __construct($inclusionExclusionCode = null, $intervalBoundaryTypeCode = null, $lowerBoundaryCityName = null, $upperBoundaryCityName = null)
    {
        $this
            ->setInclusionExclusionCode($inclusionExclusionCode)
            ->setIntervalBoundaryTypeCode($intervalBoundaryTypeCode)
            ->setLowerBoundaryCityName($lowerBoundaryCityName)
            ->setUpperBoundaryCityName($upperBoundaryCityName);
    }
    /**
     * Get InclusionExclusionCode value
     * @return string|null
     */
    public function getInclusionExclusionCode()
    {
        return $this->InclusionExclusionCode;
    }
    /**
     * Set InclusionExclusionCode value
     * @param string $inclusionExclusionCode
     * @return \StructType\CustomerSelectionByCityName
     */
    public function setInclusionExclusionCode($inclusionExclusionCode = null)
    {
        // validation for constraint: string
        if (!is_null($inclusionExclusionCode) && !is_string($inclusionExclusionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inclusionExclusionCode, true), gettype($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        $this->InclusionExclusionCode = $inclusionExclusionCode;
        return $this;
    }
    /**
     * Get IntervalBoundaryTypeCode value
     * @return string|null
     */
    public function getIntervalBoundaryTypeCode()
    {
        return $this->IntervalBoundaryTypeCode;
    }
    /**
     * Set IntervalBoundaryTypeCode value
     * @param string $intervalBoundaryTypeCode
     * @return \StructType\CustomerSelectionByCityName
     */
    public function setIntervalBoundaryTypeCode($intervalBoundaryTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($intervalBoundaryTypeCode) && !is_string($intervalBoundaryTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intervalBoundaryTypeCode, true), gettype($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        $this->IntervalBoundaryTypeCode = $intervalBoundaryTypeCode;
        return $this;
    }
    /**
     * Get LowerBoundaryCityName value
     * @return string|null
     */
    public function getLowerBoundaryCityName()
    {
        return $this->LowerBoundaryCityName;
    }
    /**
     * Set LowerBoundaryCityName value
     * @param string $lowerBoundaryCityName
     * @return \StructType\CustomerSelectionByCityName
     */
    public function setLowerBoundaryCityName($lowerBoundaryCityName = null)
    {
        // validation for constraint: string
        if (!is_null($lowerBoundaryCityName) && !is_string($lowerBoundaryCityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lowerBoundaryCityName, true), gettype($lowerBoundaryCityName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($lowerBoundaryCityName) && mb_strlen($lowerBoundaryCityName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($lowerBoundaryCityName)), __LINE__);
        }
        $this->LowerBoundaryCityName = $lowerBoundaryCityName;
        return $this;
    }
    /**
     * Get UpperBoundaryCityName value
     * @return string|null
     */
    public function getUpperBoundaryCityName()
    {
        return $this->UpperBoundaryCityName;
    }
    /**
     * Set UpperBoundaryCityName value
     * @param string $upperBoundaryCityName
     * @return \StructType\CustomerSelectionByCityName
     */
    public function setUpperBoundaryCityName($upperBoundaryCityName = null)
    {
        // validation for constraint: string
        if (!is_null($upperBoundaryCityName) && !is_string($upperBoundaryCityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upperBoundaryCityName, true), gettype($upperBoundaryCityName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($upperBoundaryCityName) && mb_strlen($upperBoundaryCityName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($upperBoundaryCityName)), __LINE__);
        }
        $this->UpperBoundaryCityName = $upperBoundaryCityName;
        return $this;
    }
}
