<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerSelectionByBusinessPartnerID StructType
 * @subpackage Structs
 */
class CustomerSelectionByBusinessPartnerID extends AbstractStructBase
{
    /**
     * The InclusionExclusionCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $InclusionExclusionCode;
    /**
     * The IntervalBoundaryTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntervalBoundaryTypeCode;
    /**
     * The LowerBoundaryBusinessPartnerID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 60
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $LowerBoundaryBusinessPartnerID;
    /**
     * The UpperBoundaryBusinessPartnerID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 60
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $UpperBoundaryBusinessPartnerID;
    /**
     * Constructor method for CustomerSelectionByBusinessPartnerID
     * @uses CustomerSelectionByBusinessPartnerID::setInclusionExclusionCode()
     * @uses CustomerSelectionByBusinessPartnerID::setIntervalBoundaryTypeCode()
     * @uses CustomerSelectionByBusinessPartnerID::setLowerBoundaryBusinessPartnerID()
     * @uses CustomerSelectionByBusinessPartnerID::setUpperBoundaryBusinessPartnerID()
     * @param string $inclusionExclusionCode
     * @param string $intervalBoundaryTypeCode
     * @param string $lowerBoundaryBusinessPartnerID
     * @param string $upperBoundaryBusinessPartnerID
     */
    public function __construct($inclusionExclusionCode = null, $intervalBoundaryTypeCode = null, $lowerBoundaryBusinessPartnerID = null, $upperBoundaryBusinessPartnerID = null)
    {
        $this
            ->setInclusionExclusionCode($inclusionExclusionCode)
            ->setIntervalBoundaryTypeCode($intervalBoundaryTypeCode)
            ->setLowerBoundaryBusinessPartnerID($lowerBoundaryBusinessPartnerID)
            ->setUpperBoundaryBusinessPartnerID($upperBoundaryBusinessPartnerID);
    }
    /**
     * Get InclusionExclusionCode value
     * @return string|null
     */
    public function getInclusionExclusionCode()
    {
        return $this->InclusionExclusionCode;
    }
    /**
     * Set InclusionExclusionCode value
     * @param string $inclusionExclusionCode
     * @return \StructType\CustomerSelectionByBusinessPartnerID
     */
    public function setInclusionExclusionCode($inclusionExclusionCode = null)
    {
        // validation for constraint: string
        if (!is_null($inclusionExclusionCode) && !is_string($inclusionExclusionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inclusionExclusionCode, true), gettype($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        $this->InclusionExclusionCode = $inclusionExclusionCode;
        return $this;
    }
    /**
     * Get IntervalBoundaryTypeCode value
     * @return string|null
     */
    public function getIntervalBoundaryTypeCode()
    {
        return $this->IntervalBoundaryTypeCode;
    }
    /**
     * Set IntervalBoundaryTypeCode value
     * @param string $intervalBoundaryTypeCode
     * @return \StructType\CustomerSelectionByBusinessPartnerID
     */
    public function setIntervalBoundaryTypeCode($intervalBoundaryTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($intervalBoundaryTypeCode) && !is_string($intervalBoundaryTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intervalBoundaryTypeCode, true), gettype($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        $this->IntervalBoundaryTypeCode = $intervalBoundaryTypeCode;
        return $this;
    }
    /**
     * Get LowerBoundaryBusinessPartnerID value
     * @return string|null
     */
    public function getLowerBoundaryBusinessPartnerID()
    {
        return $this->LowerBoundaryBusinessPartnerID;
    }
    /**
     * Set LowerBoundaryBusinessPartnerID value
     * @param string $lowerBoundaryBusinessPartnerID
     * @return \StructType\CustomerSelectionByBusinessPartnerID
     */
    public function setLowerBoundaryBusinessPartnerID($lowerBoundaryBusinessPartnerID = null)
    {
        // validation for constraint: string
        if (!is_null($lowerBoundaryBusinessPartnerID) && !is_string($lowerBoundaryBusinessPartnerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lowerBoundaryBusinessPartnerID, true), gettype($lowerBoundaryBusinessPartnerID)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($lowerBoundaryBusinessPartnerID) && mb_strlen($lowerBoundaryBusinessPartnerID) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($lowerBoundaryBusinessPartnerID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($lowerBoundaryBusinessPartnerID) && mb_strlen($lowerBoundaryBusinessPartnerID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($lowerBoundaryBusinessPartnerID)), __LINE__);
        }
        $this->LowerBoundaryBusinessPartnerID = $lowerBoundaryBusinessPartnerID;
        return $this;
    }
    /**
     * Get UpperBoundaryBusinessPartnerID value
     * @return string|null
     */
    public function getUpperBoundaryBusinessPartnerID()
    {
        return $this->UpperBoundaryBusinessPartnerID;
    }
    /**
     * Set UpperBoundaryBusinessPartnerID value
     * @param string $upperBoundaryBusinessPartnerID
     * @return \StructType\CustomerSelectionByBusinessPartnerID
     */
    public function setUpperBoundaryBusinessPartnerID($upperBoundaryBusinessPartnerID = null)
    {
        // validation for constraint: string
        if (!is_null($upperBoundaryBusinessPartnerID) && !is_string($upperBoundaryBusinessPartnerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upperBoundaryBusinessPartnerID, true), gettype($upperBoundaryBusinessPartnerID)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($upperBoundaryBusinessPartnerID) && mb_strlen($upperBoundaryBusinessPartnerID) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($upperBoundaryBusinessPartnerID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($upperBoundaryBusinessPartnerID) && mb_strlen($upperBoundaryBusinessPartnerID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($upperBoundaryBusinessPartnerID)), __LINE__);
        }
        $this->UpperBoundaryBusinessPartnerID = $upperBoundaryBusinessPartnerID;
        return $this;
    }
}
