<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerReponseCustomerSalesArrangement StructType
 * @subpackage Structs
 */
class CustomerReponseCustomerSalesArrangement extends AbstractStructBase
{
    /**
     * The SalesOrganisationID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 20
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalesOrganisationID;
    /**
     * The DistributionChannelCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DistributionChannelCode
     */
    public $DistributionChannelCode;
    /**
     * The Incoterms
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Incoterms
     */
    public $Incoterms;
    /**
     * The DeliveryPriorityCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryPriorityCode;
    /**
     * The CompleteDeliveryRequestedIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator
     * - base: xsd:boolean
     * - minOccurs: 0
     * @var bool
     */
    public $CompleteDeliveryRequestedIndicator;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 3
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * The CustomerGroupCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomerGroupCode
     */
    public $CustomerGroupCode;
    /**
     * The CashDiscountTermsCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CashDiscountTermsCode
     */
    public $CashDiscountTermsCode;
    /**
     * Constructor method for CustomerReponseCustomerSalesArrangement
     * @uses CustomerReponseCustomerSalesArrangement::setSalesOrganisationID()
     * @uses CustomerReponseCustomerSalesArrangement::setDistributionChannelCode()
     * @uses CustomerReponseCustomerSalesArrangement::setIncoterms()
     * @uses CustomerReponseCustomerSalesArrangement::setDeliveryPriorityCode()
     * @uses CustomerReponseCustomerSalesArrangement::setCompleteDeliveryRequestedIndicator()
     * @uses CustomerReponseCustomerSalesArrangement::setCurrencyCode()
     * @uses CustomerReponseCustomerSalesArrangement::setCustomerGroupCode()
     * @uses CustomerReponseCustomerSalesArrangement::setCashDiscountTermsCode()
     * @param string $salesOrganisationID
     * @param \StructType\DistributionChannelCode $distributionChannelCode
     * @param \StructType\Incoterms $incoterms
     * @param string $deliveryPriorityCode
     * @param bool $completeDeliveryRequestedIndicator
     * @param string $currencyCode
     * @param \StructType\CustomerGroupCode $customerGroupCode
     * @param \StructType\CashDiscountTermsCode $cashDiscountTermsCode
     */
    public function __construct($salesOrganisationID = null, \StructType\DistributionChannelCode $distributionChannelCode = null, \StructType\Incoterms $incoterms = null, $deliveryPriorityCode = null, $completeDeliveryRequestedIndicator = null, $currencyCode = null, \StructType\CustomerGroupCode $customerGroupCode = null, \StructType\CashDiscountTermsCode $cashDiscountTermsCode = null)
    {
        $this
            ->setSalesOrganisationID($salesOrganisationID)
            ->setDistributionChannelCode($distributionChannelCode)
            ->setIncoterms($incoterms)
            ->setDeliveryPriorityCode($deliveryPriorityCode)
            ->setCompleteDeliveryRequestedIndicator($completeDeliveryRequestedIndicator)
            ->setCurrencyCode($currencyCode)
            ->setCustomerGroupCode($customerGroupCode)
            ->setCashDiscountTermsCode($cashDiscountTermsCode);
    }
    /**
     * Get SalesOrganisationID value
     * @return string|null
     */
    public function getSalesOrganisationID()
    {
        return $this->SalesOrganisationID;
    }
    /**
     * Set SalesOrganisationID value
     * @param string $salesOrganisationID
     * @return \StructType\CustomerReponseCustomerSalesArrangement
     */
    public function setSalesOrganisationID($salesOrganisationID = null)
    {
        // validation for constraint: string
        if (!is_null($salesOrganisationID) && !is_string($salesOrganisationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesOrganisationID, true), gettype($salesOrganisationID)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($salesOrganisationID) && mb_strlen($salesOrganisationID) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($salesOrganisationID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($salesOrganisationID) && mb_strlen($salesOrganisationID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($salesOrganisationID)), __LINE__);
        }
        $this->SalesOrganisationID = $salesOrganisationID;
        return $this;
    }
    /**
     * Get DistributionChannelCode value
     * @return \StructType\DistributionChannelCode|null
     */
    public function getDistributionChannelCode()
    {
        return $this->DistributionChannelCode;
    }
    /**
     * Set DistributionChannelCode value
     * @param \StructType\DistributionChannelCode $distributionChannelCode
     * @return \StructType\CustomerReponseCustomerSalesArrangement
     */
    public function setDistributionChannelCode(\StructType\DistributionChannelCode $distributionChannelCode = null)
    {
        $this->DistributionChannelCode = $distributionChannelCode;
        return $this;
    }
    /**
     * Get Incoterms value
     * @return \StructType\Incoterms|null
     */
    public function getIncoterms()
    {
        return $this->Incoterms;
    }
    /**
     * Set Incoterms value
     * @param \StructType\Incoterms $incoterms
     * @return \StructType\CustomerReponseCustomerSalesArrangement
     */
    public function setIncoterms(\StructType\Incoterms $incoterms = null)
    {
        $this->Incoterms = $incoterms;
        return $this;
    }
    /**
     * Get DeliveryPriorityCode value
     * @return string|null
     */
    public function getDeliveryPriorityCode()
    {
        return $this->DeliveryPriorityCode;
    }
    /**
     * Set DeliveryPriorityCode value
     * @param string $deliveryPriorityCode
     * @return \StructType\CustomerReponseCustomerSalesArrangement
     */
    public function setDeliveryPriorityCode($deliveryPriorityCode = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryPriorityCode) && !is_string($deliveryPriorityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryPriorityCode, true), gettype($deliveryPriorityCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($deliveryPriorityCode) && mb_strlen($deliveryPriorityCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($deliveryPriorityCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($deliveryPriorityCode) && mb_strlen($deliveryPriorityCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($deliveryPriorityCode)), __LINE__);
        }
        $this->DeliveryPriorityCode = $deliveryPriorityCode;
        return $this;
    }
    /**
     * Get CompleteDeliveryRequestedIndicator value
     * @return bool|null
     */
    public function getCompleteDeliveryRequestedIndicator()
    {
        return $this->CompleteDeliveryRequestedIndicator;
    }
    /**
     * Set CompleteDeliveryRequestedIndicator value
     * @param bool $completeDeliveryRequestedIndicator
     * @return \StructType\CustomerReponseCustomerSalesArrangement
     */
    public function setCompleteDeliveryRequestedIndicator($completeDeliveryRequestedIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($completeDeliveryRequestedIndicator) && !is_bool($completeDeliveryRequestedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($completeDeliveryRequestedIndicator, true), gettype($completeDeliveryRequestedIndicator)), __LINE__);
        }
        $this->CompleteDeliveryRequestedIndicator = $completeDeliveryRequestedIndicator;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\CustomerReponseCustomerSalesArrangement
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($currencyCode) && mb_strlen($currencyCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($currencyCode)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($currencyCode) && mb_strlen($currencyCode) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get CustomerGroupCode value
     * @return \StructType\CustomerGroupCode|null
     */
    public function getCustomerGroupCode()
    {
        return $this->CustomerGroupCode;
    }
    /**
     * Set CustomerGroupCode value
     * @param \StructType\CustomerGroupCode $customerGroupCode
     * @return \StructType\CustomerReponseCustomerSalesArrangement
     */
    public function setCustomerGroupCode(\StructType\CustomerGroupCode $customerGroupCode = null)
    {
        $this->CustomerGroupCode = $customerGroupCode;
        return $this;
    }
    /**
     * Get CashDiscountTermsCode value
     * @return \StructType\CashDiscountTermsCode|null
     */
    public function getCashDiscountTermsCode()
    {
        return $this->CashDiscountTermsCode;
    }
    /**
     * Set CashDiscountTermsCode value
     * @param \StructType\CashDiscountTermsCode $cashDiscountTermsCode
     * @return \StructType\CustomerReponseCustomerSalesArrangement
     */
    public function setCashDiscountTermsCode(\StructType\CashDiscountTermsCode $cashDiscountTermsCode = null)
    {
        $this->CashDiscountTermsCode = $cashDiscountTermsCode;
        return $this;
    }
}
